/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.paper.dialog;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.accounts.Transaction;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class TransactionHistoryDialog {
    public void open(@NotNull Player player, @NotNull Account account) {
        ArrayList<PlainMessageDialogBody> dialogBodyList = new ArrayList<PlainMessageDialogBody>();
        String description = player.getUniqueId().equals(account.getUuid()) ? Banco.get().getSettings().get().getDialogs().getTransactionHistory().description() : String.format(Banco.get().getSettings().get().getDialogs().getTransactionHistory().othersDescription(), account.getName());
        dialogBodyList.add(DialogBody.plainMessage((Component)MiniMessage.miniMessage().deserialize((Object)description)));
        List<Transaction.ImmutableView> transactionHistory = Banco.get().getAccountManager().getTransactionHistory().get(account);
        int limit = transactionHistory.size() > 255 ? 255 : transactionHistory.size();
        for (int i = 0; i < limit; ++i) {
            Transaction.ImmutableView transaction = transactionHistory.get(i);
            if (transaction.operation() == Transaction.Operation.SET) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat(Banco.get().getSettings().get().getDialogs().getTransactionHistory().dateFormat());
            TextComponent operationComponent = switch (transaction.operation()) {
                case Transaction.Operation.DEPOSIT -> Component.text((String)"+", (TextColor)NamedTextColor.GREEN);
                case Transaction.Operation.WITHDRAW -> Component.text((String)"-", (TextColor)NamedTextColor.RED);
                default -> Component.empty();
            };
            dialogBodyList.add(DialogBody.plainMessage((Component)((TextComponent)((TextComponent)Component.text((String)dateFormat.format(Date.from(transaction.timestamp())), (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)" | ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)operationComponent)).append((Component)Component.text((String)(MessageUtil.format(transaction.amount()) + Banco.get().getSettings().get().getCurrency().getSymbol()), (TextColor)NamedTextColor.WHITE))));
        }
        if (dialogBodyList.size() < 2) {
            dialogBodyList.add(DialogBody.plainMessage((Component)((TextComponent)Component.text((String)"Nothing to show yet.", (TextColor)NamedTextColor.GRAY).appendSpace()).append(Component.text((String)"Maybe tomorrow?", (TextColor)NamedTextColor.GRAY).decorate(TextDecoration.ITALIC))));
        }
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)MiniMessage.miniMessage().deserialize((Object)Banco.get().getSettings().get().getDialogs().getTransactionHistory().title())).body(dialogBodyList).build()).type((DialogType)DialogType.notice()));
        player.showDialog((DialogLike)dialog);
    }
}

