/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.gestalt.loader;

import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import ovh.mythmc.gestalt.loader.GestaltLoader;
import ovh.mythmc.gestalt.loader.GestaltLoggerWrapper;
import ovh.mythmc.gestalt.loader.util.PaperPluginClassLoaderUtil;

public class PaperGestaltLoader
extends GestaltLoader {
    private final Plugin initializer;
    private final Path dataDirectory;
    private final GestaltLoggerWrapper logger;

    @Override
    protected void load() {
        File file = new File(this.getGestaltPath());
        Plugin plugin = null;
        try {
            plugin = Bukkit.getPluginManager().loadPlugin(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (plugin != null) {
            Bukkit.getPluginManager().enablePlugin(plugin);
            PaperPluginClassLoaderUtil.mergeClassLoaders(this.initializer, plugin);
        }
    }

    @Override
    protected boolean isAvailable() {
        return PaperPluginClassLoaderUtil.isAccessible(this.initializer, "ovh.mythmc.gestalt.Gestalt");
    }

    @Generated
    public static PaperGestaltLoaderBuilder builder() {
        return new PaperGestaltLoaderBuilder();
    }

    @Generated
    private PaperGestaltLoader(Plugin initializer, Path dataDirectory, GestaltLoggerWrapper logger) {
        this.initializer = initializer;
        this.dataDirectory = dataDirectory;
        this.logger = logger;
    }

    @Generated
    public Plugin getInitializer() {
        return this.initializer;
    }

    @Override
    @Generated
    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    @Generated
    public GestaltLoggerWrapper getLogger() {
        return this.logger;
    }

    public static class PaperGestaltLoaderBuilder {
        @Generated
        private Plugin initializer;
        @Generated
        private Path dataDirectory;
        @Generated
        private GestaltLoggerWrapper logger;

        public PaperGestaltLoaderBuilder initializer(Plugin initializer) {
            this.initializer = initializer;
            this.dataDirectory = Path.of(initializer.getDataFolder().getParent(), new String[0]);
            this.logger = GestaltLoggerWrapper.fromLogger(initializer.getLogger(), true);
            return this;
        }

        @Generated
        PaperGestaltLoaderBuilder() {
        }

        @Generated
        public PaperGestaltLoaderBuilder dataDirectory(Path dataDirectory) {
            this.dataDirectory = dataDirectory;
            return this;
        }

        @Generated
        public PaperGestaltLoaderBuilder logger(GestaltLoggerWrapper logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public PaperGestaltLoader build() {
            return new PaperGestaltLoader(this.initializer, this.dataDirectory, this.logger);
        }

        @Generated
        public String toString() {
            return "PaperGestaltLoader.PaperGestaltLoaderBuilder(initializer=" + String.valueOf(this.initializer) + ", dataDirectory=" + String.valueOf(this.dataDirectory) + ", logger=" + String.valueOf(this.logger) + ")";
        }
    }
}

