/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.account;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.callback.account.BancoAccountUnregister;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoAccountUnregisterCallback {
    public static final BancoAccountUnregisterCallback INSTANCE = new BancoAccountUnregisterCallback();
    private final HashMap<String, BancoAccountUnregisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoAccountUnregisterCallbackListener> callbackListeners = new HashMap();

    private BancoAccountUnregisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoAccountUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoAccountUnregisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoAccountUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoAccountUnregisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoAccountUnregister callback, Consumer<BancoAccountUnregister> result) {
        for (BancoAccountUnregisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoAccountUnregisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.account()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoAccountUnregister callback, Consumer<BancoAccountUnregister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoAccountUnregister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoAccountUnregister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoAccountUnregisterCallbackHandler {
        public void handle(BancoAccountUnregister var1);
    }

    @FunctionalInterface
    public static interface BancoAccountUnregisterCallbackListener {
        public void trigger(Account var1);
    }
}

