/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.callback.item.BancoItemRegister;
import ovh.mythmc.banco.api.items.BancoItem;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoItemRegisterCallback {
    public static final BancoItemRegisterCallback INSTANCE = new BancoItemRegisterCallback();
    private final HashMap<String, BancoItemRegisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoItemRegisterCallbackListener> callbackListeners = new HashMap();

    private BancoItemRegisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoItemRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoItemRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoItemRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoItemRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoItemRegister callback, Consumer<BancoItemRegister> result) {
        for (BancoItemRegisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoItemRegisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.bancoItem()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoItemRegister callback, Consumer<BancoItemRegister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoItemRegister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoItemRegister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoItemRegisterCallbackHandler {
        public void handle(BancoItemRegister var1);
    }

    @FunctionalInterface
    public static interface BancoItemRegisterCallbackListener {
        public void trigger(BancoItem var1);
    }
}

