/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.callback.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import ovh.mythmc.banco.api.callback.storage.BancoStorageRegister;
import ovh.mythmc.banco.api.storage.BancoStorage;
import ovh.mythmc.callbacks.key.IdentifierKey;

public final class BancoStorageRegisterCallback {
    public static final BancoStorageRegisterCallback INSTANCE = new BancoStorageRegisterCallback();
    private final HashMap<String, BancoStorageRegisterCallbackHandler> callbackHandlers = new HashMap();
    private final HashMap<String, BancoStorageRegisterCallbackListener> callbackListeners = new HashMap();

    private BancoStorageRegisterCallback() {
    }

    public void registerHandler(IdentifierKey identifier, BancoStorageRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(identifier.toString(), callbackHandler);
    }

    public void registerHandler(String key, BancoStorageRegisterCallbackHandler callbackHandler) {
        this.callbackHandlers.put(key, callbackHandler);
    }

    public void unregisterHandlers(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackHandlers.remove(key.toString()));
    }

    public void unregisterHandlers(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackHandlers::remove);
    }

    public void registerListener(IdentifierKey identifier, BancoStorageRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(identifier.toString(), callbackListener);
    }

    public void registerListener(String key, BancoStorageRegisterCallbackListener callbackListener) {
        this.callbackListeners.put(key, callbackListener);
    }

    public void unregisterListeners(IdentifierKey ... identifiers) {
        Arrays.stream(identifiers).forEach(key -> this.callbackListeners.remove(key.toString()));
    }

    public void unregisterListeners(String ... identifiers) {
        Arrays.stream(identifiers).forEach(this.callbackListeners::remove);
    }

    public void invoke(BancoStorageRegister callback, Consumer<BancoStorageRegister> result) {
        for (BancoStorageRegisterCallbackHandler handler : this.callbackHandlers.values()) {
            handler.handle(callback);
        }
        for (BancoStorageRegisterCallbackListener listener : this.callbackListeners.values()) {
            CompletableFuture.runAsync(() -> listener.trigger(callback.bancoStorage()));
        }
        if (result != null) {
            result.accept(callback);
        }
    }

    @Deprecated
    public void handle(BancoStorageRegister callback, Consumer<BancoStorageRegister> result) {
        this.invoke(callback, result);
    }

    public void invoke(BancoStorageRegister callback) {
        this.handle(callback, null);
    }

    @Deprecated
    public void handle(BancoStorageRegister callback) {
        this.invoke(callback);
    }

    @FunctionalInterface
    public static interface BancoStorageRegisterCallbackHandler {
        public void handle(BancoStorageRegister var1);
    }

    @FunctionalInterface
    public static interface BancoStorageRegisterCallbackListener {
        public void trigger(BancoStorage var1);
    }
}

