/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.configuration.sections;

import lombok.Generated;
import ovh.mythmc.banco.libs.de.exlll.configlib.Comment;
import ovh.mythmc.banco.libs.de.exlll.configlib.Configuration;

@Configuration
public class DatabaseConfig {
    @Comment(value={"Database type (SQLITE or MYSQL)"})
    private DatabaseType type = DatabaseType.SQLITE;
    @Comment(value={"MySQL connection"})
    private String host = "localhost";
    private int port = 3306;
    private String database = "banco";
    private String username = "";
    private String password = "";
    @Comment(value={"Time between each cache clean in minutes"})
    private int cacheClearInterval = 5;
    @Comment(value={"Don't change this, you might lose all your data"})
    private int databaseVersion = 0;
    @Comment(value={"Don't change this, you might lose all your data"})
    private boolean initialized = false;

    public void setVersion(int version) {
        this.databaseVersion = version;
    }

    public void setDatabaseInitialized() {
        this.initialized = true;
    }

    @Generated
    public DatabaseType getType() {
        return this.type;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public int getCacheClearInterval() {
        return this.cacheClearInterval;
    }

    @Generated
    public int getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    public static enum DatabaseType {
        SQLITE,
        MYSQL;

    }
}

