/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.api.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.callback.item.BancoItemRegister;
import ovh.mythmc.banco.api.callback.item.BancoItemRegisterCallback;
import ovh.mythmc.banco.api.callback.item.BancoItemUnregister;
import ovh.mythmc.banco.api.callback.item.BancoItemUnregisterCallback;
import ovh.mythmc.banco.api.items.BancoItem;

public final class BancoItemRegistry {
    public static final BancoItemRegistry instance = new BancoItemRegistry();
    private final List<BancoItem> itemList = new ArrayList<BancoItem>();
    public final NamespacedKey CUSTOM_ITEM_IDENTIFIER_KEY = new NamespacedKey("banco", "identifier");

    public void register(BancoItem ... items) {
        Arrays.asList(items).forEach(bancoItem -> {
            BancoItemRegister callback = new BancoItemRegister((BancoItem)bancoItem);
            BancoItemRegisterCallback.INSTANCE.invoke(callback, result -> this.itemList.add(result.bancoItem()));
        });
    }

    public void unregister(BancoItem ... items) {
        Arrays.asList(items).forEach(bancoItem -> {
            BancoItemUnregister callback = new BancoItemUnregister((BancoItem)bancoItem);
            BancoItemUnregisterCallback.INSTANCE.invoke(callback, result -> this.itemList.remove(result.bancoItem()));
        });
    }

    @ApiStatus.Internal
    public void clear() {
        this.itemList.clear();
    }

    public List<BancoItem> get() {
        return List.copyOf(this.itemList);
    }

    public BancoItem getByItemStack(@NotNull ItemStack itemStack) {
        for (BancoItem item : this.get()) {
            if (!item.match(itemStack)) continue;
            return item;
        }
        return null;
    }

    public boolean isValid(ItemStack item) {
        return this.getByItemStack(item) != null;
    }

    public boolean isLegacy() {
        return Banco.get().getSettings().get().getCurrency().getItems() != null;
    }

    @Generated
    private BancoItemRegistry() {
    }
}

