/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.command.commands;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.jetbrains.annotations.NotNull;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.common.command.MainCommand;
import ovh.mythmc.banco.common.command.parser.AccountParser;
import ovh.mythmc.banco.common.command.sender.BancoCommandSource;
import ovh.mythmc.banco.common.util.MessageUtil;

public final class BalanceCommand
implements MainCommand {
    @Override
    public boolean canRegister() {
        return Banco.get().getSettings().get().getCommands().getBalance().enabled();
    }

    @Override
    public void register(@NotNull CommandManager<BancoCommandSource> commandManager) {
        Command.Builder<BancoCommandSource> balanceCommand = commandManager.commandBuilder("balance", "bal", "money").permission("banco.use.balance").commandDescription(Description.of("Displays your current balance"));
        commandManager.command(balanceCommand.optional("account", AccountParser.accountParser()).handler(ctx -> {
            if (!ctx.contains("account") && !((BancoCommandSource)ctx.sender()).isPlayer()) {
                return;
            }
            Account account = ctx.getOrDefault("account", Banco.get().getAccountManager().getByName(((BancoCommandSource)ctx.sender()).name()));
            if (!ctx.contains("account")) {
                MessageUtil.info((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.balance", (ComponentLike[])new ComponentLike[]{Component.text((String)MessageUtil.format(account.amount())), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
            } else {
                MessageUtil.info((Audience)ctx.sender(), (Component)Component.translatable((String)"banco.commands.balance.others", (ComponentLike[])new ComponentLike[]{Component.text((String)account.getName()), Component.text((String)MessageUtil.format(account.amount())), Component.text((String)Banco.get().getSettings().get().getCurrency().getSymbol())}));
            }
        }));
    }
}

