/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.hooks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import ovh.mythmc.banco.api.Banco;
import ovh.mythmc.banco.api.accounts.Account;
import ovh.mythmc.banco.api.logger.LoggerWrapper;
import ovh.mythmc.banco.api.util.PlayerUtil;
import ovh.mythmc.banco.common.util.MessageUtil;

public class BancoVaultHook
implements Economy {
    private final LoggerWrapper logger = new LoggerWrapper(this){

        @Override
        public void info(String message, Object ... args) {
            Banco.get().getLogger().info("[vault-impl] " + message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            Banco.get().getLogger().warn("[vault-impl] " + message, args);
        }

        @Override
        public void error(String message, Object ... args) {
            Banco.get().getLogger().error("[vault-impl] " + message, args);
        }
    };

    public void hook(Plugin plugin) {
        Bukkit.getServer().getServicesManager().register(Economy.class, (Object)this, plugin, ServicePriority.Highest);
        this.logger.info("Hooked with Vault " + Bukkit.getPluginManager().getPlugin("Vault").getDescription().getVersion(), new Object[0]);
    }

    public void unhook() {
        Bukkit.getServicesManager().unregister(Economy.class, (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "banco";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        DecimalFormat format = new DecimalFormat(Banco.get().getSettings().get().getCurrency().getFormat());
        return format.getMaximumFractionDigits();
    }

    public String format(double v) {
        return MessageUtil.format(BigDecimal.valueOf(v)) + Banco.get().getSettings().get().getCurrency().getSymbol();
    }

    public String currencyNamePlural() {
        return Banco.get().getSettings().get().getCurrency().getNamePlural();
    }

    public String currencyNameSingular() {
        return Banco.get().getSettings().get().getCurrency().getNameSingular();
    }

    public boolean hasAccount(String s2) {
        return Banco.get().getAccountManager().getByName(s2) != null;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return Banco.get().getAccountManager().getByUuid(offlinePlayer.getUniqueId()) != null;
    }

    public boolean hasAccount(String s2, String s1) {
        return this.hasAccount(s2);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s2) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String s2) {
        if (!this.hasAccount(s2)) {
            return 0.0;
        }
        Account account = Banco.get().getAccountManager().getByName(s2);
        if (PlayerUtil.isInBlacklistedWorld(account.getUuid())) {
            return 0.0;
        }
        return Banco.get().getAccountManager().amount(account).doubleValue();
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        if (!this.hasAccount(offlinePlayer)) {
            return 0.0;
        }
        Account account = Banco.get().getAccountManager().getByUuid(offlinePlayer.getUniqueId());
        if (PlayerUtil.isInBlacklistedWorld(account.getUuid())) {
            return 0.0;
        }
        return Banco.get().getAccountManager().amount(account).doubleValue();
    }

    public double getBalance(String s2, String s1) {
        return this.getBalance(s2);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s2) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String s2, double v) {
        return this.getBalance(s2) >= v;
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        return this.getBalance(offlinePlayer) >= v;
    }

    public boolean has(String s2, String s1, double v) {
        return this.has(s2, v);
    }

    public boolean has(OfflinePlayer offlinePlayer, String s2, double v) {
        return this.has(offlinePlayer, v);
    }

    public EconomyResponse withdrawPlayer(String s2, double v) {
        UUID uuid = Banco.get().getAccountManager().getUuidResolver().resolve(s2).orElse(null);
        if (!this.hasAccount(s2)) {
            Banco.get().getAccountManager().create(uuid);
        }
        if (PlayerUtil.isInBlacklistedWorld(uuid)) {
            return new EconomyResponse(0.0, this.getBalance(Bukkit.getOfflinePlayer((UUID)uuid)), EconomyResponse.ResponseType.FAILURE, "Player is in blacklisted world");
        }
        Banco.get().getAccountManager().withdraw(uuid, BigDecimal.valueOf(v));
        return new EconomyResponse(v, this.getBalance(Bukkit.getOfflinePlayer((UUID)uuid)), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double v) {
        UUID uuid = offlinePlayer.getUniqueId();
        if (!this.hasAccount(offlinePlayer)) {
            Banco.get().getAccountManager().create(uuid);
        }
        if (PlayerUtil.isInBlacklistedWorld(uuid)) {
            return new EconomyResponse(0.0, this.getBalance(offlinePlayer), EconomyResponse.ResponseType.FAILURE, "Player is in blacklisted world");
        }
        Banco.get().getAccountManager().withdraw(uuid, BigDecimal.valueOf(v));
        return new EconomyResponse(v, this.getBalance(offlinePlayer), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(String s2, String s1, double v) {
        return this.withdrawPlayer(s2, v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s2, double v) {
        return this.withdrawPlayer(offlinePlayer, v);
    }

    public EconomyResponse depositPlayer(String s2, double v) {
        UUID uuid = Banco.get().getAccountManager().getUuidResolver().resolve(s2).orElse(null);
        if (!this.hasAccount(s2)) {
            Banco.get().getAccountManager().create(uuid);
        }
        if (PlayerUtil.isInBlacklistedWorld(uuid)) {
            return new EconomyResponse(0.0, this.getBalance(Bukkit.getOfflinePlayer((UUID)uuid)), EconomyResponse.ResponseType.FAILURE, "Player is in blacklisted world");
        }
        Banco.get().getAccountManager().deposit(uuid, BigDecimal.valueOf(v));
        return new EconomyResponse(v, this.getBalance(Bukkit.getOfflinePlayer((UUID)uuid)), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double v) {
        UUID uuid = offlinePlayer.getUniqueId();
        if (!this.hasAccount(offlinePlayer)) {
            Banco.get().getAccountManager().create(uuid);
        }
        if (PlayerUtil.isInBlacklistedWorld(uuid)) {
            return new EconomyResponse(0.0, this.getBalance(offlinePlayer), EconomyResponse.ResponseType.FAILURE, "Player is in blacklisted world");
        }
        Banco.get().getAccountManager().deposit(uuid, BigDecimal.valueOf(v));
        return new EconomyResponse(v, this.getBalance(offlinePlayer), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(String s2, String s1, double v) {
        return this.depositPlayer(s2, v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s2, double v) {
        return this.depositPlayer(offlinePlayer, v);
    }

    public EconomyResponse createBank(String s2, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse createBank(String s2, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse deleteBank(String s2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse bankBalance(String s2) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse bankHas(String s2, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse bankWithdraw(String s2, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse bankDeposit(String s2, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse isBankOwner(String s2, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse isBankOwner(String s2, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse isBankMember(String s2, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public EconomyResponse isBankMember(String s2, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not implemented in " + this.getName());
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String s2) {
        if (this.hasAccount(s2)) {
            return false;
        }
        UUID uuid = Banco.get().getAccountManager().getUuidResolver().resolve(s2).orElse(UUID.nameUUIDFromBytes(s2.getBytes()));
        Banco.get().getAccountManager().create(uuid);
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        if (this.hasAccount(offlinePlayer)) {
            return false;
        }
        UUID uuid = offlinePlayer.getUniqueId();
        Banco.get().getAccountManager().create(uuid);
        return true;
    }

    public boolean createPlayerAccount(String s2, String s1) {
        return this.createPlayerAccount(s2);
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s2) {
        return this.createPlayerAccount(offlinePlayer);
    }
}

