/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.common.menus;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import ovh.mythmc.banco.common.menus.MenuButton;
import ovh.mythmc.banco.common.menus.MenuHandler;

public abstract class BasicMenu
implements MenuHandler {
    private final Inventory inventory;
    private final Map<Integer, MenuButton> inventoryButtons = new HashMap<Integer, MenuButton>();

    public BasicMenu() {
        this.inventory = this.createInventory();
    }

    public void addButton(int slot, MenuButton button) {
        this.inventoryButtons.put(slot, button);
    }

    public void decorate() {
        this.inventoryButtons.forEach((slot, button) -> this.inventory.setItem(slot.intValue(), button.getIcon()));
    }

    public void update() {
        this.inventory.getViewers().forEach(viewer -> {
            viewer.closeInventory();
            viewer.openInventory(this.getInventory());
        });
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        event.setCancelled(true);
        MenuButton button = this.inventoryButtons.get(event.getSlot());
        if (button != null) {
            button.onClick(event);
        }
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        this.decorate();
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
    }

    protected abstract Inventory createInventory();

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }
}

