/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.com.j256.ormlite.table;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.DatabaseFieldConfig;
import ovh.mythmc.banco.libs.com.j256.ormlite.field.DatabaseFieldConfigLoader;
import ovh.mythmc.banco.libs.com.j256.ormlite.table.DatabaseTableConfig;

public class DatabaseTableConfigLoader {
    private static final String CONFIG_FILE_START_MARKER = "# --table-start--";
    private static final String CONFIG_FILE_END_MARKER = "# --table-end--";
    private static final String CONFIG_FILE_FIELDS_START = "# --table-fields-start--";
    private static final String CONFIG_FILE_FIELDS_END = "# --table-fields-end--";
    private static final String FIELD_NAME_DATA_CLASS = "dataClass";
    private static final String FIELD_NAME_TABLE_NAME = "tableName";
    private static final String FIELD_NAME_SCHEMA_NAME = "schemaName";

    public static List<DatabaseTableConfig<?>> loadDatabaseConfigFromReader(BufferedReader reader) throws SQLException {
        DatabaseTableConfig config;
        ArrayList list = new ArrayList();
        while ((config = DatabaseTableConfigLoader.fromReader(reader)) != null) {
            list.add(config);
        }
        return list;
    }

    public static <T> DatabaseTableConfig<T> fromReader(BufferedReader reader) throws SQLException {
        DatabaseTableConfig config = new DatabaseTableConfig();
        boolean anything = false;
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new SQLException("Could not read DatabaseTableConfig from stream", e);
            }
            if (line == null || line.equals(CONFIG_FILE_END_MARKER)) break;
            if (line.equals(CONFIG_FILE_FIELDS_START)) {
                DatabaseTableConfigLoader.readFields(reader, config);
                continue;
            }
            if (line.length() == 0 || line.startsWith("#") || line.equals(CONFIG_FILE_START_MARKER)) continue;
            String[] parts = line.split("=", -2);
            if (parts.length != 2) {
                throw new SQLException("DatabaseTableConfig reading from stream cannot parse line: " + line);
            }
            DatabaseTableConfigLoader.readTableField(config, parts[0], parts[1]);
            anything = true;
        }
        if (anything) {
            return config;
        }
        return null;
    }

    public static <T> void write(BufferedWriter writer, DatabaseTableConfig<T> config) throws SQLException {
        try {
            DatabaseTableConfigLoader.writeConfig(writer, config);
        }
        catch (IOException e) {
            throw new SQLException("Could not write config to writer", e);
        }
    }

    private static <T> void writeConfig(BufferedWriter writer, DatabaseTableConfig<T> config) throws IOException, SQLException {
        writer.append(CONFIG_FILE_START_MARKER);
        writer.newLine();
        if (config.getDataClass() != null) {
            writer.append(FIELD_NAME_DATA_CLASS).append('=').append(config.getDataClass().getName());
            writer.newLine();
        }
        if (config.getSchemaName() != null) {
            writer.append(FIELD_NAME_SCHEMA_NAME).append('=').append(config.getSchemaName());
            writer.newLine();
        }
        if (config.getTableName() != null) {
            writer.append(FIELD_NAME_TABLE_NAME).append('=').append(config.getTableName());
            writer.newLine();
        }
        writer.append(CONFIG_FILE_FIELDS_START);
        writer.newLine();
        if (config.getFieldConfigs() != null) {
            for (DatabaseFieldConfig field : config.getFieldConfigs()) {
                DatabaseFieldConfigLoader.write(writer, field, config.getTableName());
            }
        }
        writer.append(CONFIG_FILE_FIELDS_END);
        writer.newLine();
        writer.append(CONFIG_FILE_END_MARKER);
        writer.newLine();
    }

    private static <T> void readTableField(DatabaseTableConfig<T> config, String field, String value) {
        if (field.equals(FIELD_NAME_DATA_CLASS)) {
            try {
                Class<?> clazz = Class.forName(value);
                config.setDataClass(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown class specified for dataClass: " + value);
            }
        } else if (field.equals(FIELD_NAME_TABLE_NAME)) {
            config.setTableName(value);
        } else if (field.equals(FIELD_NAME_SCHEMA_NAME)) {
            config.setSchemaName(value);
        }
    }

    private static <T> void readFields(BufferedReader reader, DatabaseTableConfig<T> config) throws SQLException {
        ArrayList<DatabaseFieldConfig> fields = new ArrayList<DatabaseFieldConfig>();
        while (true) {
            DatabaseFieldConfig fieldConfig;
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new SQLException("Could not read next field from config file", e);
            }
            if (line == null || line.equals(CONFIG_FILE_FIELDS_END) || (fieldConfig = DatabaseFieldConfigLoader.fromReader(reader)) == null) break;
            fields.add(fieldConfig);
        }
        config.setFieldConfigs(fields);
    }
}

