/*
 * Decompiled with CFR 0.152.
 */
package ovh.mythmc.banco.libs.de.exlll.configlib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationElement;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationElements;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationException;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationProperties;
import ovh.mythmc.banco.libs.de.exlll.configlib.ConfigurationSerializer;
import ovh.mythmc.banco.libs.de.exlll.configlib.NameFormatter;
import ovh.mythmc.banco.libs.de.exlll.configlib.PostProcess;
import ovh.mythmc.banco.libs.de.exlll.configlib.RecordSerializer;
import ovh.mythmc.banco.libs.de.exlll.configlib.Reflect;
import ovh.mythmc.banco.libs.de.exlll.configlib.Serializer;
import ovh.mythmc.banco.libs.de.exlll.configlib.SerializerSelector;
import ovh.mythmc.banco.libs.de.exlll.configlib.Validator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class TypeSerializer<T, E extends ConfigurationElement<?>>
implements Serializer<T, Map<?, ?>> {
    protected final Class<T> type;
    protected final ConfigurationProperties properties;
    protected final NameFormatter formatter;
    protected final Map<String, Serializer<?, ?>> serializers;
    protected final UnaryOperator<T> postProcessor;

    protected TypeSerializer(Class<T> type, ConfigurationProperties properties) {
        this.type = Validator.requireNonNull(type, "type");
        this.properties = Validator.requireNonNull(properties, "configuration properties");
        this.formatter = properties.getNameFormatter();
        this.serializers = this.buildSerializerMap();
        this.postProcessor = this.createPostProcessorFromAnnotatedMethod();
        this.requireSerializableElements();
    }

    static <T> TypeSerializer<T, ?> newSerializerFor(Class<T> type, ConfigurationProperties properties) {
        return type.isRecord() ? new RecordSerializer<T>(type, properties) : new ConfigurationSerializer<T>(type, properties);
    }

    Map<String, Serializer<?, ?>> buildSerializerMap() {
        SerializerSelector selector = new SerializerSelector(this.properties);
        try {
            return this.elements().stream().collect(Collectors.toMap(ConfigurationElement::name, selector::select));
        }
        catch (StackOverflowError error) {
            String msg = "Recursive type definitions are not supported.";
            throw new ConfigurationException(msg, error);
        }
    }

    @Override
    public final Map<?, ?> serialize(T configuration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ConfigurationElement element : this.elements()) {
            Object elementValue = element.value(configuration);
            if (elementValue == null && !this.properties.outputNulls()) continue;
            Object serializedValue = this.serializeElement(element, elementValue);
            String formattedName = this.formatter.format(element.name());
            result.put(formattedName, serializedValue);
        }
        return result;
    }

    protected final Object serializeElement(E element, Object value) {
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            return value != null ? serializer.serialize(value) : null;
        }
        catch (ClassCastException e) {
            String msg = "Serialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be serialized does not match the type the custom serializer of type '%s' expects.".formatted(value, element.element(), element.declaringType(), serializer.getClass());
            throw new ConfigurationException(msg, e);
        }
    }

    protected final Object deserialize(E element, Object value) {
        Object deserialized;
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            deserialized = serializer.deserialize(value);
        }
        catch (ClassCastException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value) + "\nThe type of the object to be deserialized does not match the type the deserializer expects.";
            throw new ConfigurationException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value);
            throw new ConfigurationException(msg, e);
        }
        return deserialized;
    }

    protected final Object[] deserializeConfigurationElements(Map<?, ?> serializedConfiguration) {
        List<E> elements = this.elements();
        Object[] result = new Object[elements.size()];
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationElement element = (ConfigurationElement)elements.get(i);
            String formattedName = this.formatter.format(element.name());
            if (!serializedConfiguration.containsKey(formattedName)) {
                Object defaultValue = this.getDefaultValueOf(element);
                result[i] = this.applyPostProcessorForElement(element, defaultValue);
                continue;
            }
            Object serializedValue = serializedConfiguration.get(formattedName);
            result[i] = serializedValue == null && this.properties.inputNulls() ? null : (serializedValue == null ? this.getDefaultValueOf(element) : this.deserialize(element, serializedValue));
            result[i] = this.applyPostProcessorForElement(element, result[i]);
        }
        return result;
    }

    private Object applyPostProcessorForElement(ConfigurationElement<?> element, Object deserializeValue) {
        Object result = deserializeValue;
        boolean postProcessed = false;
        for (Map.Entry<Predicate<ConfigurationElement<?>>, UnaryOperator<?>> entry : this.properties.getPostProcessorsByCondition().entrySet()) {
            Predicate<ConfigurationElement<?>> condition = entry.getKey();
            if (!condition.test(element)) continue;
            UnaryOperator<?> postProcessor = entry.getValue();
            result = TypeSerializer.tryApplyPostProcessorForElement(element, postProcessor, result);
            postProcessed = true;
        }
        if (result == null && postProcessed) {
            TypeSerializer.requirePostProcessorDoesNotReturnNullForPrimitiveElement(element);
        } else if (result == null) {
            TypeSerializer.requireNonPrimitiveType(element);
        }
        return result;
    }

    private static Object tryApplyPostProcessorForElement(ConfigurationElement<?> element, UnaryOperator<?> postProcessor, Object value) {
        try {
            UnaryOperator<?> pp = postProcessor;
            return pp.apply(value);
        }
        catch (ClassCastException e) {
            String msg = "Deserialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be deserialized does not match the type post-processor '%s' expects.".formatted(value, element.element(), element.declaringType(), postProcessor);
            throw new ConfigurationException(msg, e);
        }
    }

    private static void requirePostProcessorDoesNotReturnNullForPrimitiveElement(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.RecordComponentElement) {
            ConfigurationElements.RecordComponentElement recordComponentElement = (ConfigurationElements.RecordComponentElement)element;
            RecordComponent component = recordComponentElement.element();
            String msg = "Post-processors must not return null for primitive record components but some post-processor of component '%s' of record type '%s' does.".formatted(component, component.getDeclaringRecord());
            throw new ConfigurationException(msg);
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = "Post-processors must not return null for primitive fields but some post-processor of field '%s' does.".formatted(field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException("Unhandled ConfigurationElement: " + element);
    }

    private static void requireNonPrimitiveType(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.RecordComponentElement) {
            ConfigurationElements.RecordComponentElement recordComponentElement = (ConfigurationElements.RecordComponentElement)element;
            RecordComponent component = recordComponentElement.element();
            String msg = "Cannot set component '%s' of record type '%s' to null. Primitive types cannot be assigned null values.".formatted(component, component.getDeclaringRecord());
            throw new ConfigurationException(msg);
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = "Cannot set field '%s' to null value. Primitive types cannot be assigned null.".formatted(field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException("Unhandled ConfigurationElement: " + element);
    }

    final UnaryOperator<T> createPostProcessorFromAnnotatedMethod() {
        List<Method> list = Arrays.stream(this.type.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(PostProcess.class)).filter(Predicate.not(Method::isSynthetic)).filter(Predicate.not(this::isAccessorMethod)).toList();
        if (list.isEmpty()) {
            return UnaryOperator.identity();
        }
        if (list.size() > 1) {
            String methodNames = String.join((CharSequence)"\n  ", list.stream().map(Method::toString).toList());
            String msg = "Configuration types must not define more than one method for " + "post-processing but type '%s' defines %d:\n  %s".formatted(this.type, list.size(), methodNames);
            throw new ConfigurationException(msg);
        }
        Method method2 = list.get(0);
        int modifiers = method2.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) {
            String msg = "Post-processing methods must be neither abstract nor static, " + "but post-processing method '%s' of type '%s' is.".formatted(method2, this.type);
            throw new ConfigurationException(msg);
        }
        int parameterCount = method2.getParameterCount();
        if (parameterCount > 0) {
            String msg = "Post-processing methods must not define any parameters but " + "post-processing method '%s' of type '%s' defines %d.".formatted(method2, this.type, parameterCount);
            throw new ConfigurationException(msg);
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE && returnType != this.type) {
            String msg = "The return type of post-processing methods must either be 'void' or the same type as the configuration type in which the post-processing method is defined. The return type of the post-processing method of " + "type '%s' is neither 'void' nor '%s'.".formatted(this.type, this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
        return object -> {
            if (method2.getReturnType() == Void.TYPE) {
                Reflect.invoke(method2, object, new Object[0]);
                return object;
            }
            Object result = Reflect.invoke(method2, object, new Object[0]);
            return result;
        };
    }

    final boolean isAccessorMethod(Method method) {
        if (!this.type.isRecord()) {
            return false;
        }
        if (!method.getDeclaringClass().equals(this.type)) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        return Arrays.stream(this.type.getRecordComponents()).map(RecordComponent::getName).anyMatch(s2 -> s2.equals(method.getName()));
    }

    protected abstract void requireSerializableElements();

    protected abstract String baseDeserializeExceptionMessage(E var1, Object var2);

    protected abstract List<E> elements();

    protected abstract Object getDefaultValueOf(E var1);

    abstract T newDefaultInstance();
}

