/*
 * Decompiled with CFR 0.152.
 */
package org.endera.enderaopenchat.listeners;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.endera.enderalib.adventure.MinimessageKt;
import org.endera.enderaopenchat.EnderaOpenChat;
import org.endera.enderaopenchat.config.ConfigScheme;
import org.endera.enderaopenchat.utils.PapiUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/endera/enderaopenchat/listeners/LeaveJoinDeathListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "config", "Lorg/endera/enderaopenchat/config/ConfigScheme;", "getConfig", "()Lorg/endera/enderaopenchat/config/ConfigScheme;", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "EnderaOpenChat"})
public final class LeaveJoinDeathListener
implements Listener {
    @NotNull
    private final ConfigScheme config = EnderaOpenChat.Companion.getConfig();

    @NotNull
    public final ConfigScheme getConfig() {
        return this.config;
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.config.getCustomLeaveJoinDeath().getJoinMessage().getEnabled()) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)this.config.getCustomLeaveJoinDeath().getJoinMessage().getMessage())) {
            event.joinMessage(null);
            return;
        }
        String string = this.config.getCustomLeaveJoinDeath().getJoinMessage().getMessage();
        String string2 = event.getPlayer().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = StringsKt.replace$default((String)string, (String)"{player}", (String)string2, (boolean)false, (int)4, null);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        event.joinMessage(MinimessageKt.stringToComponent((String)PapiUtilKt.papiParse(string3, player)));
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.config.getCustomLeaveJoinDeath().getLeaveMessage().getEnabled()) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)this.config.getCustomLeaveJoinDeath().getLeaveMessage().getMessage())) {
            event.quitMessage(null);
            return;
        }
        String string = this.config.getCustomLeaveJoinDeath().getLeaveMessage().getMessage();
        String string2 = event.getPlayer().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = StringsKt.replace$default((String)string, (String)"{player}", (String)string2, (boolean)false, (int)4, null);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        event.quitMessage(MinimessageKt.stringToComponent((String)PapiUtilKt.papiParse(string3, player)));
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.config.getCustomLeaveJoinDeath().getDeathMessage().getEnabled()) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)this.config.getCustomLeaveJoinDeath().getDeathMessage().getMessage())) {
            event.deathMessage(null);
            return;
        }
        String string = this.config.getCustomLeaveJoinDeath().getDeathMessage().getMessage();
        String string2 = event.getPlayer().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = StringsKt.replace$default((String)string, (String)"{player}", (String)string2, (boolean)false, (int)4, null);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        event.deathMessage(MinimessageKt.stringToComponent((String)PapiUtilKt.papiParse(string3, player)));
    }
}

