/*
 * Decompiled with CFR 0.152.
 */
package one.pouekdev.coordinatelist;

import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_638;
import net.minecraft.class_746;
import one.pouekdev.coordinatelist.CList;
import one.pouekdev.coordinatelist.CListConfig;
import one.pouekdev.coordinatelist.CListData;
import one.pouekdev.coordinatelist.CListDelayedEvent;
import one.pouekdev.coordinatelist.CListVariables;
import one.pouekdev.coordinatelist.CListWaypoint;
import one.pouekdev.coordinatelist.CListWaypointColor;
import one.pouekdev.coordinatelist.CListWaypointConfig;
import one.pouekdev.coordinatelist.CListWaypointScreen;

public class CListClient
implements ClientModInitializer {
    public static CListVariables variables = new CListVariables();
    static Random rand = new Random();
    class_304 openWaypointsKeybind;
    class_304 addAWaypoint;
    class_304 toggleVisibility;
    public static class_304.class_11900 MOD_CATEGORY = new class_304.class_11900(class_2960.method_60654((String)"coordinatelist"));

    public void onInitializeClient() {
        this.openWaypointsKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoints.menu", class_3675.class_307.field_1668, 77, MOD_CATEGORY));
        this.addAWaypoint = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoint.add", class_3675.class_307.field_1668, 66, MOD_CATEGORY));
        this.toggleVisibility = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoints.toggle", class_3675.class_307.field_1668, 74, MOD_CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player;
            if (!CListVariables.delayedEvents.isEmpty()) {
                for (CListDelayedEvent event : CListVariables.delayedEvents) {
                    boolean destroy = event.update();
                    if (!destroy) continue;
                    CListVariables.delayedEvents.remove(event);
                    break;
                }
            }
            while (this.openWaypointsKeybind.method_1436()) {
                client.method_1507((class_437)new CListWaypointScreen((class_2561)class_2561.method_43470((String)"Waypoints")));
            }
            while (this.addAWaypoint.method_1436()) {
                if (Objects.equals(client.field_1755, (Object)new CListWaypointScreen((class_2561)class_2561.method_43470((String)"Waypoints")))) continue;
                player = CListVariables.minecraftClient.field_1724;
                CListClient.addNewWaypoint((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318()), (int)Math.floor(player.method_23321()), false, true);
            }
            while (this.toggleVisibility.method_1436()) {
                CListConfig.waypointsToggled = !CListConfig.waypointsToggled;
                MidnightConfig.write((String)"coordinatelist");
            }
            if (client.field_1687 == null) {
                CListClient.variables.loadedLastWorld = false;
                CListClient.variables.waypoints.clear();
                CListClient.variables.colors.clear();
                CListClient.variables.worldName = null;
                CListClient.variables.lastWorld = null;
                CListClient.variables.isWorldError = false;
            } else if (!CListClient.variables.isWorldError) {
                try {
                    CListClient.variables.lastWorld = client.field_1687;
                    CListClient.checkForWorldChanges(CListClient.variables.lastWorld);
                    CListClient.checkIfSaveIsNeeded(false);
                    if (client.method_1542()) {
                        CListClient.variables.worldName = client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
                    } else if (client.method_1558().method_52811()) {
                        CListClient.variables.worldName = client.method_1558().field_3752;
                    } else {
                        CListClient.variables.worldName = client.method_1558().field_3761;
                        CListClient.variables.worldName = CListClient.variables.worldName.replace(":", "P");
                    }
                    if (!client.field_1724.method_5805() && !CListClient.variables.hadDeathWaypointPlaced && CListConfig.canPlaceDeathpoints) {
                        player = client.field_1724;
                        CListClient.addNewWaypoint((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318()), (int)Math.floor(player.method_23321()), true, false);
                        CListClient.variables.hadDeathWaypointPlaced = true;
                    } else if (client.field_1724.method_5805() && CListClient.variables.hadDeathWaypointPlaced) {
                        CListClient.variables.hadDeathWaypointPlaced = false;
                    }
                }
                catch (NullPointerException e) {
                    CList.LOGGER.info("Can't get the current world. Player probably uses ReplayMod and is now watching the replay");
                    CListClient.variables.isWorldError = true;
                }
            }
        });
        CListClient.variables.savedSinceLastUpdate = true;
        CListClient.variables.loadedLastWorld = false;
    }

    public static void addNewWaypoint(int x, int y, int z, boolean death, boolean viaKeybind) {
        CList.LOGGER.info("New waypoint for dimension " + CListClient.variables.lastWorld.method_27983().method_29177().toString());
        String waypointName = death ? class_2561.method_43471((String)"waypoint.last.death").getString() : class_2561.method_43471((String)"waypoint.new.waypoint").getString();
        CListClient.variables.waypoints.add(new CListWaypoint(x, y, z, waypointName, CListClient.variables.lastWorld.method_27983().method_29177().toString(), true, death));
        CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
        CListClient.variables.savedSinceLastUpdate = false;
        if (!death) {
            CListVariables.minecraftClient.method_1507((class_437)new CListWaypointConfig((class_2561)class_2561.method_43470((String)"Config"), CListClient.variables.waypoints.size() - 1, viaKeybind));
        }
    }

    public static void deleteWaypoint(int position) {
        try {
            CListClient.variables.waypoints.remove(position);
            CListClient.variables.colors.remove(position);
            CListClient.variables.savedSinceLastUpdate = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void checkForWorldChanges(class_638 currentWorld) {
        if (!CListClient.variables.loadedLastWorld && CListClient.variables.worldName != null) {
            CList.LOGGER.info("New world " + CListClient.variables.worldName);
            CListClient.variables.lastWorld = currentWorld;
            List<String> names = CListData.loadListFromFileLegacy("clist_names_" + CListClient.variables.worldName);
            List<String> dimensions = CListData.loadListFromFileLegacy("clist_dimensions_" + CListClient.variables.worldName);
            if (names != null && !names.isEmpty()) {
                int i;
                List<String> temp = CListData.loadListFromFileLegacy("clist_" + CListClient.variables.worldName);
                for (i = 0; i < names.size(); ++i) {
                    CListClient.variables.waypoints.add(new CListWaypoint(temp.get(i), names.get(i), dimensions.get(i), true, false));
                }
                for (i = 0; i < CListClient.variables.waypoints.size(); ++i) {
                    CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
                }
                CListData.deleteLegacyFile("clist_names_" + CListClient.variables.worldName);
                CListData.deleteLegacyFile("clist_dimensions_" + CListClient.variables.worldName);
                CList.LOGGER.info("Loaded old 1.0 data for world " + CListClient.variables.worldName);
                CListClient.checkIfSaveIsNeeded(true);
            } else if (!CListVariables.minecraftClient.method_1542()) {
                List<CListWaypoint> ways = CListData.loadListFromFile("clist_" + CListVariables.minecraftClient.method_1558().field_3752);
                if (ways != null && !ways.isEmpty()) {
                    CListClient.variables.waypoints = ways;
                    CListData.deleteLegacyFile("clist_" + CListVariables.minecraftClient.method_1558().field_3752);
                    CList.LOGGER.info("Loaded old multiplier server data");
                    CListClient.checkIfSaveIsNeeded(true);
                } else {
                    ways = CListData.loadListFromFile("clist_" + CListClient.variables.worldName);
                    if (ways != null && !ways.isEmpty()) {
                        CListClient.variables.waypoints = ways;
                        CList.LOGGER.info("Loaded data for server " + CListClient.variables.worldName);
                    } else {
                        CList.LOGGER.info("The file for " + CListClient.variables.worldName + " doesn't exist");
                    }
                }
            } else {
                List<CListWaypoint> ways = CListData.loadListFromFile("clist_" + CListClient.variables.worldName);
                if (ways != null && !ways.isEmpty()) {
                    CListClient.variables.waypoints = ways;
                    CList.LOGGER.info("Loaded data for world " + CListClient.variables.worldName);
                } else {
                    CList.LOGGER.info("The file for " + CListClient.variables.worldName + " doesn't exist");
                }
            }
            CListClient.variables.loadedLastWorld = true;
        }
    }

    public static void addRandomWaypointColor() {
        CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
    }

    public static void checkIfSaveIsNeeded(boolean force) {
        if (!CListClient.variables.savedSinceLastUpdate || force) {
            CList.LOGGER.info("Saving data for world " + CListClient.variables.worldName);
            CListData.saveListToFile("clist_" + CListClient.variables.worldName, CListClient.variables.waypoints);
            CListClient.variables.savedSinceLastUpdate = true;
        }
    }
}

