/*
 * Decompiled with CFR 0.152.
 */
package one.pouekdev.coordinatelist;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import one.pouekdev.coordinatelist.CListClient;
import one.pouekdev.coordinatelist.CListWaypoint;
import one.pouekdev.coordinatelist.CListWaypointColor;

public class CListData {
    public static void saveListToFile(String fileName, List<CListWaypoint> waypointList) {
        if (!Files.exists(FabricLoader.getInstance().getConfigDir().resolve("coordinatelist"), new LinkOption[0])) {
            try {
                Files.createDirectories(FabricLoader.getInstance().getConfigDir().resolve("coordinatelist"), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File dataDir = FabricLoader.getInstance().getConfigDir().resolve("coordinatelist").toFile();
        File file = new File(dataDir, fileName);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)));){
            for (int i = 0; i < waypointList.size(); ++i) {
                writer.println(CListClient.variables.waypoints.get(i).getCoordinates() + "~" + CListClient.variables.waypoints.get((int)i).name.replaceAll("~", "") + "~" + CListClient.variables.waypoints.get((int)i).dimension + "~" + CListClient.variables.colors.get(i).getHexNoAlpha() + "~" + CListClient.variables.waypoints.get((int)i).render + "~" + CListClient.variables.waypoints.get((int)i).deathpoint);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<CListWaypoint> loadListFromFile(String fileName) {
        ArrayList arrayList;
        File dataDir = FabricLoader.getInstance().getConfigDir().resolve("coordinatelist").toFile();
        File file = new File(dataDir, fileName);
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            String line;
            ArrayList waypointList = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                String[] segments = line.split("~");
                if (segments.length < 3) continue;
                String coords = segments[0];
                String name = segments[1];
                String dimension = segments[2];
                String color = null;
                String bool = null;
                String deathpoint = null;
                try {
                    color = segments[3];
                    bool = segments[4];
                    deathpoint = segments[5];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                CListWaypoint waypoint = new CListWaypoint(coords, name, dimension, Boolean.parseBoolean(bool), Boolean.parseBoolean(deathpoint));
                if (color == null) {
                    CListClient.addRandomWaypointColor();
                } else {
                    CListWaypointColor color_class = new CListWaypointColor(0.0f, 0.0f, 0.0f);
                    color_class.set(color);
                    CListClient.variables.colors.add(color_class);
                }
                waypointList.add(waypoint);
            }
            arrayList = waypointList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        reader.close();
        return arrayList;
    }

    public static void deleteLegacyFile(String fileName) {
        File dataDir = FabricLoader.getInstance().getConfigDir().resolve("coordinatelist").toFile();
        File file = new File(dataDir, fileName);
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    public static List<String> loadListFromFileLegacy(String fileName) {
        ArrayList arrayList;
        File dataDir = FabricLoader.getInstance().getConfigDir().resolve("coordinatelist").toFile();
        File file = new File(dataDir, fileName);
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            String line;
            ArrayList stringList = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                stringList.add(line);
            }
            arrayList = stringList;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        reader.close();
        return arrayList;
    }
}

