/*
 * Decompiled with CFR 0.152.
 */
package one.pouekdev.coordinatelist;

public class CListWaypointColor {
    public float r;
    public float g;
    public float b;

    CListWaypointColor(float red, float green, float blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public void set(float[] hsv) {
        float bPrime;
        float gPrime;
        float rPrime;
        float h = hsv[0];
        float s = hsv[1];
        float v = hsv[2];
        float c = (v /= 100.0f) * (s /= 100.0f);
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            rPrime = c;
            gPrime = x;
            bPrime = 0.0f;
        } else if (h < 120.0f) {
            rPrime = x;
            gPrime = c;
            bPrime = 0.0f;
        } else if (h < 180.0f) {
            rPrime = 0.0f;
            gPrime = c;
            bPrime = x;
        } else if (h < 240.0f) {
            rPrime = 0.0f;
            gPrime = x;
            bPrime = c;
        } else if (h < 300.0f) {
            rPrime = x;
            gPrime = 0.0f;
            bPrime = c;
        } else {
            rPrime = c;
            gPrime = 0.0f;
            bPrime = x;
        }
        this.r = rPrime + m;
        this.g = gPrime + m;
        this.b = bPrime + m;
    }

    public float[] getHSV() {
        float min = Math.min(Math.min(this.r, this.g), this.b);
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float delta = max - min;
        float v = max * 100.0f;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = 0.0f;
            return new float[]{h, s, v};
        }
        float s = delta / max * 100.0f;
        float h = this.r == max ? (this.g - this.b) / delta : (this.g == max ? 2.0f + (this.b - this.r) / delta : 4.0f + (this.r - this.g) / delta);
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        if (Float.isNaN(h)) {
            h = 0.0f;
        }
        if (Float.isNaN(s)) {
            s = 0.0f;
        }
        if (Float.isNaN(v)) {
            v = 0.0f;
        }
        h = Float.parseFloat(String.format("%.1f", Float.valueOf(h)).replace(",", "."));
        s = Float.parseFloat(String.format("%.1f", Float.valueOf(s)).replace(",", "."));
        v = Float.parseFloat(String.format("%.1f", Float.valueOf(v)).replace(",", "."));
        return new float[]{h, s, v};
    }

    public int getHex() {
        int red = (int)(this.r * 255.0f);
        int green = (int)(this.g * 255.0f);
        int blue = (int)(this.b * 255.0f);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public String getHexNoAlpha() {
        int red = (int)(this.r * 255.0f);
        int green = (int)(this.g * 255.0f);
        int blue = (int)(this.b * 255.0f);
        return String.format("%02X%02X%02X", red, green, blue);
    }

    public void set(String hex) {
        if (hex.length() == 6 && hex.matches("[a-zA-Z0-9]+")) {
            hex = hex.replace("#", "");
            String redHex = hex.substring(0, 2);
            String greenHex = hex.substring(2, 4);
            String blueHex = hex.substring(4, 6);
            int red = -1;
            int green = -1;
            int blue = -1;
            try {
                red = Integer.parseInt(redHex, 16);
                green = Integer.parseInt(greenHex, 16);
                blue = Integer.parseInt(blueHex, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (red != -1 && green != -1 && blue != -1) {
                this.r = (float)red / 255.0f;
                this.g = (float)green / 255.0f;
                this.b = (float)blue / 255.0f;
            }
        }
    }
}

