/*
 * Decompiled with CFR 0.152.
 */
package one.pouekdev.coordinatelist.mixin;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import one.pouekdev.coordinatelist.CListClient;
import one.pouekdev.coordinatelist.CListConfig;
import one.pouekdev.coordinatelist.CListRenderLayers;
import one.pouekdev.coordinatelist.CListVariables;
import one.pouekdev.coordinatelist.CListWaypoint;
import one.pouekdev.coordinatelist.CListWaypointColor;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class CListWaypointRenderer {
    @Unique
    private float calculateWaypointSize() {
        return 0.5f * ((float)CListConfig.multiplier / 10.0f);
    }

    @Unique
    private float calculateTextSize() {
        return 15.0f * ((float)CListConfig.multiplier / 10.0f);
    }

    @Unique
    private float distanceTo(CListWaypoint waypoint) {
        float f = (float)(CListVariables.minecraftClient.field_1724.method_23317() - (double)waypoint.x);
        float g = (float)(CListVariables.minecraftClient.field_1724.method_23318() - (double)waypoint.y);
        float h = (float)(CListVariables.minecraftClient.field_1724.method_23321() - (double)waypoint.z);
        return Math.round(class_3532.method_15355((float)(f * f + g * g + h * h)));
    }

    @Unique
    private class_243 calculateRenderCoords(CListWaypoint waypoint, class_4184 camera, float distance) {
        float prz;
        float pry;
        float prx;
        float px = (float)camera.method_19326().field_1352;
        float py = (float)camera.method_19326().field_1351;
        float pz = (float)camera.method_19326().field_1350;
        float wx = waypoint.x;
        float wy = waypoint.y;
        float wz = waypoint.z;
        float vx = wx - px;
        float vy = wy - py;
        float vz = wz - pz;
        float vectorLen = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        float radius = 32.0f;
        float scx = radius / vectorLen * vx;
        float scy = radius / vectorLen * vy;
        float scz = radius / vectorLen * vz;
        if (distance > 32.0f) {
            prx = scx + px;
            pry = scy + py;
            prz = scz + pz;
        } else {
            prx = wx;
            pry = wy;
            prz = wz;
        }
        return new class_243((double)prx, (double)pry, (double)prz);
    }

    @Unique
    private static String getDimension(String text) {
        String s = text;
        s = s.replace("minecraft:", "");
        s = s.replace("_", " ");
        s = s.replace(":", " ");
        s = StringUtils.capitalize((String)s);
        return s;
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRender(CallbackInfo ci) {
        if (!CListClient.variables.waypoints.isEmpty() && CListConfig.waypointsToggled && !CListVariables.minecraftClient.field_1690.field_1842) {
            for (int i = 0; i < CListClient.variables.waypoints.size(); ++i) {
                CListWaypoint waypoint = CListClient.variables.waypoints.get(i);
                int distanceWithoutDecimalPlaces = (int)this.distanceTo(waypoint);
                if (!Objects.equals(waypoint.getDimensionString(), CListWaypointRenderer.getDimension(CListClient.variables.lastWorld.method_27983().method_29177().toString())) || !waypoint.render || CListConfig.renderDistance != 0 && CListConfig.renderDistance < distanceWithoutDecimalPlaces) continue;
                class_4184 camera = CListVariables.minecraftClient.field_1773.method_19418();
                float size = this.calculateWaypointSize();
                class_243 renderCoords = this.calculateRenderCoords(waypoint, camera, distanceWithoutDecimalPlaces);
                class_243 targetPosition = new class_243(renderCoords.field_1352 + 0.5, renderCoords.field_1351 + 1.0, renderCoords.field_1350 + 0.5);
                class_243 transformedPosition = targetPosition.method_1020(camera.method_19326());
                class_4587 matrixStack = new class_4587();
                matrixStack.method_22904(0.25, 0.0, 0.25);
                matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
                matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
                matrixStack.method_22904(transformedPosition.field_1352, transformedPosition.field_1351, transformedPosition.field_1350);
                matrixStack.method_22907((Quaternionfc)camera.method_23767());
                matrixStack.method_22905(-size, size, size);
                Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
                CListWaypointColor color = CListClient.variables.colors.get(i);
                buffer.method_22918(positionMatrix, 0.0f, 1.0f, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_22913(0.0f, 0.0f);
                buffer.method_22918(positionMatrix, 0.0f, 0.0f, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_22913(0.0f, 1.0f);
                buffer.method_22918(positionMatrix, 1.0f, 0.0f, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_22913(1.0f, 1.0f);
                buffer.method_22918(positionMatrix, 1.0f, 1.0f, 0.0f).method_22915(color.r, color.g, color.b, 1.0f).method_22913(1.0f, 0.0f);
                class_2960 icon = waypoint.deathpoint ? class_2960.method_60655((String)"coordinatelist", (String)"skull.png") : (CListConfig.squareWaypoints ? class_2960.method_60655((String)"coordinatelist", (String)"waypoint_icon_square.png") : class_2960.method_60655((String)"coordinatelist", (String)"waypoint_icon.png"));
                CListRenderLayers.POSITION_TEX_COLOR.apply(icon).method_60895(buffer.method_60800());
                class_327 textRenderer = CListVariables.minecraftClient.field_1772;
                String labelText = waypoint.name + " (" + distanceWithoutDecimalPlaces + " m)";
                int textWidth = textRenderer.method_1727(labelText);
                matrixStack.method_22905(-0.025f, -0.025f, 0.025f);
                size = this.calculateTextSize();
                matrixStack.method_22905((float)Math.log(size * 4.0f), (float)Math.log(size * 4.0f), (float)Math.log(size * 4.0f));
                matrixStack.method_46416(0.0f, -20.0f, 0.0f);
                positionMatrix = matrixStack.method_23760().method_23761();
                float h = -textWidth / 2;
                class_4597.class_4598 v = CListVariables.minecraftClient.method_22940().method_23000();
                if (CListConfig.waypointTextBackground) {
                    textRenderer.method_27521(labelText, h, 0.0f, -1, false, positionMatrix, (class_4597)v, class_327.class_6415.field_33994, -1879048192, 0xF000F0);
                } else {
                    textRenderer.method_27521(labelText, h, 0.0f, -1, false, positionMatrix, (class_4597)v, class_327.class_6415.field_33994, 0, 0xF000F0);
                }
                v.method_22993();
            }
        }
    }
}

