/*
 * Decompiled with CFR 0.152.
 */
package one.pouekdev.coordinatelist;

import com.mojang.blaze3d.vertex.VertexFormat;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5218;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import one.pouekdev.coordinatelist.CList;
import one.pouekdev.coordinatelist.CListConfig;
import one.pouekdev.coordinatelist.CListData;
import one.pouekdev.coordinatelist.CListDelayedEvent;
import one.pouekdev.coordinatelist.CListRenderLayers;
import one.pouekdev.coordinatelist.CListVariables;
import one.pouekdev.coordinatelist.CListWaypoint;
import one.pouekdev.coordinatelist.CListWaypointColor;
import one.pouekdev.coordinatelist.CListWaypointConfig;
import one.pouekdev.coordinatelist.CListWaypointScreen;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CListClient
implements ClientModInitializer {
    public static CListVariables variables = new CListVariables();
    static Random rand = new Random();
    class_304 open_waypoints_keybind;
    class_304 add_a_waypoint;
    class_304 toggle_visibility;

    public float calculateWaypointSize() {
        return 0.5f * ((float)CListConfig.multiplier / 10.0f);
    }

    public float calculateTextSize() {
        return 15.0f * ((float)CListConfig.multiplier / 10.0f);
    }

    public float distanceTo(CListWaypoint waypoint) {
        float f = (float)(CListVariables.minecraft_client.field_1724.method_23317() - (double)waypoint.x);
        float g = (float)(CListVariables.minecraft_client.field_1724.method_23318() - (double)waypoint.y);
        float h = (float)(CListVariables.minecraft_client.field_1724.method_23321() - (double)waypoint.z);
        return Math.round(class_3532.method_15355((float)(f * f + g * g + h * h)));
    }

    public class_243 calculateRenderCoords(CListWaypoint waypoint, class_4184 camera, float distance) {
        float prz;
        float pry;
        float prx;
        float px = (float)camera.method_19326().field_1352;
        float py = (float)camera.method_19326().field_1351;
        float pz = (float)camera.method_19326().field_1350;
        float wx = waypoint.x;
        float wy = waypoint.y;
        float wz = waypoint.z;
        float vx = wx - px;
        float vy = wy - py;
        float vz = wz - pz;
        float vector_len = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        float radius = 32.0f;
        float scx = radius / vector_len * vx;
        float scy = radius / vector_len * vy;
        float scz = radius / vector_len * vz;
        if (distance > 32.0f) {
            prx = scx + px;
            pry = scy + py;
            prz = scz + pz;
        } else {
            prx = wx;
            pry = wy;
            prz = wz;
        }
        return new class_243((double)prx, (double)pry, (double)prz);
    }

    public void onInitializeClient() {
        this.open_waypoints_keybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoints.menu", class_3675.class_307.field_1668, 77, "keybinds.category.name"));
        this.add_a_waypoint = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoint.add", class_3675.class_307.field_1668, 66, "keybinds.category.name"));
        this.toggle_visibility = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinds.waypoints.toggle", class_3675.class_307.field_1668, 74, "keybinds.category.name"));
        WorldRenderEvents.END.register(context -> {
            if (!CListClient.variables.waypoints.isEmpty() && CListConfig.waypoints_toggled && !CListVariables.minecraft_client.field_1690.field_1842) {
                for (int i = 0; i < CListClient.variables.waypoints.size(); ++i) {
                    CListWaypoint waypoint = CListClient.variables.waypoints.get(i);
                    int distance_without_decimal_places = (int)this.distanceTo(waypoint);
                    if (!Objects.equals(waypoint.getDimensionString(), CListClient.getDimension(CListClient.variables.last_world.method_27983().method_29177().toString())) || !waypoint.render || CListConfig.render_distance != 0 && CListConfig.render_distance < distance_without_decimal_places) continue;
                    class_4184 camera = context.camera();
                    float size = this.calculateWaypointSize();
                    class_243 renderCoords = this.calculateRenderCoords(waypoint, camera, distance_without_decimal_places);
                    class_243 targetPosition = new class_243(renderCoords.field_1352 + 0.5, renderCoords.field_1351 + 1.0, renderCoords.field_1350 + 0.5);
                    class_243 transformedPosition = targetPosition.method_1020(camera.method_19326());
                    class_4587 matrixStack = new class_4587();
                    matrixStack.method_22904(0.25, 0.0, 0.25);
                    matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
                    matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
                    matrixStack.method_22904(transformedPosition.field_1352, transformedPosition.field_1351, transformedPosition.field_1350);
                    matrixStack.method_22907((Quaternionfc)camera.method_23767());
                    matrixStack.method_22905(-size, size, size);
                    Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
                    class_289 tessellator = class_289.method_1348();
                    class_287 buffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
                    buffer.method_22918(positionMatrix, 0.0f, 1.0f, 0.0f).method_22915(CListClient.variables.colors.get((int)i).r, CListClient.variables.colors.get((int)i).g, CListClient.variables.colors.get((int)i).b, 1.0f).method_22913(0.0f, 0.0f);
                    buffer.method_22918(positionMatrix, 0.0f, 0.0f, 0.0f).method_22915(CListClient.variables.colors.get((int)i).r, CListClient.variables.colors.get((int)i).g, CListClient.variables.colors.get((int)i).b, 1.0f).method_22913(0.0f, 1.0f);
                    buffer.method_22918(positionMatrix, 1.0f, 0.0f, 0.0f).method_22915(CListClient.variables.colors.get((int)i).r, CListClient.variables.colors.get((int)i).g, CListClient.variables.colors.get((int)i).b, 1.0f).method_22913(1.0f, 1.0f);
                    buffer.method_22918(positionMatrix, 1.0f, 1.0f, 0.0f).method_22915(CListClient.variables.colors.get((int)i).r, CListClient.variables.colors.get((int)i).g, CListClient.variables.colors.get((int)i).b, 1.0f).method_22913(1.0f, 0.0f);
                    class_2960 icon = waypoint.deathpoint ? class_2960.method_60655((String)"coordinatelist", (String)"skull.png") : (CListConfig.square_waypoints ? class_2960.method_60655((String)"coordinatelist", (String)"waypoint_icon_square.png") : class_2960.method_60655((String)"coordinatelist", (String)"waypoint_icon.png"));
                    CListRenderLayers.POSITION_TEX_COLOR.apply(icon).method_60895(buffer.method_60800());
                    class_327 textRenderer = CListVariables.minecraft_client.field_1772;
                    String labelText = waypoint.name + " (" + distance_without_decimal_places + " m)";
                    int textWidth = textRenderer.method_1727(labelText);
                    matrixStack.method_22905(-0.025f, -0.025f, 0.025f);
                    size = this.calculateTextSize();
                    matrixStack.method_22905((float)Math.log(size * 4.0f), (float)Math.log(size * 4.0f), (float)Math.log(size * 4.0f));
                    matrixStack.method_46416(0.0f, -20.0f, 0.0f);
                    positionMatrix = matrixStack.method_23760().method_23761();
                    float h = -textWidth / 2;
                    class_4597.class_4598 v = CListVariables.minecraft_client.method_22940().method_23000();
                    if (CListConfig.waypoint_text_background) {
                        textRenderer.method_27521(labelText, h, 0.0f, 0xFFFFFF, false, positionMatrix, (class_4597)v, class_327.class_6415.field_33994, -1879048192, 0xF000F0);
                    } else {
                        textRenderer.method_27521(labelText, h, 0.0f, 0xFFFFFF, false, positionMatrix, (class_4597)v, class_327.class_6415.field_33994, 0, 0xF000F0);
                    }
                    v.method_22993();
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player;
            if (!CListVariables.delayed_events.isEmpty()) {
                for (CListDelayedEvent event : CListVariables.delayed_events) {
                    boolean destroy = event.update();
                    if (!destroy) continue;
                    CListVariables.delayed_events.remove(event);
                    break;
                }
            }
            while (this.open_waypoints_keybind.method_1436()) {
                client.method_1507((class_437)new CListWaypointScreen((class_2561)class_2561.method_43470((String)"Waypoints")));
            }
            while (this.add_a_waypoint.method_1436()) {
                if (Objects.equals(client.field_1755, (Object)new CListWaypointScreen((class_2561)class_2561.method_43470((String)"Waypoints")))) continue;
                player = CListVariables.minecraft_client.field_1724;
                CListClient.addNewWaypoint((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318()), (int)Math.floor(player.method_23321()), false, true);
            }
            while (this.toggle_visibility.method_1436()) {
                CListConfig.waypoints_toggled = !CListConfig.waypoints_toggled;
                MidnightConfig.write((String)"coordinatelist");
            }
            if (client.field_1687 == null) {
                CListClient.variables.loaded_last_world = false;
                CListClient.variables.waypoints.clear();
                CListClient.variables.colors.clear();
                CListClient.variables.worldName = null;
                CListClient.variables.last_world = null;
                CListClient.variables.is_world_error = false;
            } else if (!CListClient.variables.is_world_error) {
                try {
                    CListClient.variables.last_world = client.field_1687;
                    CListClient.checkForWorldChanges(CListClient.variables.last_world);
                    CListClient.checkIfSaveIsNeeded(false);
                    if (client.method_1542()) {
                        CListClient.variables.worldName = client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
                    } else if (client.method_1558().method_52811()) {
                        CListClient.variables.worldName = client.method_1558().field_3752;
                    } else {
                        CListClient.variables.worldName = client.method_1558().field_3761;
                        CListClient.variables.worldName = CListClient.variables.worldName.replace(":", "P");
                    }
                    if (!client.field_1724.method_5805() && !CListClient.variables.had_death_waypoint_placed && CListConfig.can_place_deathpoints) {
                        player = client.field_1724;
                        CListClient.addNewWaypoint((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318()), (int)Math.floor(player.method_23321()), true, false);
                        CListClient.variables.had_death_waypoint_placed = true;
                    } else if (client.field_1724.method_5805() && CListClient.variables.had_death_waypoint_placed) {
                        CListClient.variables.had_death_waypoint_placed = false;
                    }
                }
                catch (NullPointerException e) {
                    CList.LOGGER.info("Can't get the current world. Player probably uses ReplayMod and is now watching the replay");
                    CListClient.variables.is_world_error = true;
                }
            }
        });
        CListClient.variables.saved_since_last_update = true;
        CListClient.variables.loaded_last_world = false;
    }

    public static void addNewWaypoint(int x, int y, int z, boolean death, boolean viaKeybind) {
        CList.LOGGER.info("New waypoint for dimension " + CListClient.variables.last_world.method_27983().method_29177().toString());
        String waypoint_name = death ? class_2561.method_43471((String)"waypoint.last.death").getString() : class_2561.method_43471((String)"waypoint.new.waypoint").getString();
        CListClient.variables.waypoints.add(new CListWaypoint(x, y, z, waypoint_name, CListClient.variables.last_world.method_27983().method_29177().toString(), true, death));
        CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
        CListClient.variables.saved_since_last_update = false;
        if (!death) {
            CListVariables.minecraft_client.method_1507((class_437)new CListWaypointConfig((class_2561)class_2561.method_43470((String)"Config"), CListClient.variables.waypoints.size() - 1, viaKeybind));
        }
    }

    public static void deleteWaypoint(int position) {
        try {
            CListClient.variables.waypoints.remove(position);
            CListClient.variables.colors.remove(position);
            CListClient.variables.saved_since_last_update = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static String getDimension(String text) {
        String s = text;
        s = s.replace("minecraft:", "");
        s = s.replace("_", " ");
        s = s.replace(":", " ");
        s = StringUtils.capitalize((String)s);
        return s;
    }

    public static void checkForWorldChanges(class_638 current_world) {
        if (!CListClient.variables.loaded_last_world && CListClient.variables.worldName != null) {
            CList.LOGGER.info("New world " + CListClient.variables.worldName);
            CListClient.variables.last_world = current_world;
            List<String> names = CListData.loadListFromFileLegacy("clist_names_" + CListClient.variables.worldName);
            List<String> dimensions = CListData.loadListFromFileLegacy("clist_dimensions_" + CListClient.variables.worldName);
            if (names != null && !names.isEmpty()) {
                int i;
                List<String> temp = CListData.loadListFromFileLegacy("clist_" + CListClient.variables.worldName);
                for (i = 0; i < names.size(); ++i) {
                    CListClient.variables.waypoints.add(new CListWaypoint(temp.get(i), names.get(i), dimensions.get(i), true, false));
                }
                for (i = 0; i < CListClient.variables.waypoints.size(); ++i) {
                    CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
                }
                CListData.deleteLegacyFile("clist_names_" + CListClient.variables.worldName);
                CListData.deleteLegacyFile("clist_dimensions_" + CListClient.variables.worldName);
                CList.LOGGER.info("Loaded old 1.0 data for world " + CListClient.variables.worldName);
                CListClient.checkIfSaveIsNeeded(true);
            } else if (!CListVariables.minecraft_client.method_1542()) {
                List<CListWaypoint> ways = CListData.loadListFromFile("clist_" + CListVariables.minecraft_client.method_1558().field_3752);
                if (ways != null && !ways.isEmpty()) {
                    CListClient.variables.waypoints = ways;
                    CListData.deleteLegacyFile("clist_" + CListVariables.minecraft_client.method_1558().field_3752);
                    CList.LOGGER.info("Loaded old multiplier server data");
                    CListClient.checkIfSaveIsNeeded(true);
                } else {
                    ways = CListData.loadListFromFile("clist_" + CListClient.variables.worldName);
                    if (ways != null && !ways.isEmpty()) {
                        CListClient.variables.waypoints = ways;
                        CList.LOGGER.info("Loaded data for server " + CListClient.variables.worldName);
                    } else {
                        CList.LOGGER.info("The file for " + CListClient.variables.worldName + " doesn't exist");
                    }
                }
            } else {
                List<CListWaypoint> ways = CListData.loadListFromFile("clist_" + CListClient.variables.worldName);
                if (ways != null && !ways.isEmpty()) {
                    CListClient.variables.waypoints = ways;
                    CList.LOGGER.info("Loaded data for world " + CListClient.variables.worldName);
                } else {
                    CList.LOGGER.info("The file for " + CListClient.variables.worldName + " doesn't exist");
                }
            }
            CListClient.variables.loaded_last_world = true;
        }
    }

    public static void addRandomWaypointColor() {
        CListClient.variables.colors.add(new CListWaypointColor(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
    }

    public static void checkIfSaveIsNeeded(boolean force) {
        if (!CListClient.variables.saved_since_last_update || force) {
            CList.LOGGER.info("Saving data for world " + CListClient.variables.worldName);
            CListData.saveListToFile("clist_" + CListClient.variables.worldName, CListClient.variables.waypoints);
            CListClient.variables.saved_since_last_update = true;
        }
    }
}

