import math
from typing import List

def rotate_point(x, y, z, rot_y=0, rot_x=0, rot_z=0):
    # rotate around Y-axis
    cos_y, sin_y = math.cos(rot_y), math.sin(rot_y)
    x1 = x * cos_y - z * sin_y
    z1 = x * sin_y + z * cos_y
    y1 = y
    # rotate around X-axis
    cos_x, sin_x = math.cos(rot_x), math.sin(rot_x)
    y2 = y1 * cos_x - z1 * sin_x
    z2 = y1 * sin_x + z1 * cos_x
    x2 = x1
    # rotate around Z-axis
    cos_z, sin_z = math.cos(rot_z), math.sin(rot_z)
    x3 = x2 * cos_z - y2 * sin_z
    y3 = x2 * sin_z + y2 * cos_z
    z3 = z2
    return x3, y3, z3

def generate_rotated_sword_qi(
    major: float = 1.5,
    minor: float = 1.0,
    points: int = 70,
    y_offsets: List[float] = [0.1,0.0, 0.1],
    rot_y: float = 0.0,  # rotate around vertical (left-right)
    rot_x: float = 0.0,  # tilt up-down
    rot_z: float = 0.0,  # roll
    x_round: int = 2,
    y_round: int = 2,
    z_round: int = 2,
    speed_count_block: str = "1000000 0.0000003 0",
    force_selector: str = "@a",
    save_to_file: str = None,
    filename: str = "sword_qi_rotated.mcfunction",
):
    cmds = []
    for i in range(points):
        theta = (math.pi * i) / (points - 1)
        x = major * math.cos(theta)
        z = minor * math.sin(theta)
        for y in y_offsets:
            # rotate
            xr, yr, zr = rotate_point(x, y, z, rot_y=rot_y, rot_x=rot_x, rot_z=rot_z)
            line = f"particle flame ^{xr:.{x_round}f} ^{yr:.{y_round}f} ^{zr:.{z_round}f} ^ ^ ^{speed_count_block} force {force_selector}"
            cmds.append(line)
    if save_to_file:
        with open(filename, "w") as f:
            for c in cmds:
                f.write(c + "\n")
    return cmds

# Example: rotate sword 45° to the right, tilt 30° up
if __name__ == "__main__":
    cmds = generate_rotated_sword_qi(rot_y=math.radians(0),rot_z=math.radians(90), rot_x=math.radians(0), save_to_file=True, filename="sword_qi_rotated.mcfunction")
    for c in cmds:
        print(c)
