/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.event.InitializationHandler;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dimaskama.schematicpreview.SchematicPreviewCache;
import ru.dimaskama.schematicpreview.SchematicPreviewConfigs;
import ru.dimaskama.schematicpreview.SchematicPreviewInputHandler;
import ru.dimaskama.schematicpreview.gui.GuiSchematicPreviewConfig;
import ru.dimaskama.schematicpreview.render.PreviewsCache;

public class SchematicPreview
implements ModInitializer {
    public static final String MOD_ID = "schematicpreview";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SchematicPreview");
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("schematicpreview").orElseThrow();
    public static final PreviewsCache PREVIEWS_CACHE = new PreviewsCache();
    private static final Set<Runnable> tickables = new ObjectArraySet();

    public void onInitialize() {
        SchematicPreviewCache.loadOrCreate();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> SchematicPreviewCache.save());
        InitializationHandler.getInstance().registerInitializationHandler(() -> {
            ConfigManager.getInstance().registerConfigHandler(MOD_ID, (IConfigHandler)SchematicPreviewConfigs.INSTANCE);
            InputEventHandler.getKeybindManager().registerKeybindProvider((IKeybindProvider)SchematicPreviewInputHandler.getInstance());
            SchematicPreviewConfigs.CONFIG_MENU_HOTKEY.getKeybind().setCallback((action, key) -> {
                class_310.method_1551().method_1507((class_437)new GuiSchematicPreviewConfig(class_310.method_1551().field_1755));
                return true;
            });
        });
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            PREVIEWS_CACHE.tickClose();
            if (!tickables.isEmpty()) {
                for (Runnable tick : tickables) {
                    tick.run();
                }
            }
        });
    }

    public static void addTickable(Runnable tickAction) {
        tickables.add(tickAction);
    }

    public static void removeTickable(Runnable tickAction) {
        tickables.remove(tickAction);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

