/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui.widget;

import com.google.common.base.Suppliers;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.gui.interfaces.IFileBrowserIconProvider;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryEntry;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.render.RenderUtils;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.schematicpreview.ItemIconState;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.SchematicPreviewCache;
import ru.dimaskama.schematicpreview.gui.GuiEntryIconEdit;
import ru.dimaskama.schematicpreview.gui.widget.CustomSchematicBrowser;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewType;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewWidget;

public class CustomDirectoryEntry
extends WidgetDirectoryEntry {
    private final SchematicPreviewType previewType;
    private final class_8030 scissor;
    private final Function<File, SchematicPreviewWidget> widgets;
    private final String name;
    private final Supplier<@Nullable File> firstSchematicSubFile = Suppliers.memoize(() -> {
        File[] files = this.entry.getFullPath().listFiles(CustomSchematicBrowser.getSchematicFileFilter());
        return files != null && files.length != 0 ? files[0] : null;
    });
    @Nullable
    private class_1799 iconStack;
    private ItemIconState.Pos iconStatePos;
    @Nullable
    private String trimmedName;
    private class_8030 iconPos;

    public CustomDirectoryEntry(int x, int y, int width, int height, boolean isOdd, WidgetFileBrowserBase.DirectoryEntry entry, int listIndex, IDirectoryNavigator navigator, IFileBrowserIconProvider iconProvider, SchematicPreviewType previewType, class_8030 scissor, Function<File, SchematicPreviewWidget> widgets) {
        super(x, y, width, height, isOdd, entry, listIndex, navigator, iconProvider);
        this.previewType = previewType;
        this.scissor = scissor;
        this.widgets = widgets;
        this.name = this.getDisplayName();
        this.updateCustomIcon();
    }

    private String getCacheKey() {
        return this.entry.getFullPath().toPath().toString().replace('\\', '/');
    }

    private void updateCustomIcon() {
        this.iconStack = null;
        this.iconStatePos = ItemIconState.Pos.DEFAULT;
        String key = this.getCacheKey();
        ItemIconState state = SchematicPreviewCache.ICONS.get(key);
        if (state != null) {
            if (!state.itemId().isEmpty()) {
                try {
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)state.itemId()));
                    if (item != class_1802.field_8162) {
                        this.iconStack = item.method_7854();
                    }
                }
                catch (Exception e) {
                    SchematicPreviewCache.ICONS.remove(key);
                    SchematicPreviewCache.markDirty();
                    SchematicPreview.LOGGER.warn("Invalid icon for schematic browser entry: {}", (Object)state.itemId());
                }
            }
            this.iconStatePos = state.pos();
        }
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            if (this.canEditIcon(mouseX, mouseY)) {
                String key = this.getCacheKey();
                class_310 client = class_310.method_1551();
                client.method_1507((class_437)new GuiEntryIconEdit(client.field_1755, SchematicPreviewCache.ICONS.get(key), state -> {
                    String itemId = state.itemId();
                    if (!itemId.isEmpty()) {
                        Optional<class_1792> opt = class_2960.method_29186((String)state.itemId()).result().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).filter(i -> i != class_1802.field_8162);
                        if (opt.isEmpty()) {
                            return false;
                        }
                        itemId = class_7923.field_41178.method_10221((Object)opt.get()).toString();
                    }
                    SchematicPreviewCache.ICONS.put(key, new ItemIconState(itemId, state.pos()));
                    SchematicPreviewCache.markDirty();
                    this.updateCustomIcon();
                    return true;
                }));
            }
            return false;
        }
        return super.onMouseClickedImpl(mouseX, mouseY, mouseButton);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return super.isMouseOver(mouseX, mouseY) && this.scissor.method_58137(mouseX, mouseY);
    }

    /*
     * Unable to fully structure code
     */
    public void render(int mouseX, int mouseY, boolean selected, class_332 context) {
        block8: {
            block7: {
                context.method_44379(this.scissor.method_49620(), this.scissor.method_49618(), this.scissor.method_49621(), this.scissor.method_49619());
                RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)(selected != false || this.isMouseOver(mouseX, mouseY) != false ? 0x70FFFFFF : (this.isOdd != false ? 0x20FFFFFF : 0x38FFFFFF)));
                xOffset = 2;
                centerHeight = this.previewType.isList() != false ? this.height - 4 : this.height - 18;
                centerWidth = this.previewType.isList() != false ? Math.min(this.width * 2 / 3, (int)((float)centerHeight * 1.6f)) : this.width - 4;
                centerX = this.x + xOffset;
                centerY = this.y + (this.previewType.isList() != false ? 2 : 16);
                if (!this.renderIconAtCenter(context, centerX, centerY, centerWidth, centerHeight) && (schematicToRender = this.getSchematicToRender()) != null) {
                    context.method_44379(centerX, centerY, centerX + centerWidth, centerY + centerHeight);
                    widget = this.widgets.apply(schematicToRender);
                    widget.setScissor(true);
                    widget.renderPreviewAndOverlay(context, this.x + xOffset, centerY, centerWidth, centerHeight);
                    context.method_44380();
                }
                if (this.previewType.isList()) {
                    xOffset += centerWidth + 2;
                }
                if (this.renderIconAtCorner(context, this.x + xOffset)) {
                    xOffset += this.iconPos.comp_1196() + 2;
                }
                if (selected) {
                    RenderUtils.drawOutline((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-286331154);
                }
                yOffset = this.previewType.isTile() != false ? 3 : (this.height - this.fontHeight >> 1) + 1;
                textX = this.x + xOffset + 2;
                textY = this.y + yOffset;
                maxTextWidth = this.x + this.width - textX;
                exceedingWidth = this.textRenderer.method_1727(this.name) - maxTextWidth;
                if (exceedingWidth <= 0) break block7;
                if (mouseX < textX || mouseX >= textX + maxTextWidth || mouseY < textY) ** GOTO lbl-1000
                Objects.requireNonNull(this.textRenderer);
                if (mouseY < textY + 9) {
                    Objects.requireNonNull(this.textRenderer);
                    context.method_44379(textX, textY, textX + maxTextWidth, textY + 9);
                    this.drawString(textX - Math.round((float)(mouseX - textX) / (float)maxTextWidth * (float)exceedingWidth), textY, -1, this.name, context);
                    context.method_44380();
                } else lbl-1000:
                // 2 sources

                {
                    if (this.trimmedName == null) {
                        this.trimmedName = this.textRenderer.method_27523(this.name, maxTextWidth - this.textRenderer.method_1727("...")) + "...";
                    }
                    this.drawString(textX, textY, -1, this.trimmedName, context);
                }
                break block8;
            }
            this.drawString(textX, textY, -1, this.name, context);
        }
        this.drawSubWidgets(mouseX, mouseY, context);
        context.method_44380();
    }

    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_332 context) {
        if (this.canEditIcon(mouseX, mouseY)) {
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, List.of(class_1074.method_4662((String)"button.schematicpreview.change_directory_icon", (Object[])new Object[0])), (class_332)context);
        }
        super.postRenderHovered(mouseX, mouseY, selected, context);
    }

    @Nullable
    private File getSchematicToRender() {
        if (this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.FILE) {
            if (this.previewType.hasPreview()) {
                return this.entry.getFullPath();
            }
            return null;
        }
        if (this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY) {
            if (this.previewType.hasPreview() && this.iconStatePos == ItemIconState.Pos.DEFAULT_WITH_SCHEMATIC) {
                return this.firstSchematicSubFile.get();
            }
            return null;
        }
        return null;
    }

    private boolean canEditIcon(int mouseX, int mouseY) {
        return this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && this.iconPos != null && this.iconPos.method_58137(mouseX, mouseY);
    }

    private boolean renderIconAtCorner(class_332 context, int iconX) {
        if (this.shouldRenderIconAtCenter()) {
            return false;
        }
        class_1799 customIcon = this.iconStack;
        if (customIcon != null) {
            int iconY = this.y + (this.previewType.isTile() ? 2 : this.height - 12 >> 1);
            this.iconPos = new class_8030(iconX, iconY, 12, 12);
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416((float)iconX, (float)iconY, 0.0f);
            matrixStack.method_22905(0.75f, 0.75f, 1.0f);
            context.method_51427(customIcon, 0, 0);
            matrixStack.method_22909();
            return true;
        }
        IGuiIcon icon = this.getDefaultIcon();
        if (icon != null) {
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconY = this.y + (this.previewType.isTile() ? 2 : this.height - icon.getHeight() >> 1);
            this.iconPos = new class_8030(iconX, iconY, icon.getWidth(), icon.getHeight());
            this.bindTexture(icon.getTexture());
            icon.renderAt(iconX, iconY, (float)(this.zLevel + 10), false, false, context);
            return true;
        }
        return false;
    }

    private boolean renderIconAtCenter(class_332 context, int centerX, int centerY, int centerWidth, int centerHeight) {
        if (!this.shouldRenderIconAtCenter()) {
            return false;
        }
        int side = Math.min(centerWidth, centerHeight);
        side = this.previewType.isList() ? (side -= 2) : (int)((float)side * 0.8f);
        int x = centerX + (centerWidth - side >> 1);
        int y = centerY + (centerHeight - side >> 1);
        this.iconPos = new class_8030(x, y, side, side);
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        class_1799 customIcon = this.iconStack;
        if (customIcon != null) {
            float scale = (float)side / 16.0f;
            matrixStack.method_22905(scale, scale, 1.0f);
            context.method_51427(customIcon, 0, 0);
            matrixStack.method_22909();
            return true;
        }
        IGuiIcon icon = this.getDefaultIcon();
        if (icon != null) {
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture(icon.getTexture());
            float scale = (float)side / (float)icon.getWidth();
            matrixStack.method_22905(scale, scale, 1.0f);
            icon.renderAt(0, 0, (float)(this.zLevel + 10), false, false, context);
            matrixStack.method_22909();
            return true;
        }
        matrixStack.method_22909();
        return false;
    }

    private boolean shouldRenderIconAtCenter() {
        return this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && this.previewType.hasPreview() && this.iconStatePos == ItemIconState.Pos.CENTER;
    }

    private IGuiIcon getDefaultIcon() {
        return this.entry.getType() == WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY ? this.iconProvider.getIconDirectory() : this.iconProvider.getIconForFile(this.entry.getFullPath());
    }
}

