/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui.widget;

import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryEntry;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryNavigation;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import java.io.FileFilter;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.SchematicPreviewConfigs;
import ru.dimaskama.schematicpreview.gui.widget.CustomDirectoryEntry;
import ru.dimaskama.schematicpreview.gui.widget.SchematicBrowserPatch;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewType;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewWidget;
import ru.dimaskama.schematicpreview.gui.widget.SpriteButton;

public class CustomSchematicBrowser
extends WidgetSchematicBrowser
implements SchematicBrowserPatch {
    private static final class_2960 PREVIEW_SELECT_BUTTON_TEXTURE = SchematicPreview.id("preview_select_button");
    protected SchematicPreviewWidget sidePreviewWidget;
    protected SpriteButton previewSelectButton;
    protected int customEntryWidth;
    protected int customEntryHeight;
    protected class_8030 scissor;

    public CustomSchematicBrowser(int x, int y, int width, int height, GuiSchematicBrowserBase parent, ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> selectionListener) {
        super(x, y, width, height, parent, selectionListener);
    }

    public static FileFilter getSchematicFileFilter() {
        return SCHEMATIC_FILTER;
    }

    @Override
    public SchematicPreviewWidget schematicpreview_getSideWidget() {
        return this.sidePreviewWidget;
    }

    public void initGui() {
        super.initGui();
        if (this.sidePreviewWidget == null) {
            this.sidePreviewWidget = new SchematicPreviewWidget(SchematicPreview.PREVIEWS_CACHE, true);
        }
        this.addWidget(this.sidePreviewWidget);
        this.previewSelectButton = new SpriteButton(this.posX + 3, this.posY + 5, 12, 12, PREVIEW_SELECT_BUTTON_TEXTURE);
        this.previewSelectButton.setActionListener((button, mouse) -> {
            SchematicPreviewConfigs.PREVIEW_TYPE.setOptionListValue(SchematicPreviewConfigs.PREVIEW_TYPE.getOptionListValue().cycle(mouse == 0));
            this.reCreateListEntryWidgets();
        });
        this.addWidget((WidgetBase)this.previewSelectButton);
    }

    protected void updateDirectoryNavigationWidget() {
        int x = this.posX + 2;
        int y = this.posY + 4;
        this.directoryNavigationWidget = new WidgetDirectoryNavigation(x + 15, y, this.browserEntryWidth - 15, 14, this.currentDirectory, this.getRootDirectory(), (IDirectoryNavigator)this, this.iconProvider);
        this.browserEntriesOffsetY = this.directoryNavigationWidget.getHeight() + 3;
        this.widgetSearchBar = this.directoryNavigationWidget;
    }

    protected void drawAdditionalContents(int mouseX, int mouseY, class_332 context) {
        this.previewSelectButton.render(mouseX, mouseY, this.hoveredWidget == this.previewSelectButton, context);
        super.drawAdditionalContents(mouseX, mouseY, context);
    }

    protected void reCreateListEntryWidgets() {
        int y;
        int gapX = SchematicPreviewConfigs.ENTRY_GAP_X.getIntegerValue();
        int gapY = SchematicPreviewConfigs.ENTRY_GAP_Y.getIntegerValue();
        SchematicPreviewType previewType = this.getPreviewType();
        int columns = previewType.getColumns();
        this.customEntryWidth = (this.browserEntryWidth - gapX * (columns - 1)) / columns;
        this.customEntryHeight = previewType.getHeight(this.customEntryWidth);
        this.listWidgets.clear();
        this.maxVisibleBrowserEntries = 0;
        int numEntries = this.listContents.size();
        int usableHeight = this.browserHeight - this.browserPaddingY - this.browserEntriesOffsetY;
        int leftX = this.posX + 2;
        int topY = this.posY + 4 + this.browserEntriesOffsetY;
        this.scissor = new class_8030(leftX, topY, this.browserEntryWidth, usableHeight);
        int viewIndex = 0;
        for (int i = this.scrollBar.getValue() / columns * columns; i < numEntries && (y = viewIndex / columns * (this.customEntryHeight + gapY)) <= usableHeight; ++i) {
            int x = viewIndex % columns * (this.customEntryWidth + gapX);
            this.listWidgets.add(this.createListEntryWidget(leftX + x, topY + y, i, (i % columns & 1) + (i / columns & 1) == 1, (WidgetFileBrowserBase.DirectoryEntry)this.listContents.get(i)));
            ++this.maxVisibleBrowserEntries;
            ++viewIndex;
        }
        this.scrollBar.setMaxValue(this.listContents.size() - columns * (class_3532.method_48116((int)usableHeight, (int)this.customEntryHeight) - 1));
    }

    protected WidgetDirectoryEntry createListEntryWidget(int x, int y, int i, boolean isOdd, WidgetFileBrowserBase.DirectoryEntry entry) {
        SchematicPreviewType previewType = this.getPreviewType();
        return new CustomDirectoryEntry(x, y, this.customEntryWidth, this.customEntryHeight, isOdd, entry, i, (IDirectoryNavigator)this, this.iconProvider, previewType, this.scissor, SchematicPreview.PREVIEWS_CACHE::getSmallWidget);
    }

    protected SchematicPreviewType getPreviewType() {
        return (SchematicPreviewType)SchematicPreviewConfigs.PREVIEW_TYPE.getOptionListValue();
    }
}

