/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_10366;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.SchematicPreviewConfigs;
import ru.dimaskama.schematicpreview.gui.GuiSchematicPreviewFullscreen;
import ru.dimaskama.schematicpreview.gui.widget.OnOffButton;
import ru.dimaskama.schematicpreview.render.PreviewsCache;
import ru.dimaskama.schematicpreview.render.SchematicPreviewRenderer;

public class SchematicPreviewWidget
extends WidgetBase {
    private final Renderer renderer;
    private final Runnable tickAction;
    private final List<class_339> buttons;
    private final Vector3f rotOrigin;
    private final PreviewsCache cache;
    private final boolean nonStatic;
    private File schematicFile;
    private LitematicaSchematic lastSchematic;
    private class_276 framebuffer;
    private boolean mouseDragging;
    private int lastMouseX;
    private int lastMouseY;
    private boolean fullscreen;
    private boolean freecam;
    private float distance;
    private float yRot;
    private float xRot;
    private boolean scissor;

    public SchematicPreviewWidget(PreviewsCache cache, boolean nonStatic) {
        super(0, 0, 0, 0);
        this.renderer = new Renderer(this.mc);
        this.tickAction = this::tick;
        this.rotOrigin = new Vector3f();
        this.cache = cache;
        this.nonStatic = nonStatic;
        this.buttons = nonStatic ? List.of(new OnOffButton(6, 6, (class_2561)class_2561.method_43471((String)"button.schematicpreview.fullscreen"), this::toggleFullscreen, SchematicPreview.id("fullscreen_on"), SchematicPreview.id("fullscreen_on_focused"), SchematicPreview.id("fullscreen_off"), SchematicPreview.id("fullscreen_off_focused")), new OnOffButton(6, 6, (class_2561)class_2561.method_43471((String)"button.schematicpreview.freecam"), this::toggleFreecam, SchematicPreview.id("freecam_on"), SchematicPreview.id("freecam_on_focused"), SchematicPreview.id("freecam_off"), SchematicPreview.id("freecam_off_focused"))) : List.of();
    }

    public void setSchematic(File schematicFile) {
        this.schematicFile = schematicFile;
    }

    public void renderPreviewAndOverlay(class_332 context, int x, int y, int width, int height) {
        SchematicPreview.addTickable(this.tickAction);
        if (x != this.x || y != this.y || width != this.width || height != this.height) {
            this.setPosition(x, y);
            this.setWidth(width);
            this.setHeight(height);
            this.resized();
        }
        int centerX = x + (width >> 1);
        int centerY = y + (height - 10 >> 1);
        CompletableFuture<LitematicaSchematic> loadingSchematic = this.cache.getSchematic(this.schematicFile);
        if (loadingSchematic.isDone()) {
            LitematicaSchematic schematic;
            if (!loadingSchematic.isCompletedExceptionally() && (schematic = loadingSchematic.join()) != null) {
                class_2382 size;
                int maxVolume = SchematicPreviewConfigs.PREVIEW_MAX_VOLUME.getIntegerValue();
                if (this.nonStatic || maxVolume == 0 || (size = schematic.getTotalSize()).method_10263() * size.method_10264() * size.method_10260() <= maxVolume) {
                    if (this.lastSchematic == null || this.lastSchematic != schematic && !Objects.equals(this.lastSchematic.getFile(), schematic.getFile())) {
                        this.lastSchematic = schematic;
                        this.renderer.newSchematic(schematic);
                        this.resetCameraPos();
                    }
                    if (!this.renderer.isBuildingTerrainOrStart()) {
                        this.renderPreviewAndOverlay(context, this.mc.method_61966().method_60637(true));
                    } else {
                        context.method_25300(this.textRenderer, "Building terrain...", centerX, centerY, -4473925);
                    }
                } else {
                    context.method_25300(this.textRenderer, "Too big", centerX, centerY, -4473925);
                }
            } else {
                context.method_25300(this.textRenderer, "Preview load failed", centerX, centerY, -43691);
            }
        } else {
            context.method_25300(this.textRenderer, "Loading preview...", centerX, centerY, -4473925);
        }
    }

    private void resized() {
        int x = this.x + 1;
        int y = this.y + 1;
        for (class_339 button : this.buttons) {
            button.method_48229(x, y);
            x += button.method_25368() + 2;
        }
    }

    private void renderPreviewAndOverlay(class_332 context, float tickDelta) {
        if (this.fullscreen) {
            context.method_25294(0, 0, context.method_51421(), context.method_51443(), -16777216);
        }
        context.method_51452();
        boolean framebufferUpdated = this.prepareFramebuffer();
        if (this.nonStatic || framebufferUpdated || this.renderer.needsReRender()) {
            if (this.scissor) {
                GlStateManager._disableScissorTest();
            }
            this.framebuffer.method_1230();
            this.renderer.render(this.framebuffer, tickDelta);
            this.mc.method_1522().method_1235(true);
            if (this.scissor) {
                GlStateManager._enableScissorTest();
            }
        }
        RenderSystem.backupProjectionMatrix();
        Matrix4f projMat = new Matrix4f().setOrtho(0.0f, (float)this.mc.method_22683().method_4489(), (float)this.mc.method_22683().method_4506(), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projMat, (class_10366)class_10366.field_54954);
        RenderSystem.setShaderTexture((int)0, (int)this.framebuffer.method_30277());
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float scaleFactor = (float)this.mc.method_22683().method_4495();
        float x1 = (float)this.x * scaleFactor;
        float y1 = (float)this.y * scaleFactor;
        float x2 = (float)(this.x + this.width) * scaleFactor;
        float y2 = (float)(this.y + this.height) * scaleFactor;
        bufferBuilder.method_22918(matrix4f, x1, y1, 0.0f).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, x1, y2, 0.0f).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, x2, y2, 0.0f).method_22913(1.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, x2, y1, 0.0f).method_22913(1.0f, 1.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.restoreProjectionMatrix();
        this.renderOverlay(context, tickDelta);
    }

    private boolean prepareFramebuffer() {
        double scale = this.mc.method_22683().method_4495();
        int scaledWidth = (int)(scale * (double)this.width);
        int scaledHeight = (int)(scale * (double)this.height);
        if (this.framebuffer == null) {
            this.framebuffer = new class_6367(scaledWidth, scaledHeight, true);
            this.framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            return true;
        }
        if (this.framebuffer.field_1480 != scaledWidth || this.framebuffer.field_1477 != scaledHeight) {
            this.framebuffer.method_1234(scaledWidth, scaledHeight);
            return true;
        }
        return false;
    }

    private void renderOverlay(class_332 context, float tickDelta) {
        int mouseX = this.getMouseX();
        int mouseY = this.getMouseY();
        for (class_339 button : this.buttons) {
            button.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    private void toggleFullscreen(boolean fullscreen) {
        if (fullscreen) {
            this.mc.method_1507((class_437)new GuiSchematicPreviewFullscreen(this.mc.field_1755, this));
        } else if (this.mc.field_1755 != null) {
            this.mc.field_1755.method_25419();
        }
    }

    public void setFullScreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    private void toggleFreecam(boolean freecam) {
        this.freecam = freecam;
        if (!freecam) {
            this.resetCameraPos();
        }
    }

    private void resetCameraPos() {
        class_2382 size = this.lastSchematic.getMetadata().getEnclosingSize();
        this.rotOrigin.set((float)size.method_10263() * 0.5f, (float)size.method_10264() * 0.3f, (float)size.method_10260() * 0.5f);
        this.yRot = (float)SchematicPreviewConfigs.PREVIEW_ROTATION_Y.getDoubleValue();
        this.xRot = (float)SchematicPreviewConfigs.PREVIEW_ROTATION_X.getDoubleValue();
        this.distance = class_3532.method_15355((float)class_3532.method_60677((float)((float)size.method_10263() * 0.5f), (float)((float)size.method_10264() * 0.7f), (float)((float)size.method_10260() * 0.5f))) * 2.0f;
        this.updateRendererCameraPos();
        this.renderer.resetPosition();
    }

    private void updateRendererCameraPos() {
        this.renderer.setRotation(-this.xRot, this.yRot);
        Vector3f offset = SchematicPreviewWidget.getRotationVec(this.xRot, 180.0f + this.yRot).mul(-this.distance);
        this.renderer.setPos(this.rotOrigin.x + offset.x, this.rotOrigin.y + offset.y, this.rotOrigin.z + offset.z);
    }

    public void setScissor(boolean scissor) {
        this.scissor = scissor;
    }

    public void tick() {
        if (this.nonStatic) {
            this.renderer.tick();
            if (this.mouseDragging) {
                int x = this.getMouseX();
                int y = this.getMouseY();
                int deltaX = x - this.lastMouseX;
                int deltaY = y - this.lastMouseY;
                if (deltaX != 0 || deltaY != 0) {
                    this.mouseDragged(deltaX, deltaY);
                    this.lastMouseX = x;
                    this.lastMouseY = y;
                }
            }
        }
    }

    private int getMouseX() {
        return (int)(this.mc.field_1729.method_1603() * (double)this.mc.method_22683().method_4486() / (double)this.mc.method_22683().method_4480());
    }

    private int getMouseY() {
        return (int)(this.mc.field_1729.method_1604() * (double)this.mc.method_22683().method_4502() / (double)this.mc.method_22683().method_4507());
    }

    private void mouseDragged(int deltaX, int deltaY) {
        float dX = (float)deltaX / (float)this.width * 180.0f;
        float dY = (float)deltaY / (float)this.height * 180.0f;
        if (this.freecam) {
            this.renderer.setRotation(this.renderer.getPitch() - dY, this.renderer.getYaw() - dX);
        } else {
            this.yRot = class_3532.method_15393((float)(this.yRot - dX));
            this.xRot = class_3532.method_15363((float)(this.xRot + dY), (float)-90.0f, (float)90.0f);
            this.updateRendererCameraPos();
        }
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.nonStatic) {
            for (class_339 button : this.buttons) {
                if (!button.method_25402((double)mouseX, (double)mouseY, mouseButton)) continue;
                return true;
            }
            if (mouseButton == 0) {
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                this.mouseDragging = true;
                return true;
            }
        }
        return false;
    }

    public void onMouseReleasedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.nonStatic && mouseButton == 0) {
            this.mouseDragging = false;
        }
    }

    public boolean onMouseScrolledImpl(int mouseX, int mouseY, double horizontalAmount, double verticalAmount) {
        if (this.nonStatic) {
            if (verticalAmount != 0.0) {
                float am = -((float)verticalAmount);
                if (this.freecam) {
                    Vector3f move = SchematicPreviewWidget.getRotationVec(this.renderer.getPitch(), this.renderer.getYaw()).mul(am *= 2.0f * (class_437.method_25442() ? 2.0f : 1.0f) * (class_437.method_25441() ? 2.0f : 1.0f));
                    this.renderer.setPos(this.renderer.getX() + move.x, this.renderer.getY() + move.y, this.renderer.getZ() + move.z);
                } else {
                    this.distance = class_3532.method_27285((float)Math.max(0.0f, class_3532.method_15355((float)this.distance) + am * 0.5f));
                    this.updateRendererCameraPos();
                }
            }
            return true;
        }
        return false;
    }

    public void removed() {
        if (this.framebuffer != null) {
            this.framebuffer.method_1238();
            this.framebuffer = null;
        }
        this.renderer.close();
        SchematicPreview.removeTickable(this.tickAction);
    }

    private static Vector3f getRotationVec(float pitch, float yaw) {
        float h = class_3532.method_15362((float)(yaw *= (float)Math.PI / 180));
        float i = class_3532.method_15374((float)yaw);
        float j = class_3532.method_15362((float)(pitch *= (float)Math.PI / 180));
        float k = class_3532.method_15374((float)pitch);
        return new Vector3f(i * j, -k, h * j);
    }

    private static class Renderer {
        private final class_310 mc;
        private final Quaternionf rotation = new Quaternionf();
        private final Vector3f lastRenderPos = new Vector3f();
        private final Vector3f prevPos = new Vector3f();
        private final Vector3f pos = new Vector3f(0.0f, 2.0f, 100.0f);
        private final Vector2f lastRenderRot = new Vector2f();
        private final Vector2f prevRot = new Vector2f();
        private final Vector2f rot = new Vector2f();
        private SchematicPreviewRenderer renderer;
        private int lastChunksBuilt;
        private boolean schematicNew;

        private Renderer(class_310 mc) {
            this.mc = mc;
        }

        private void tick() {
            this.resetPosition();
        }

        private void resetPosition() {
            this.prevPos.set((Vector3fc)this.pos);
            this.prevRot.set((Vector2fc)this.rot);
        }

        private float getX() {
            return this.pos.x;
        }

        private float getY() {
            return this.pos.y;
        }

        private float getZ() {
            return this.pos.z;
        }

        private void setPos(float x, float y, float z) {
            this.pos.set(x, y, z);
        }

        private float getPitch() {
            return this.rot.x;
        }

        private float getYaw() {
            return this.rot.y;
        }

        private void setRotation(float pitch, float yaw) {
            this.rot.set(class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f), class_3532.method_15393((float)yaw));
        }

        private void newSchematic(LitematicaSchematic schematic) {
            if (this.renderer == null) {
                this.renderer = new SchematicPreviewRenderer(this.mc);
            }
            this.renderer.setup(schematic);
            this.schematicNew = true;
        }

        private boolean isBuildDone() {
            return this.renderer.isBuildDone();
        }

        private boolean isBuildingTerrainOrStart() {
            return this.renderer.isBuildingTerrain();
        }

        private boolean needsReRender() {
            return this.schematicNew || !this.pos.equals((Object)this.lastRenderPos) || !this.rot.equals((Object)this.lastRenderRot) || this.renderer.getBuiltChunksCount() != this.lastChunksBuilt;
        }

        private void render(class_276 framebuffer, float tickDelta) {
            this.schematicNew = false;
            if (this.isBuildingTerrainOrStart()) {
                return;
            }
            this.lastChunksBuilt = this.renderer.getBuiltChunksCount();
            RenderSystem.backupProjectionMatrix();
            Matrix4f projectionMatrix = new Matrix4f().perspective((float)SchematicPreviewConfigs.PREVIEW_FOV.getDoubleValue() * ((float)Math.PI / 180), (float)framebuffer.field_1480 / (float)framebuffer.field_1477, 0.05f, 1024.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_10366)class_10366.field_54953);
            this.lastRenderRot.set(class_3532.method_16439((float)tickDelta, (float)this.prevRot.x, (float)this.rot.x), class_3532.method_17821((float)tickDelta, (float)this.prevRot.y, (float)this.rot.y));
            Matrix4f rotationMatrix = new Matrix4f().rotation((Quaternionfc)this.rotation.rotationYXZ(this.lastRenderRot.y * ((float)Math.PI / 180), this.lastRenderRot.x * ((float)Math.PI / 180), 0.0f).conjugate());
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.set((Matrix4fc)rotationMatrix);
            this.lastRenderPos.set(class_3532.method_16439((float)tickDelta, (float)this.prevPos.x, (float)this.pos.x), class_3532.method_16439((float)tickDelta, (float)this.prevPos.y, (float)this.pos.y), class_3532.method_16439((float)tickDelta, (float)this.prevPos.z, (float)this.pos.z));
            this.renderer.prepareRender(this.lastRenderPos.x, this.lastRenderPos.y, this.lastRenderPos.z, framebuffer);
            this.renderer.renderLayer(class_1921.method_23577());
            this.renderer.renderLayer(class_1921.method_23579());
            this.renderer.renderLayer(class_1921.method_23581());
            this.renderer.renderLayer(class_1921.method_23583());
            if (SchematicPreviewConfigs.RENDER_TILE.getBooleanValue()) {
                this.renderer.renderBlockEntities(new class_4587(), this.mc.method_22940().method_23000(), tickDelta);
            }
            RenderSystem.restoreProjectionMatrix();
            modelViewStack.popMatrix();
        }

        private void close() {
            if (this.renderer != null) {
                this.renderer.close();
                this.renderer = null;
            }
        }
    }
}

