/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.util.FileType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_310;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewWidget;

public class PreviewsCache
implements AutoCloseable {
    private final Map<File, CompletableFuture<LitematicaSchematic>> schematics = new HashMap<File, CompletableFuture<LitematicaSchematic>>();
    private final Map<File, SchematicPreviewWidget> smallWidgets = new HashMap<File, SchematicPreviewWidget>();
    private boolean closed = false;

    public CompletableFuture<LitematicaSchematic> getSchematic(File file) {
        this.closed = false;
        return this.schematics.computeIfAbsent(file, f -> CompletableFuture.supplyAsync(() -> LitematicaSchematic.createFromFile((File)f.getParentFile(), (String)f.getName(), (FileType)FileType.fromFile((File)f)), (Executor)class_156.method_55473()));
    }

    public SchematicPreviewWidget getSmallWidget(File file) {
        this.closed = false;
        return this.smallWidgets.computeIfAbsent(file, f -> {
            SchematicPreviewWidget w = new SchematicPreviewWidget(this, false);
            w.setSchematic((File)f);
            return w;
        });
    }

    public void tickClose() {
        if (!this.closed && class_310.method_1551().field_1755 == null) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.schematics.values().forEach(f -> f.cancel(true));
        this.schematics.clear();
        this.smallWidgets.values().forEach(SchematicPreviewWidget::removed);
        this.smallWidgets.clear();
        this.closed = true;
    }
}

