/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.render.schematic.IBufferBuilderPatch;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_6575;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_8555;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.render.CustomVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.WorldSchematicWrapper;

public class SchematicPreviewRenderer
implements AutoCloseable {
    private final WorldSchematicWrapper world;
    private final class_776 blockRenderManager;
    private final class_824 blockEntityRenderDispatcher;
    private final List<ChunkEntry> chunks = new ArrayList<ChunkEntry>();
    private final Vector3f pos = new Vector3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
    private final Vector3f lastPos = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    private class_1923 lastChunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private boolean updated;
    private boolean canceled;
    private class_276 target;

    public SchematicPreviewRenderer(class_310 mc) {
        this.world = new WorldSchematicWrapper(mc);
        this.blockRenderManager = mc.method_1541();
        this.blockEntityRenderDispatcher = mc.method_31975();
    }

    public void setup(LitematicaSchematic schematic) {
        this.close();
        this.world.setSchematic(schematic);
        int height = this.world.getSize().method_10264();
        int chunksX = this.world.getSize().method_10263() >>> 4;
        int chunksZ = this.world.getSize().method_10260() >>> 4;
        for (int chunkX = 0; chunkX <= chunksX; ++chunkX) {
            for (int chunkZ = 0; chunkZ <= chunksZ; ++chunkZ) {
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                this.chunks.add(new ChunkEntry(chunkPos, CompletableFuture.supplyAsync(() -> {
                    class_6575 random = new class_6575(0L);
                    BuiltChunk chunk = new BuiltChunk();
                    class_4587 matrices = new class_4587();
                    class_2338.class_2339 worldPos = new class_2338.class_2339();
                    int chunkStartX = chunkPos.method_8326();
                    int chunkStartZ = chunkPos.method_8328();
                    int chunkEndX = chunkStartX + 16;
                    int chunkEndZ = chunkStartZ + 16;
                    for (int y = 0; y < height; ++y) {
                        for (int z = chunkStartZ; z < chunkEndZ; ++z) {
                            for (int x = chunkStartX; x < chunkEndX; ++x) {
                                class_287 builder;
                                class_1921 layer;
                                boolean renderBlock;
                                if (this.canceled) {
                                    chunk.close();
                                    return null;
                                }
                                worldPos.method_10103(x, y, z);
                                class_2680 state = this.world.method_8320((class_2338)worldPos);
                                class_3610 fluid = state.method_26227();
                                boolean renderFluid = !fluid.method_15769();
                                boolean bl = renderBlock = state.method_26217() == class_2464.field_11458;
                                if (!renderFluid && !renderBlock) continue;
                                matrices.method_22903();
                                matrices.method_46416((float)(worldPos.method_10263() & 0xF), (float)worldPos.method_10264(), (float)(worldPos.method_10260() & 0xF));
                                if (renderFluid) {
                                    layer = class_4696.method_23680((class_3610)fluid);
                                    builder = chunk.getBuilderByLayer(layer);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY((float)(worldPos.method_10264() >> 4 << 4));
                                    this.blockRenderManager.method_3352((class_2338)worldPos, (class_1920)this.world, (class_4588)builder, state, fluid);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY(0.0f);
                                }
                                if (renderBlock) {
                                    layer = class_4696.method_23679((class_2680)state);
                                    builder = chunk.getBuilderByLayer(layer);
                                    this.blockRenderManager.method_3350().method_3361((class_1920)this.world, this.blockRenderManager.method_3349(state), state, (class_2338)worldPos, matrices, (class_4588)builder, true, (class_5819)random, state.method_26190((class_2338)worldPos), class_4608.field_21444);
                                }
                                matrices.method_22909();
                            }
                        }
                    }
                    return chunk;
                })));
            }
        }
    }

    public void prepareRender(float x, float y, float z, class_276 target) {
        this.target = target;
        this.pos.set(x, y, z);
        boolean bl = this.updated = !this.lastPos.equals((Object)this.pos);
        if (this.updated) {
            this.lastPos.set(x, y, z);
            class_1923 chunkPos = new class_1923(class_3532.method_15375((float)x) >> 4, class_3532.method_15375((float)z) >> 4);
            if (!this.lastChunkPos.equals((Object)chunkPos)) {
                this.lastChunkPos = chunkPos;
                this.chunks.sort(Comparator.comparingInt(chunk -> -(Math.abs(chunk.pos.field_9181 - chunkPos.field_9181) + Math.abs(chunk.pos.field_9180 - chunkPos.field_9180))));
            }
        }
    }

    public void renderLayer(class_1921 layer) {
        layer.method_23516();
        this.chunks.forEach(chunkEntry -> {
            if (!chunkEntry.future.isDone()) {
                return;
            }
            BuiltChunk chunk = chunkEntry.future.join();
            if (chunk == null) {
                return;
            }
            boolean uploaded = chunk.uploadBufferIfNot(layer);
            class_291 buffer = chunk.buffers.get(layer);
            if (buffer == null) {
                return;
            }
            if (this.updated || uploaded) {
                chunk.resortTransparent(layer, class_8251.method_49906((float)(this.pos.x - (float)chunkEntry.pos.method_8326()), (float)this.pos.y, (float)(this.pos.z - (float)chunkEntry.pos.method_8328())));
            }
            class_5944 shader = RenderSystem.getShader();
            shader.method_34586();
            if (shader.field_53139 != null) {
                shader.field_53139.method_1249((float)chunkEntry.pos.method_8326() - this.pos.x, -this.pos.y, (float)chunkEntry.pos.method_8328() - this.pos.z);
                shader.field_53139.method_1300();
            }
            buffer.method_1353();
            this.target.method_1235(true);
            buffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), shader);
            shader.method_34586();
            if (shader.field_53139 != null) {
                shader.field_53139.method_1249(0.0f, 0.0f, 0.0f);
                shader.field_53139.method_1300();
            }
        });
        layer.method_23518();
    }

    public void renderBlockEntities(class_4587 stack, class_4597.class_4598 vertexConsumers, float tickDelta) {
        if (this.getBuiltChunksCount() != this.chunks.size()) {
            return;
        }
        CustomVertexConsumerProvider customVertexConsumers = new CustomVertexConsumerProvider(vertexConsumers, this.target);
        this.world.getBlockEntities().forEach((pos, blockEntitySupplier) -> {
            class_827 renderer;
            class_2586 blockEntity = (class_2586)blockEntitySupplier.get();
            if (blockEntity != null && (renderer = this.blockEntityRenderDispatcher.method_3550(blockEntity)) != null) {
                stack.method_22903();
                stack.method_46416((float)pos.method_10263() - this.lastPos.x, (float)pos.method_10264() - this.lastPos.y, (float)pos.method_10260() - this.lastPos.z);
                try {
                    renderer.method_3569(blockEntity, tickDelta, stack, (class_4597)customVertexConsumers, 0xF000F0, class_4608.field_21444);
                }
                catch (Exception e) {
                    SchematicPreview.LOGGER.debug("Exception while rendering preview block entity", (Throwable)e);
                }
                stack.method_22909();
            }
        });
        customVertexConsumers.method_22993();
    }

    public int getBuiltChunksCount() {
        return (int)this.chunks.stream().map(ChunkEntry::future).filter(CompletableFuture::isDone).count();
    }

    public boolean isBuildingTerrain() {
        return !this.chunks.isEmpty() && this.chunks.stream().map(ChunkEntry::future).noneMatch(CompletableFuture::isDone);
    }

    public boolean isBuildDone() {
        return this.chunks.stream().map(ChunkEntry::future).allMatch(CompletableFuture::isDone);
    }

    @Override
    public void close() {
        this.canceled = true;
        this.chunks.stream().map(ChunkEntry::future).map(CompletableFuture::join).filter(Objects::nonNull).forEach(BuiltChunk::close);
        this.canceled = false;
        this.chunks.clear();
        this.lastPos.set(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        this.pos.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.lastChunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private record ChunkEntry(class_1923 pos, CompletableFuture<@Nullable BuiltChunk> future) {
    }

    private record BuiltChunk(Map<class_1921, class_287> builderCache, Map<class_1921, class_9799> allocatorCache, Map<class_1921, class_9801> builtBuffers, Map<class_1921, class_9801.class_9802> sortStates, Map<class_1921, class_291> buffers) implements AutoCloseable
    {
        private BuiltChunk() {
            this(new HashMap<class_1921, class_287>(), new HashMap<class_1921, class_9799>(), new HashMap<class_1921, class_9801>(), new HashMap<class_1921, class_9801.class_9802>(), new HashMap<class_1921, class_291>());
        }

        private boolean uploadBufferIfNot(class_1921 layer) {
            class_9801.class_9802 sortState;
            class_9801 built;
            class_291 buffer = this.buffers.get(layer);
            if (buffer != null) {
                return false;
            }
            class_287 builder = this.builderCache.get(layer);
            if (builder == null) {
                return false;
            }
            try {
                built = builder.method_60794();
            }
            catch (Exception e) {
                return false;
            }
            if (built == null) {
                return false;
            }
            this.builtBuffers.put(layer, built);
            if (layer == class_1921.method_23583() && (sortState = built.method_60819(this.allocatorCache.get(layer), class_8251.field_43360)) != null) {
                this.sortStates.put(layer, sortState);
            }
            buffer = new class_291(class_8555.field_54340);
            buffer.method_1353();
            buffer.method_1352(built);
            this.buffers.put(layer, buffer);
            return true;
        }

        private void resortTransparent(class_1921 layer, class_8251 vertexSorter) {
            class_9799 allocator;
            class_9799.class_9800 result;
            class_291 buffer;
            class_9801.class_9802 sortState = this.sortStates().get(layer);
            if (sortState != null && (buffer = this.buffers().get(layer)) != null && (result = sortState.method_60824(allocator = this.getAllocatorByLayer(layer), vertexSorter)) != null) {
                buffer.method_1353();
                buffer.method_60829(result);
            }
        }

        private class_287 getBuilderByLayer(class_1921 layer) {
            return this.builderCache.computeIfAbsent(layer, l -> new class_287(this.getAllocatorByLayer((class_1921)l), l.method_23033(), l.method_23031()));
        }

        private class_9799 getAllocatorByLayer(class_1921 layer) {
            return this.allocatorCache.computeIfAbsent(layer, l -> new class_9799(l.method_22722()));
        }

        @Override
        public void close() {
            this.allocatorCache.values().forEach(class_9799::close);
            this.builtBuffers.values().forEach(class_9801::close);
            this.buffers.values().forEach(class_291::close);
        }
    }
}

