/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10286;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1845;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2802;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2823;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_5269;
import net.minecraft.class_5362;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8921;
import net.minecraft.class_9209;
import net.minecraft.class_9895;
import org.jetbrains.annotations.Nullable;

public class WorldSchematicWrapper
extends class_1937
implements class_2823 {
    private final class_3568 lightingProvider = new FakeLightingProvider(this);
    private final Map<String, class_2338> areaPoses = new HashMap<String, class_2338>();
    private final class_1959 biome;
    private LitematicaSchematic schematic;
    private class_2382 areasOrigin = new class_2382(0, 0, 0);
    private class_2382 size = new class_2382(0, 0, 0);
    private class_2680[] blocksData;
    private Map<class_2338, Supplier<class_2586>> blockEntities;

    public WorldSchematicWrapper(class_310 mc) {
        super((class_5269)new class_638.class_5271(class_1267.field_5801, false, true), class_1937.field_25179, mc.field_1687.method_30349(), (class_6880)mc.field_1687.method_30349().method_30530(class_7924.field_41241).method_46747(class_7134.field_37666), true, false, 0L, 0);
        this.biome = (class_1959)this.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9451);
    }

    public void setSchematic(LitematicaSchematic schematic) {
        this.schematic = schematic;
        this.areaPoses.clear();
        schematic.getAreas().forEach((region, box) -> this.areaPoses.put((String)region, class_2338.method_58249((class_2338)box.getPos1(), (class_2338)box.getPos2())));
        class_2338.class_2339 areasOrigin = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        class_2338.class_2339 areasEnd = new class_2338.class_2339(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.areaPoses.forEach((region, areaPos) -> {
            areasOrigin.method_10103(Math.min(areasOrigin.method_10263(), areaPos.method_10263()), Math.min(areasOrigin.method_10264(), areaPos.method_10264()), Math.min(areasOrigin.method_10260(), areaPos.method_10260()));
            class_2382 areaSize = schematic.getSubRegionContainer(region).getSize();
            areasEnd.method_10103(Math.max(areasEnd.method_10263(), areaPos.method_10263() + areaSize.method_10263()), Math.max(areasEnd.method_10264(), areaPos.method_10264() + areaSize.method_10264()), Math.max(areasEnd.method_10260(), areaPos.method_10260() + areaSize.method_10260()));
        });
        this.areasOrigin = areasOrigin;
        this.size = areasEnd.method_10059((class_2382)areasOrigin);
        this.blocksData = new class_2680[this.size.method_10263() * this.size.method_10264() * this.size.method_10260()];
        ImmutableMap.Builder blockEntitiesBuilder = ImmutableMap.builder();
        this.areaPoses.forEach((region, areaPos) -> {
            class_2338 shift = areaPos.method_10059((class_2382)areasOrigin);
            schematic.getBlockEntityMapForRegion(region).forEach((relPos, nbtCompound) -> {
                class_2338 pos = relPos.method_10081((class_2382)shift);
                blockEntitiesBuilder.put((Object)pos, (Object)Suppliers.memoize(() -> {
                    class_2586 blockEntity = WorldSchematicWrapper.silentCreateTileFromNbt(pos, this.method_8320(pos), nbtCompound, (class_7225.class_7874)this.method_30349());
                    if (blockEntity != null) {
                        blockEntity.method_31662((class_1937)this);
                    }
                    return blockEntity;
                }));
            });
        });
        this.blockEntities = blockEntitiesBuilder.buildKeepingLast();
    }

    @Nullable
    private static class_2586 silentCreateTileFromNbt(class_2338 pos, class_2680 state, class_2487 nbt, class_7225.class_7874 registries) {
        String string = nbt.method_10558("id");
        class_2960 identifier = class_2960.method_12829((String)string);
        if (identifier == null) {
            return null;
        }
        return class_7923.field_41181.method_17966(identifier).map(type -> {
            try {
                return type.method_11032(pos, state);
            }
            catch (Exception e) {
                return null;
            }
        }).map(blockEntity -> {
            try {
                blockEntity.method_58690(nbt, registries);
                return blockEntity;
            }
            catch (Exception e) {
                return null;
            }
        }).orElseGet(() -> null);
    }

    public class_2382 getSize() {
        return this.size;
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return 1.0f;
    }

    public class_3568 method_22336() {
        return this.lightingProvider;
    }

    public int method_23752(class_2338 pos, class_6539 colorResolver) {
        return colorResolver.getColor(this.biome, (double)pos.method_10263(), (double)pos.method_10260());
    }

    public class_6880<class_1959> method_22387(int biomeX, int biomeY, int biomeZ) {
        return null;
    }

    public int method_8615() {
        return 0;
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        Supplier<class_2586> supplier = this.blockEntities.get(pos);
        return supplier != null ? supplier.get() : null;
    }

    @Nullable
    public class_1297 method_8469(int id) {
        return null;
    }

    public class_8921 method_54719() {
        return null;
    }

    @Nullable
    public class_22 method_17891(class_9209 id) {
        return null;
    }

    public void method_17890(class_9209 id, class_22 state) {
    }

    public class_9209 method_17889() {
        return null;
    }

    public void method_8517(int entityId, class_2338 pos, int progress) {
    }

    public class_269 method_8428() {
        return null;
    }

    public class_10286 method_8433() {
        return null;
    }

    protected class_5577<class_1297> method_31592() {
        return null;
    }

    public class_1845 method_59547() {
        return null;
    }

    public class_9895 method_61269() {
        return null;
    }

    public Map<class_2338, Supplier<class_2586>> getBlockEntities() {
        return this.blockEntities;
    }

    public class_2680 method_8320(class_2338 pos) {
        if (this.blocksData == null || WorldSchematicWrapper.isOutOfSize(pos.method_10263(), pos.method_10264(), pos.method_10260(), this.size)) {
            return class_2246.field_10124.method_9564();
        }
        int index = this.getBlocksDataIndex(pos);
        class_2680 state = this.blocksData[index];
        if (state == null) {
            for (Map.Entry<String, class_2338> areaEntry : this.areaPoses.entrySet()) {
                int z;
                int y;
                LitematicaBlockStateContainer container = this.schematic.getSubRegionContainer(areaEntry.getKey());
                int x = pos.method_10263() - areaEntry.getValue().method_10263() + this.areasOrigin.method_10263();
                if (WorldSchematicWrapper.isOutOfSize(x, y = pos.method_10264() - areaEntry.getValue().method_10264() + this.areasOrigin.method_10264(), z = pos.method_10260() - areaEntry.getValue().method_10260() + this.areasOrigin.method_10260(), container.getSize())) continue;
                this.blocksData[index] = container.get(x, y, z);
                return this.blocksData[index];
            }
        }
        return state != null ? state : class_2246.field_10124.method_9564();
    }

    private static boolean isOutOfSize(int x, int y, int z, class_2382 size) {
        return x < 0 || x >= size.method_10263() || y < 0 || y >= size.method_10264() || z < 0 || z >= size.method_10260();
    }

    private int getBlocksDataIndex(class_2338 pos) {
        return pos.method_10264() * this.size.method_10263() * this.size.method_10260() + pos.method_10260() * this.size.method_10263() + pos.method_10263();
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public void method_8465(@Nullable class_1657 source, double x, double y, double z, class_6880<class_3414> sound, class_3419 category, float volume, float pitch, long seed) {
    }

    public void method_8449(@Nullable class_1657 source, class_1297 entity, class_6880<class_3414> sound, class_3419 category, float volume, float pitch, long seed) {
    }

    public void method_8454(@Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 behavior, double x, double y, double z, float power, boolean createFire, class_1937.class_7867 explosionSourceType, class_2394 smallParticle, class_2394 largeParticle, class_6880<class_3414> soundEvent) {
    }

    public String method_31419() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public int method_31605() {
        return 384;
    }

    public int method_31607() {
        return 0;
    }

    public class_2818 method_8497(int chunkX, int chunkZ) {
        return null;
    }

    public class_7699 method_45162() {
        return class_7701.field_40183;
    }

    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
    }

    public class_1922 method_16399() {
        return this;
    }

    public class_6756<class_2248> method_8397() {
        return null;
    }

    public class_6756<class_3611> method_8405() {
        return null;
    }

    public class_2802 method_8398() {
        return null;
    }

    public void method_8444(@Nullable class_1657 player, int eventId, class_2338 pos, int data) {
    }

    public void method_32888(class_6880<class_5712> event, class_243 emitterPos, class_5712.class_7397 emitter) {
    }

    public List<? extends class_1657> method_18456() {
        return List.of();
    }

    private static class FakeLightingProvider
    extends class_3568 {
        private final class_3562 FULL_BRIGHT_VIEW = new class_3562(this){

            @Nullable
            public class_2804 method_15544(class_4076 pos) {
                return null;
            }

            public int method_15543(class_2338 pos) {
                return 15;
            }

            public void method_15513(class_2338 pos) {
            }

            public boolean method_15518() {
                return false;
            }

            public int method_15516() {
                return 15;
            }

            public void method_15551(class_4076 pos, boolean notReady) {
            }

            public void method_15512(class_1923 pos, boolean retainData) {
            }

            public void method_51471(class_1923 chunkPos) {
            }
        };

        public FakeLightingProvider(class_2823 chunkProvider) {
            super(chunkProvider, false, false);
        }

        public class_3562 method_15562(class_1944 lightType) {
            return this.FULL_BRIGHT_VIEW;
        }
    }
}

