/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui.widget;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import java.util.Locale;
import java.util.function.IntUnaryOperator;
import ru.dimaskama.schematicpreview.SchematicPreviewConfigs;

public enum SchematicPreviewType implements IConfigOptionListEntry
{
    LIST(1, w -> SchematicPreviewConfigs.LIST_ENTRY_HEIGHT.getIntegerValue()),
    LIST_PREVIEW(1, w -> SchematicPreviewConfigs.LIST_PREVIEW_ENTRY_HEIGHT.getIntegerValue()),
    TILE_5(5, SchematicPreviewType::tileWidthToHeight),
    TILE_4(4, SchematicPreviewType::tileWidthToHeight),
    TILE_3(3, SchematicPreviewType::tileWidthToHeight);

    private final int columns;
    private final IntUnaryOperator widthToHeight;

    private SchematicPreviewType(int columns, IntUnaryOperator widthToHeight) {
        this.columns = columns;
        this.widthToHeight = widthToHeight;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getHeight(int width) {
        return this.widthToHeight.applyAsInt(width);
    }

    public boolean isList() {
        return this == LIST || this == LIST_PREVIEW;
    }

    public boolean isTile() {
        return this == TILE_5 || this == TILE_4 || this == TILE_3;
    }

    public boolean hasPreview() {
        return this == LIST_PREVIEW || this.isTile();
    }

    public String getStringValue() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public String getDisplayName() {
        return this.toString();
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        return SchematicPreviewType.values()[(this.ordinal() + (forward ? 1 : -1)) % SchematicPreviewType.values().length];
    }

    public IConfigOptionListEntry fromString(String value) {
        try {
            return SchematicPreviewType.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return LIST;
        }
    }

    private static int tileWidthToHeight(int width) {
        return (int)((double)width * SchematicPreviewConfigs.TILE_HEIGHT_RATIO.getDoubleValue());
    }
}

