/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.util.FileType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_310;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewWidget;

public class PreviewsCache
implements AutoCloseable {
    private final Map<Path, CompletableFuture<LitematicaSchematic>> schematics = new HashMap<Path, CompletableFuture<LitematicaSchematic>>();
    private final Map<Path, SchematicPreviewWidget> smallWidgets = new HashMap<Path, SchematicPreviewWidget>();
    private boolean closed = false;

    public CompletableFuture<LitematicaSchematic> getSchematic(Path file) {
        this.closed = false;
        return this.schematics.computeIfAbsent(file, f -> CompletableFuture.supplyAsync(() -> LitematicaSchematic.createFromFile((Path)f.getParent(), (String)f.getFileName().toString(), (FileType)FileType.fromFile((Path)f)), (Executor)class_156.method_55473()));
    }

    public SchematicPreviewWidget getSmallWidget(Path file) {
        this.closed = false;
        return this.smallWidgets.computeIfAbsent(file, f -> {
            SchematicPreviewWidget w = new SchematicPreviewWidget(this, false);
            w.setSchematic((Path)f);
            return w;
        });
    }

    public void tickClose() {
        if (!this.closed && class_310.method_1551().field_1755 == null) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.schematics.values().forEach(f -> f.cancel(true));
        this.schematics.clear();
        this.smallWidgets.values().forEach(SchematicPreviewWidget::removed);
        this.smallWidgets.clear();
        this.closed = true;
    }
}

