/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.render.schematic.IBufferBuilderPatch;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.render.CustomVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.DummyOutlineVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.DummyVertexConsumerProvider;
import ru.dimaskama.schematicpreview.render.WorldSchematicWrapper;

public class SchematicPreviewRenderer
implements AutoCloseable {
    private static final class_11515[] BLOCK_RENDER_LAYER_ORDER = new class_11515[]{class_11515.field_60923, class_11515.field_60925, class_11515.field_60924, class_11515.field_60926, class_11515.field_60927};
    private final WorldSchematicWrapper world;
    private final class_776 blockRenderManager;
    private final class_824 blockEntityRenderManager;
    private final class_11661 orderedRenderCommandQueue;
    private final CustomVertexConsumerProvider customVertexConsumerProvider;
    private final class_11684 renderDispatcher;
    private final List<ChunkEntry> chunks = new ArrayList<ChunkEntry>();
    private final Vector3f pos = new Vector3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
    private final Vector3f lastPos = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    private class_1923 lastChunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private class_12075 cameraRenderState;
    private boolean updated;
    private boolean canceled;
    private class_276 target;

    public SchematicPreviewRenderer(class_310 mc) {
        this.world = new WorldSchematicWrapper(mc);
        this.blockRenderManager = mc.method_1541();
        this.blockEntityRenderManager = mc.method_31975();
        this.orderedRenderCommandQueue = new class_11661();
        this.customVertexConsumerProvider = new CustomVertexConsumerProvider(mc.method_22940().method_23000());
        this.renderDispatcher = new class_11684(this.orderedRenderCommandQueue, this.blockRenderManager, (class_4597.class_4598)this.customVertexConsumerProvider, mc.method_72703(), (class_4618)new DummyOutlineVertexConsumerProvider(), (class_4597.class_4598)new DummyVertexConsumerProvider(), mc.field_1772);
    }

    public void setup(LitematicaSchematic schematic) {
        this.close();
        this.world.setSchematic(schematic);
        int height = this.world.getSize().method_10264();
        int chunksX = this.world.getSize().method_10263() >>> 4;
        int chunksZ = this.world.getSize().method_10260() >>> 4;
        for (int chunkX = 0; chunkX <= chunksX; ++chunkX) {
            for (int chunkZ = 0; chunkZ <= chunksZ; ++chunkZ) {
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                this.chunks.add(new ChunkEntry(chunkPos, CompletableFuture.supplyAsync(() -> {
                    class_6575 random = new class_6575(0L);
                    BuiltChunk chunk = new BuiltChunk();
                    class_4587 matrices = new class_4587();
                    class_2338.class_2339 worldPos = new class_2338.class_2339();
                    int chunkStartX = chunkPos.method_8326();
                    int chunkStartZ = chunkPos.method_8328();
                    int chunkEndX = chunkStartX + 16;
                    int chunkEndZ = chunkStartZ + 16;
                    for (int y = 0; y < height; ++y) {
                        for (int z = chunkStartZ; z < chunkEndZ; ++z) {
                            for (int x = chunkStartX; x < chunkEndX; ++x) {
                                class_287 builder;
                                class_11515 layer;
                                boolean renderBlock;
                                if (this.canceled) {
                                    chunk.close();
                                    return null;
                                }
                                worldPos.method_10103(x, y, z);
                                class_2680 state = this.world.method_8320((class_2338)worldPos);
                                class_3610 fluid = state.method_26227();
                                boolean renderFluid = !fluid.method_15769();
                                boolean bl = renderBlock = state.method_26217() == class_2464.field_11458;
                                if (!renderFluid && !renderBlock) continue;
                                matrices.method_22903();
                                matrices.method_46416((float)(worldPos.method_10263() & 0xF), (float)worldPos.method_10264(), (float)(worldPos.method_10260() & 0xF));
                                if (renderFluid) {
                                    layer = class_4696.method_23680((class_3610)fluid);
                                    builder = chunk.getBuilderByLayer(layer);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY((float)(worldPos.method_10264() >> 4 << 4));
                                    this.blockRenderManager.method_3352((class_2338)worldPos, (class_1920)this.world, (class_4588)builder, state, fluid);
                                    ((IBufferBuilderPatch)builder).litematica$setOffsetY(0.0f);
                                }
                                if (renderBlock) {
                                    layer = class_4696.method_23679((class_2680)state);
                                    builder = chunk.getBuilderByLayer(layer);
                                    this.blockRenderManager.method_3350().method_3361((class_1920)this.world, this.blockRenderManager.method_3349(state).method_68512((class_5819)random), state, (class_2338)worldPos, matrices, (class_4588)builder, true, class_4608.field_21444);
                                }
                                matrices.method_22909();
                            }
                        }
                    }
                    return chunk;
                })));
            }
        }
    }

    public void prepareRender(class_12075 cameraRenderState, class_276 target) {
        this.cameraRenderState = cameraRenderState;
        this.target = target;
        this.pos.set(cameraRenderState.field_63078.field_1352, cameraRenderState.field_63078.field_1351, cameraRenderState.field_63078.field_1350);
        boolean bl = this.updated = !this.lastPos.equals((Object)this.pos);
        if (this.updated) {
            this.lastPos.set(cameraRenderState.field_63078.field_1352, cameraRenderState.field_63078.field_1351, cameraRenderState.field_63078.field_1350);
            class_1923 chunkPos = new class_1923(class_3532.method_15357((double)cameraRenderState.field_63078.field_1352) >> 4, class_3532.method_15357((double)cameraRenderState.field_63078.field_1350) >> 4);
            if (!this.lastChunkPos.equals((Object)chunkPos)) {
                this.lastChunkPos = chunkPos;
                this.chunks.sort(Comparator.comparingInt(chunk -> -(Math.abs(chunk.pos.field_9181 - chunkPos.field_9181) + Math.abs(chunk.pos.field_9180 - chunkPos.field_9180))));
            }
        }
    }

    public void renderBlocks() {
        EnumMap drawsPerLayer = new EnumMap(class_11515.class);
        int maxIndicesRequired = 0;
        ArrayList<class_11282.class_11283> dynamicTransforms = new ArrayList<class_11282.class_11283>();
        class_8251 vertexSorter = class_8251.method_49906((float)this.pos.x, (float)this.pos.y, (float)this.pos.z);
        for (class_11515 layer : BLOCK_RENDER_LAYER_ORDER) {
            drawsPerLayer.put(layer, new ArrayList());
            for (ChunkEntry chunk : this.chunks) {
                VertexFormat.class_5595 indexType;
                GpuBuffer gpuBuffer;
                if (!chunk.future.isDone()) continue;
                BuiltChunk built = chunk.future.join();
                built.uploadBuffer(layer, vertexSorter);
                class_10896 buffers = built.buffers.get(layer);
                if (buffers == null) continue;
                if (this.updated) {
                    built.resortTransparent(layer, vertexSorter);
                }
                if (buffers.method_68544() == null) {
                    maxIndicesRequired = Math.max(maxIndicesRequired, buffers.method_68546());
                    gpuBuffer = null;
                    indexType = null;
                } else {
                    gpuBuffer = buffers.method_68544();
                    indexType = buffers.method_68547();
                }
                int j = dynamicTransforms.size();
                dynamicTransforms.add(new class_11282.class_11283((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f), (Vector3fc)new Vector3f((float)chunk.pos.method_8326() - this.pos.x, -this.pos.y, (float)chunk.pos.method_8328() - this.pos.z), (Matrix4fc)new Matrix4f(), 1.0f));
                ((List)drawsPerLayer.get(layer)).add(new RenderPass.class_10884(0, buffers.method_68540(), gpuBuffer, indexType, 0, buffers.method_68546(), (gpuBufferSlicesx, uniformUploader) -> uniformUploader.upload("DynamicTransforms", gpuBufferSlicesx[j])));
            }
        }
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer gpuBuffer = maxIndicesRequired == 0 ? null : shapeIndexBuffer.method_68274(maxIndicesRequired);
        VertexFormat.class_5595 indexType = maxIndicesRequired == 0 ? null : shapeIndexBuffer.method_31924();
        GpuBufferSlice[] dynamicTransformsGpuBuffers = RenderSystem.getDynamicUniforms().method_71107((class_11282.class_11283[])dynamicTransforms.toArray(class_11282.class_11283[]::new));
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "SchematicPreview", this.target.method_71639(), OptionalInt.empty(), this.target.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.bindSampler("Sampler2", class_310.method_1551().field_1773.method_22974().method_71650());
            for (class_11515 layer : BLOCK_RENDER_LAYER_ORDER) {
                SequencedCollection draws = (List)drawsPerLayer.get(layer);
                if (draws.isEmpty()) continue;
                if (layer == class_11515.field_60926) {
                    draws = draws.reversed();
                }
                renderPass.setPipeline(layer.method_72020());
                renderPass.bindSampler("Sampler0", layer.method_72024());
                renderPass.drawMultipleIndexed((Collection)draws, gpuBuffer, indexType, List.of("DynamicTransforms"), (Object)dynamicTransformsGpuBuffers);
            }
        }
    }

    public void renderBlockEntities(class_4587 stack, float tickDelta) {
        if (this.getBuiltChunksCount() != this.chunks.size()) {
            return;
        }
        this.customVertexConsumerProvider.setFramebuffer(this.target);
        this.world.getBlockEntities().forEach((pos, blockEntitySupplier) -> {
            class_827 renderer;
            class_2586 blockEntity = (class_2586)blockEntitySupplier.get();
            if (blockEntity != null && (renderer = this.blockEntityRenderManager.method_3550(blockEntity)) != null) {
                class_11954 renderState = renderer.method_74335();
                stack.method_22903();
                stack.method_46416((float)pos.method_10263() - this.lastPos.x, (float)pos.method_10264() - this.lastPos.y, (float)pos.method_10260() - this.lastPos.z);
                try {
                    renderer.method_74331(blockEntity, renderState, tickDelta, this.cameraRenderState.field_63078, null);
                    renderer.method_3569(renderState, stack, (class_11659)this.orderedRenderCommandQueue, this.cameraRenderState);
                }
                catch (Exception e) {
                    SchematicPreview.LOGGER.debug("Exception while rendering preview block entity", (Throwable)e);
                }
                stack.method_22909();
            }
        });
        this.renderDispatcher.method_73002();
        this.customVertexConsumerProvider.method_22993();
    }

    public int getBuiltChunksCount() {
        return (int)this.chunks.stream().map(ChunkEntry::future).filter(CompletableFuture::isDone).count();
    }

    public boolean isBuildingTerrain() {
        return !this.chunks.isEmpty() && this.chunks.stream().map(ChunkEntry::future).noneMatch(CompletableFuture::isDone);
    }

    @Override
    public void close() {
        this.canceled = true;
        this.chunks.stream().map(ChunkEntry::future).map(CompletableFuture::join).filter(Objects::nonNull).forEach(BuiltChunk::close);
        this.canceled = false;
        this.chunks.clear();
        this.lastPos.set(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        this.pos.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.lastChunkPos = new class_1923(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.renderDispatcher.close();
    }

    private record ChunkEntry(class_1923 pos, CompletableFuture<@Nullable BuiltChunk> future) {
    }

    private record BuiltChunk(Map<class_11515, class_287> builderCache, Map<class_11515, class_9799> allocatorCache, Map<class_11515, class_9801> builtBuffers, Map<class_11515, class_9801.class_9802> sortStates, Map<class_11515, class_10896> buffers) implements AutoCloseable
    {
        private BuiltChunk() {
            this(new HashMap<class_11515, class_287>(), new HashMap<class_11515, class_9799>(), new HashMap<class_11515, class_9801>(), new HashMap<class_11515, class_9801.class_9802>(), new HashMap<class_11515, class_10896>());
        }

        private void uploadBuffer(class_11515 layer, class_8251 vertexSorter) {
            class_9801.class_9802 sortState;
            class_10896 buffers = this.buffers.get(layer);
            if (buffers != null) {
                return;
            }
            class_287 builder = this.builderCache.get(layer);
            if (builder == null || !builder.field_1556) {
                return;
            }
            class_9801 built = builder.method_60794();
            if (built == null) {
                return;
            }
            this.builtBuffers.put(layer, built);
            if (layer == class_11515.field_60926 && (sortState = built.method_60819(this.allocatorCache.get(layer), vertexSorter)) != null) {
                this.sortStates.put(layer, sortState);
            }
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "SchematicPreview vertex buffer", 40, built.method_60818());
            GpuBuffer indexBuffer = built.method_60821() != null ? RenderSystem.getDevice().createBuffer(() -> "SchematicPreview index buffer", 72, built.method_60821()) : null;
            buffers = new class_10896(vertexBuffer, indexBuffer, built.method_60822().comp_751(), built.method_60822().comp_753());
            this.buffers.put(layer, buffers);
        }

        private void resortTransparent(class_11515 layer, class_8251 vertexSorter) {
            GpuBuffer indexBuffer;
            class_10896 buffers;
            class_9801.class_9802 sortState = this.sortStates.get(layer);
            if (sortState != null && (buffers = this.buffers.get(layer)) != null && (indexBuffer = buffers.method_68544()) != null && !indexBuffer.isClosed()) {
                class_9799 allocator = this.getAllocatorByLayer(layer);
                try (class_9799.class_9800 result = sortState.method_60824(allocator, vertexSorter);){
                    if (result != null) {
                        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(indexBuffer.slice(), result.method_60817());
                    }
                }
            }
        }

        private class_287 getBuilderByLayer(class_11515 layer) {
            return this.builderCache.computeIfAbsent(layer, l -> new class_287(this.getAllocatorByLayer((class_11515)l), l.method_72020().getVertexFormatMode(), l.method_72020().getVertexFormat()));
        }

        private class_9799 getAllocatorByLayer(class_11515 layer) {
            return this.allocatorCache.computeIfAbsent(layer, l -> new class_9799(1536));
        }

        @Override
        public void close() {
            this.allocatorCache.values().forEach(class_9799::close);
            this.builtBuffers.values().forEach(class_9801::close);
            this.buffers.values().forEach(class_10896::close);
        }
    }
}

