/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import ru.dimaskama.schematicpreview.ItemIconState;
import ru.dimaskama.schematicpreview.SchematicPreview;

public class SchematicPreviewCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<String, ItemIconState> ICONS = new HashMap<String, ItemIconState>();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("schematicpreview_cache.json");
    private static boolean dirty;

    public static void markDirty() {
        dirty = true;
    }

    public static void loadOrCreate() {
        if (Files.exists(PATH, new LinkOption[0])) {
            SchematicPreviewCache.load();
        } else {
            SchematicPreviewCache.forceSave();
        }
    }

    public static void load() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(PATH, new OpenOption[0]));){
                SchematicPreviewCache.decode(JsonParser.parseReader((Reader)reader).getAsJsonObject());
            }
            catch (Exception e) {
                SchematicPreview.LOGGER.warn("Cache load exception {}", (Object)PATH, (Object)e);
            }
        }
    }

    public static void save() {
        if (dirty) {
            SchematicPreviewCache.forceSave();
        }
    }

    public static void forceSave() {
        dirty = false;
        try {
            JsonObject json = new JsonObject();
            SchematicPreviewCache.encode(json);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(PATH, new OpenOption[0]));){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception e) {
            SchematicPreview.LOGGER.warn("Cache save exception {}", (Object)PATH, (Object)e);
        }
    }

    private static void decode(JsonObject json) {
        ICONS.clear();
        JsonObject icons = json.getAsJsonObject("icons");
        if (icons != null) {
            icons.asMap().forEach((k, v) -> ItemIconState.CODEC.decode((DynamicOps)JsonOps.INSTANCE, v).ifSuccess(p -> ICONS.put((String)k, (ItemIconState)p.getFirst())));
        }
    }

    private static void encode(JsonObject json) {
        JsonObject icons = new JsonObject();
        ICONS.forEach((k, v) -> ItemIconState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, v).ifSuccess(j -> icons.add(k, j)));
        json.add("icons", (JsonElement)icons);
    }
}

