/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import ru.dimaskama.schematicpreview.gui.widget.SchematicPreviewType;

public class SchematicPreviewConfigs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "schematicpreview.json";
    public static final SchematicPreviewConfigs INSTANCE = new SchematicPreviewConfigs();
    public static final ConfigBoolean ENABLED = new ConfigBoolean("schematicpreviewEnabled", true, "Toggle mod enabled");
    public static final ConfigHotkey CONFIG_MENU_HOTKEY = new ConfigHotkey("schematicpreviewConfigMenuHotkey", "RIGHT_SHIFT,F8", "Hotkey to open this menu");
    public static final ConfigOptionList PREVIEW_TYPE = new ConfigOptionList("schematicpreviewType", (IConfigOptionListEntry)SchematicPreviewType.LIST, "Selected browser entry type");
    public static final ConfigInteger ENTRY_GAP_X = new ConfigInteger("schematicpreviewEntryGapX", 2, 0, 10, "Browser entry X axis gap");
    public static final ConfigInteger ENTRY_GAP_Y = new ConfigInteger("schematicpreviewEntryGapY", 2, 0, 10, "Browser entry Y axis gap");
    public static final ConfigInteger LIST_ENTRY_HEIGHT = new ConfigInteger("schematicpreviewListEntryHeight", 15, 10, 80, "Height of entry for browser type \"List\"");
    public static final ConfigInteger LIST_PREVIEW_ENTRY_HEIGHT = new ConfigInteger("schematicpreviewListPreviewEntryHeight", 35, 15, 80, "Height of entry for browser type \"List Preview\"");
    public static final ConfigDouble TILE_HEIGHT_RATIO = new ConfigDouble("schematicpreviewTileHeightRatio", 1.0, 0.3, 5.0, "Width/Height ratio of entries for Tile browser types");
    public static final ConfigInteger PREVIEW_MAX_VOLUME = new ConfigInteger("schematicpreviewMaxVolume", 125000, 0, Integer.MAX_VALUE, "Max. schem volume in list preview");
    public static final ConfigBoolean RENDER_TILE = new ConfigBoolean("schematicpreviewRenderTile", true, "Toggle render tile entities");
    public static final ConfigDouble PREVIEW_FOV = new ConfigDouble("schematicpreviewFov", 50.0, 30.0, 100.0, "3D preview FOV");
    public static final ConfigDouble PREVIEW_ROTATION_Y = new ConfigDouble("schematicpreviewRotationY", -45.0, -180.0, 179.99999000000025, "3D preview Y Rotation");
    public static final ConfigDouble PREVIEW_ROTATION_X = new ConfigDouble("schematicpreviewRotationX", 30.0, -90.0, 89.99999000000025, "3D preview X Rotation");
    public static final List<IConfigBase> GENERIC = List.of(ENABLED, CONFIG_MENU_HOTKEY);
    public static final List<IConfigBase> MENU = List.of(PREVIEW_TYPE, ENTRY_GAP_X, ENTRY_GAP_Y, LIST_ENTRY_HEIGHT, LIST_PREVIEW_ENTRY_HEIGHT, TILE_HEIGHT_RATIO);
    public static final List<IConfigBase> PREVIEW = List.of(PREVIEW_MAX_VOLUME, RENDER_TILE, PREVIEW_FOV, PREVIEW_ROTATION_Y, PREVIEW_ROTATION_X);
    public static final List<ConfigHotkey> HOTKEYS = List.of(CONFIG_MENU_HOTKEY);

    private SchematicPreviewConfigs() {
    }

    public void load() {
        JsonElement json;
        Path configPath = FileUtils.getConfigDirectoryAsPath().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configPath, new LinkOption[0]) && Files.isRegularFile(configPath, new LinkOption[0]) && (json = JsonUtils.parseJsonFileAsPath((Path)configPath)) != null && json.isJsonObject()) {
            ConfigUtils.readConfigBase((JsonObject)json.getAsJsonObject(), (String)"Generic", GENERIC);
            ConfigUtils.readConfigBase((JsonObject)json.getAsJsonObject(), (String)"Menu", MENU);
            ConfigUtils.readConfigBase((JsonObject)json.getAsJsonObject(), (String)"Preview", PREVIEW);
        }
    }

    public void save() {
        Path dir = FileUtils.getConfigDirectoryAsPath();
        if (Files.exists(dir, new LinkOption[0]) && Files.exists(dir, new LinkOption[0])) {
            JsonObject json = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)json, (String)"Generic", GENERIC);
            ConfigUtils.writeConfigBase((JsonObject)json, (String)"Menu", MENU);
            ConfigUtils.writeConfigBase((JsonObject)json, (String)"Preview", PREVIEW);
            JsonUtils.writeJsonToFileAsPath((JsonObject)json, (Path)dir.resolve(CONFIG_FILE_NAME));
        }
    }
}

