/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.schematicpreview.gui.widget;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_11286;
import net.minecraft.class_11909;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import ru.dimaskama.schematicpreview.SchematicPreview;
import ru.dimaskama.schematicpreview.SchematicPreviewConfigs;
import ru.dimaskama.schematicpreview.gui.GuiSchematicPreviewFullscreen;
import ru.dimaskama.schematicpreview.gui.widget.OnOffButton;
import ru.dimaskama.schematicpreview.render.PreviewsCache;
import ru.dimaskama.schematicpreview.render.SchematicPreviewRenderer;

public class SchematicPreviewWidget
extends WidgetBase {
    private final Renderer renderer;
    private final Runnable tickAction;
    private final List<class_339> buttons;
    private final Vector3f rotOrigin;
    private final PreviewsCache cache;
    private final boolean nonStatic;
    private Path schematicFile;
    private LitematicaSchematic lastSchematic;
    private class_276 framebuffer;
    private boolean mouseDragging;
    private int lastMouseX;
    private int lastMouseY;
    private boolean fullscreen;
    private boolean freecam;
    private float distance;
    private float yRot;
    private float xRot;

    public SchematicPreviewWidget(PreviewsCache cache, boolean nonStatic) {
        super(0, 0, 0, 0);
        this.renderer = new Renderer(this.mc);
        this.tickAction = this::tick;
        this.rotOrigin = new Vector3f();
        this.cache = cache;
        this.nonStatic = nonStatic;
        this.buttons = nonStatic ? List.of(new OnOffButton(6, 6, (class_2561)class_2561.method_43471((String)"button.schematicpreview.fullscreen"), this::toggleFullscreen, SchematicPreview.id("fullscreen_on"), SchematicPreview.id("fullscreen_on_focused"), SchematicPreview.id("fullscreen_off"), SchematicPreview.id("fullscreen_off_focused")), new OnOffButton(6, 6, (class_2561)class_2561.method_43471((String)"button.schematicpreview.freecam"), this::toggleFreecam, SchematicPreview.id("freecam_on"), SchematicPreview.id("freecam_on_focused"), SchematicPreview.id("freecam_off"), SchematicPreview.id("freecam_off_focused"))) : List.of();
    }

    public void setSchematic(Path schematicFile) {
        this.schematicFile = schematicFile;
    }

    public void renderPreviewAndOverlay(class_332 context, int x, int y, int width, int height) {
        SchematicPreview.addTickable(this.tickAction);
        if (x != this.x || y != this.y || width != this.width || height != this.height) {
            this.setPosition(x, y);
            this.setWidth(width);
            this.setHeight(height);
            this.resized();
        }
        int centerX = x + (width >> 1);
        int centerY = y + (height - 10 >> 1);
        CompletableFuture<LitematicaSchematic> loadingSchematic = this.cache.getSchematic(this.schematicFile);
        if (loadingSchematic.isDone()) {
            LitematicaSchematic schematic;
            if (!loadingSchematic.isCompletedExceptionally() && (schematic = loadingSchematic.join()) != null) {
                class_2382 size;
                int maxVolume = SchematicPreviewConfigs.PREVIEW_MAX_VOLUME.getIntegerValue();
                if (this.nonStatic || maxVolume == 0 || (size = schematic.getTotalSize()).method_10263() * size.method_10264() * size.method_10260() <= maxVolume) {
                    if (this.lastSchematic == null || this.lastSchematic != schematic && !Objects.equals(this.lastSchematic.getFile(), schematic.getFile())) {
                        this.lastSchematic = schematic;
                        this.renderer.newSchematic(schematic);
                        this.resetCameraPos();
                    }
                    if (!this.renderer.isBuildingTerrainOrStart()) {
                        this.renderPreviewAndOverlay(context, this.mc.method_61966().method_60637(true));
                    } else {
                        context.method_25300(this.textRenderer, "Building terrain...", centerX, centerY, -4473925);
                    }
                } else {
                    context.method_25300(this.textRenderer, "Too big", centerX, centerY, -4473925);
                }
            } else {
                context.method_25300(this.textRenderer, "Preview load failed", centerX, centerY, -43691);
            }
        } else {
            context.method_25300(this.textRenderer, "Loading preview...", centerX, centerY, -4473925);
        }
    }

    private void resized() {
        int x = this.x + 1;
        int y = this.y + 1;
        for (class_339 button : this.buttons) {
            button.method_48229(x, y);
            x += button.method_25368() + 2;
        }
    }

    private void renderPreviewAndOverlay(class_332 context, float tickDelta) {
        if (this.fullscreen) {
            context.method_25294(0, 0, context.method_51421(), context.method_51443(), -16777216);
        }
        boolean framebufferUpdated = this.prepareFramebuffer();
        if (this.nonStatic || framebufferUpdated || this.renderer.needsReRender()) {
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.framebuffer.method_30277(), 0, this.framebuffer.method_30278(), 1.0);
            this.renderer.render(this.framebuffer, tickDelta);
        }
        context.field_59826.method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)this.framebuffer.method_71639()), new Matrix3x2f((Matrix3x2fc)context.method_51448()), this.x, this.y, this.x + this.width, this.y + this.height, 0.0f, 1.0f, 1.0f, 0.0f, -1, context.field_44659.method_70863()));
        this.renderOverlay(context, tickDelta);
    }

    private boolean prepareFramebuffer() {
        double scale = this.mc.method_22683().method_4495();
        int scaledWidth = (int)(scale * (double)this.width);
        int scaledHeight = (int)(scale * (double)this.height);
        if (this.framebuffer == null) {
            this.framebuffer = new class_6367("SchematicPreview", scaledWidth, scaledHeight, true);
            return true;
        }
        if (this.framebuffer.field_1482 != scaledWidth || this.framebuffer.field_1481 != scaledHeight) {
            this.framebuffer.method_1234(scaledWidth, scaledHeight);
            return true;
        }
        return false;
    }

    private void renderOverlay(class_332 context, float tickDelta) {
        int mouseX = this.getMouseX();
        int mouseY = this.getMouseY();
        for (class_339 button : this.buttons) {
            button.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    private void toggleFullscreen(boolean fullscreen) {
        if (fullscreen) {
            this.mc.method_1507((class_437)new GuiSchematicPreviewFullscreen(this.mc.field_1755, this));
        } else if (this.mc.field_1755 != null) {
            this.mc.field_1755.method_25419();
        }
    }

    public void setFullScreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    private void toggleFreecam(boolean freecam) {
        this.freecam = freecam;
        if (!freecam) {
            this.resetCameraPos();
        }
    }

    private void resetCameraPos() {
        class_2382 size = this.lastSchematic.getMetadata().getEnclosingSize();
        this.rotOrigin.set((float)size.method_10263() * 0.5f, (float)size.method_10264() * 0.3f, (float)size.method_10260() * 0.5f);
        this.yRot = (float)SchematicPreviewConfigs.PREVIEW_ROTATION_Y.getDoubleValue();
        this.xRot = (float)SchematicPreviewConfigs.PREVIEW_ROTATION_X.getDoubleValue();
        this.distance = class_3532.method_15355((float)class_3532.method_60677((float)((float)size.method_10263() * 0.5f), (float)((float)size.method_10264() * 0.7f), (float)((float)size.method_10260() * 0.5f))) * 2.0f;
        this.updateRendererCameraPos();
        this.renderer.resetPosition();
    }

    private void updateRendererCameraPos() {
        this.renderer.setRotation(-this.xRot, this.yRot);
        Vector3f offset = SchematicPreviewWidget.getRotationVec(this.xRot, 180.0f + this.yRot).mul(-this.distance);
        this.renderer.setPos(this.rotOrigin.x + offset.x, this.rotOrigin.y + offset.y, this.rotOrigin.z + offset.z);
    }

    public void tick() {
        if (this.nonStatic) {
            this.renderer.tick();
            if (this.mouseDragging) {
                int x = this.getMouseX();
                int y = this.getMouseY();
                int deltaX = x - this.lastMouseX;
                int deltaY = y - this.lastMouseY;
                if (deltaX != 0 || deltaY != 0) {
                    this.mouseDragged(deltaX, deltaY);
                    this.lastMouseX = x;
                    this.lastMouseY = y;
                }
            }
        }
    }

    private int getMouseX() {
        return (int)(this.mc.field_1729.method_1603() * (double)this.mc.method_22683().method_4486() / (double)this.mc.method_22683().method_4480());
    }

    private int getMouseY() {
        return (int)(this.mc.field_1729.method_1604() * (double)this.mc.method_22683().method_4502() / (double)this.mc.method_22683().method_4507());
    }

    private void mouseDragged(int deltaX, int deltaY) {
        float dX = (float)deltaX / (float)this.width * 180.0f;
        float dY = (float)deltaY / (float)this.height * 180.0f;
        if (this.freecam) {
            this.renderer.setRotation(this.renderer.getPitch() - dY, this.renderer.getYaw() - dX);
        } else {
            this.yRot = class_3532.method_15393((float)(this.yRot - dX));
            this.xRot = class_3532.method_15363((float)(this.xRot + dY), (float)-90.0f, (float)90.0f);
            this.updateRendererCameraPos();
        }
    }

    protected boolean onMouseClickedImpl(class_11909 click, boolean doubleClick) {
        if (this.nonStatic) {
            for (class_339 button : this.buttons) {
                if (!button.method_25402(click, doubleClick)) continue;
                return true;
            }
            if (click.method_74245() == 0) {
                this.lastMouseX = (int)click.comp_4798();
                this.lastMouseY = (int)click.comp_4799();
                this.mouseDragging = true;
                return true;
            }
        }
        return false;
    }

    public void onMouseReleasedImpl(class_11909 click) {
        if (this.nonStatic && click.method_74245() == 0) {
            this.mouseDragging = false;
        }
    }

    public boolean onMouseScrolledImpl(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.nonStatic) {
            if (verticalAmount != 0.0) {
                float am = -((float)verticalAmount);
                if (this.freecam) {
                    Vector3f move = SchematicPreviewWidget.getRotationVec(this.renderer.getPitch(), this.renderer.getYaw()).mul(am *= 2.0f * (class_310.method_1551().method_74187() ? 2.0f : 1.0f) * (class_310.method_1551().method_74188() ? 2.0f : 1.0f));
                    this.renderer.setPos(this.renderer.getX() + move.x, this.renderer.getY() + move.y, this.renderer.getZ() + move.z);
                } else {
                    this.distance = class_3532.method_27285((float)Math.max(0.0f, class_3532.method_15355((float)this.distance) + am * 0.5f));
                    this.updateRendererCameraPos();
                }
            }
            return true;
        }
        return false;
    }

    public void removed() {
        if (this.framebuffer != null) {
            this.framebuffer.method_1238();
            this.framebuffer = null;
        }
        this.renderer.close();
        SchematicPreview.removeTickable(this.tickAction);
    }

    private static Vector3f getRotationVec(float pitch, float yaw) {
        float h = class_3532.method_15362((float)(yaw *= (float)Math.PI / 180));
        float i = class_3532.method_15374((float)yaw);
        float j = class_3532.method_15362((float)(pitch *= (float)Math.PI / 180));
        float k = class_3532.method_15374((float)pitch);
        return new Vector3f(i * j, -k, h * j);
    }

    private static class Renderer {
        private final class_310 mc;
        private final Quaternionf rotation = new Quaternionf();
        private final Vector3f lastRenderPos = new Vector3f();
        private final Vector3f prevPos = new Vector3f();
        private final Vector3f pos = new Vector3f(0.0f, 2.0f, 100.0f);
        private final Vector2f lastRenderRot = new Vector2f();
        private final Vector2f prevRot = new Vector2f();
        private final Vector2f rot = new Vector2f();
        private final class_12075 cameraRenderState = new class_12075();
        private SchematicPreviewRenderer renderer;
        private int lastChunksBuilt;
        private boolean schematicNew;
        @Nullable
        private class_11286 projectionMatrix;

        private Renderer(class_310 mc) {
            this.mc = mc;
        }

        private void tick() {
            this.resetPosition();
        }

        private void resetPosition() {
            this.prevPos.set((Vector3fc)this.pos);
            this.prevRot.set((Vector2fc)this.rot);
        }

        private float getX() {
            return this.pos.x;
        }

        private float getY() {
            return this.pos.y;
        }

        private float getZ() {
            return this.pos.z;
        }

        private void setPos(float x, float y, float z) {
            this.pos.set(x, y, z);
        }

        private float getPitch() {
            return this.rot.x;
        }

        private float getYaw() {
            return this.rot.y;
        }

        private void setRotation(float pitch, float yaw) {
            this.rot.set(class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f), class_3532.method_15393((float)yaw));
        }

        private void newSchematic(LitematicaSchematic schematic) {
            if (this.renderer == null) {
                this.renderer = new SchematicPreviewRenderer(this.mc);
            }
            this.renderer.setup(schematic);
            this.schematicNew = true;
        }

        private boolean isBuildingTerrainOrStart() {
            return this.renderer.isBuildingTerrain();
        }

        private boolean needsReRender() {
            return this.schematicNew || !this.pos.equals((Object)this.lastRenderPos) || !this.rot.equals((Object)this.lastRenderRot) || this.renderer.getBuiltChunksCount() != this.lastChunksBuilt;
        }

        private void render(class_276 framebuffer, float tickDelta) {
            this.schematicNew = false;
            if (this.isBuildingTerrainOrStart()) {
                return;
            }
            this.lastChunksBuilt = this.renderer.getBuiltChunksCount();
            this.lastRenderRot.set(class_3532.method_16439((float)tickDelta, (float)this.prevRot.x, (float)this.rot.x), class_3532.method_17821((float)tickDelta, (float)this.prevRot.y, (float)this.rot.y));
            this.lastRenderPos.set(class_3532.method_16439((float)tickDelta, (float)this.prevPos.x, (float)this.pos.x), class_3532.method_16439((float)tickDelta, (float)this.prevPos.y, (float)this.pos.y), class_3532.method_16439((float)tickDelta, (float)this.prevPos.z, (float)this.pos.z));
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.set((Matrix4fc)new Matrix4f().rotation((Quaternionfc)this.rotation.rotationYXZ(this.lastRenderRot.y * ((float)Math.PI / 180), this.lastRenderRot.x * ((float)Math.PI / 180), 0.0f).conjugate()));
            RenderSystem.backupProjectionMatrix();
            if (this.projectionMatrix == null) {
                this.projectionMatrix = new class_11286("SchematicPreview");
            }
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrix.method_71123(new Matrix4f().perspective((float)SchematicPreviewConfigs.PREVIEW_FOV.getDoubleValue() * ((float)Math.PI / 180), (float)framebuffer.field_1482 / (float)framebuffer.field_1481, 0.05f, 1024.0f)), (class_10366)class_10366.field_54953);
            this.cameraRenderState.field_63079 = true;
            this.cameraRenderState.field_63081 = this.rotation;
            this.cameraRenderState.field_63080 = this.cameraRenderState.field_63078 = new class_243((double)this.lastRenderPos.x, (double)this.lastRenderPos.y, (double)this.lastRenderPos.z);
            this.cameraRenderState.field_63077 = class_2338.method_49638((class_2374)this.cameraRenderState.field_63078);
            this.mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60025);
            this.renderer.prepareRender(this.cameraRenderState, framebuffer);
            this.renderer.renderBlocks();
            if (SchematicPreviewConfigs.RENDER_TILE.getBooleanValue()) {
                this.renderer.renderBlockEntities(new class_4587(), tickDelta);
            }
            RenderSystem.restoreProjectionMatrix();
            modelViewStack.popMatrix();
        }

        private void close() {
            if (this.renderer != null) {
                this.renderer.close();
                this.renderer = null;
            }
        }
    }
}

