/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.MetricTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.misc.function.Function3;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AbilityMetricTemplate
extends MetricTemplate {
    private final Function3<LivingEntity, ItemStack, String, Component> descriptionComponent;
    private final Function3<LivingEntity, ItemStack, String, MutableComponent> conditionComponent;
    private final Function3<LivingEntity, ItemStack, String, VisibilityState> visibilityState;

    private AbilityMetricTemplate(String id, Function<Double, ? extends String> formatValue, Function3<LivingEntity, ItemStack, String, Component> descriptionComponent, Function3<LivingEntity, ItemStack, String, MutableComponent> conditionComponent, Function3<LivingEntity, ItemStack, String, VisibilityState> visibilityState) {
        super(id, formatValue);
        this.descriptionComponent = descriptionComponent;
        this.conditionComponent = conditionComponent;
        this.visibilityState = visibilityState;
    }

    public static MetricTemplateBuilder builder(String id) {
        return new MetricTemplateBuilder(id);
    }

    public MetricTemplateBuilder toBuilder() {
        return new MetricTemplateBuilder(this);
    }

    @Generated
    public Function3<LivingEntity, ItemStack, String, Component> getDescriptionComponent() {
        return this.descriptionComponent;
    }

    @Generated
    public Function3<LivingEntity, ItemStack, String, MutableComponent> getConditionComponent() {
        return this.conditionComponent;
    }

    @Generated
    public Function3<LivingEntity, ItemStack, String, VisibilityState> getVisibilityState() {
        return this.visibilityState;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbilityMetricTemplate)) {
            return false;
        }
        AbilityMetricTemplate other = (AbilityMetricTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function3<LivingEntity, ItemStack, String, Component> this$descriptionComponent = this.getDescriptionComponent();
        Function3<LivingEntity, ItemStack, String, Component> other$descriptionComponent = other.getDescriptionComponent();
        if (this$descriptionComponent == null ? other$descriptionComponent != null : !this$descriptionComponent.equals(other$descriptionComponent)) {
            return false;
        }
        Function3<LivingEntity, ItemStack, String, MutableComponent> this$conditionComponent = this.getConditionComponent();
        Function3<LivingEntity, ItemStack, String, MutableComponent> other$conditionComponent = other.getConditionComponent();
        if (this$conditionComponent == null ? other$conditionComponent != null : !this$conditionComponent.equals(other$conditionComponent)) {
            return false;
        }
        Function3<LivingEntity, ItemStack, String, VisibilityState> this$visibilityState = this.getVisibilityState();
        Function3<LivingEntity, ItemStack, String, VisibilityState> other$visibilityState = other.getVisibilityState();
        return !(this$visibilityState == null ? other$visibilityState != null : !this$visibilityState.equals(other$visibilityState));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbilityMetricTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function3<LivingEntity, ItemStack, String, Component> $descriptionComponent = this.getDescriptionComponent();
        result = result * 59 + ($descriptionComponent == null ? 43 : $descriptionComponent.hashCode());
        Function3<LivingEntity, ItemStack, String, MutableComponent> $conditionComponent = this.getConditionComponent();
        result = result * 59 + ($conditionComponent == null ? 43 : $conditionComponent.hashCode());
        Function3<LivingEntity, ItemStack, String, VisibilityState> $visibilityState = this.getVisibilityState();
        result = result * 59 + ($visibilityState == null ? 43 : $visibilityState.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AbilityMetricTemplate(descriptionComponent=" + String.valueOf(this.getDescriptionComponent()) + ", conditionComponent=" + String.valueOf(this.getConditionComponent()) + ", visibilityState=" + String.valueOf(this.getVisibilityState()) + ")";
    }

    public static class MetricTemplateBuilder {
        private String id;
        private Function<Double, ? extends String> formatValue = String::valueOf;
        private Function3<LivingEntity, ItemStack, String, Component> descriptionComponent = (entity, stack, ability) -> Component.translatable((String)("relics.description." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".ability." + ability + ".statistic." + this.id));
        private Function3<LivingEntity, ItemStack, String, MutableComponent> conditionComponent = (entity, stack, ability) -> Component.empty();
        private Function3<LivingEntity, ItemStack, String, VisibilityState> visibilityState = (entity, stack, ability) -> VisibilityState.VISIBLE;

        private MetricTemplateBuilder(String id) {
            this.id = id;
        }

        private MetricTemplateBuilder(AbilityMetricTemplate base) {
            this.id = base.getId();
            this.formatValue = base.getFormatValue();
            this.descriptionComponent = base.getDescriptionComponent();
            this.conditionComponent = base.getConditionComponent();
            this.visibilityState = base.getVisibilityState();
        }

        public MetricTemplateBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MetricTemplateBuilder formatValue(Function<Double, ? extends String> formatValue) {
            this.formatValue = formatValue;
            return this;
        }

        public MetricTemplateBuilder descriptionComponent(Function3<LivingEntity, ItemStack, String, Component> descriptionComponent) {
            this.descriptionComponent = descriptionComponent;
            return this;
        }

        public MetricTemplateBuilder visibilityState(Function3<LivingEntity, ItemStack, String, VisibilityState> visibilityState) {
            Function3<LivingEntity, ItemStack, String, VisibilityState> prevState = this.visibilityState;
            this.visibilityState = (entity, stack, ability) -> {
                VisibilityState state = (VisibilityState)((Object)((Object)prevState.apply((LivingEntity)entity, (ItemStack)stack, (String)ability)));
                if (state != VisibilityState.VISIBLE) {
                    return state;
                }
                return (VisibilityState)((Object)((Object)visibilityState.apply((LivingEntity)entity, (ItemStack)stack, (String)ability)));
            };
            return this;
        }

        public MetricTemplateBuilder rankModifierVisibilityState(String rankModifier, VisibilityState state) {
            this.conditionComponent = (entity, stack, ability) -> ((IRelicItem)stack.getItem()).getAbilityTemplate((LivingEntity)entity, (ItemStack)stack, (String)ability).getRankModifiers().entries().stream().filter(entry -> ((String)entry.getValue()).equals(rankModifier)).map(Map.Entry::getKey).findFirst().map(integer -> Component.translatable((String)"relics.description.ability.statistic.condition.rank", (Object[])new Object[]{integer})).orElseGet(Component::empty);
            return this.visibilityState((entity, stack, ability) -> ((IRelicItem)stack.getItem()).isAbilityRankModifierUnlocked((LivingEntity)entity, (ItemStack)stack, (String)ability, rankModifier) ? VisibilityState.VISIBLE : state);
        }

        public MetricTemplateBuilder modeVisibilityState(String mode, VisibilityState state) {
            return this.visibilityState((entity, stack, ability) -> ((IRelicItem)stack.getItem()).getAbilityMode((LivingEntity)entity, (ItemStack)stack, (String)ability).equals(mode) ? state : VisibilityState.VISIBLE);
        }

        public AbilityMetricTemplate build() {
            return new AbilityMetricTemplate(this.id, this.formatValue, this.descriptionComponent, this.conditionComponent, this.visibilityState);
        }

        @Generated
        public MetricTemplateBuilder() {
        }
    }
}

