/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.MetricTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.misc.function.Function2;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RelicMetricTemplate
extends MetricTemplate {
    private final Function2<LivingEntity, ItemStack, Component> component;
    private final Function2<LivingEntity, ItemStack, VisibilityState> visibilityState;

    private RelicMetricTemplate(String id, Function<Double, ? extends String> formatValue, Function2<LivingEntity, ItemStack, Component> component, Function2<LivingEntity, ItemStack, VisibilityState> visibilityState) {
        super(id, formatValue);
        this.component = component;
        this.visibilityState = visibilityState;
    }

    public static MetricTemplateBuilder builder(String id) {
        return new MetricTemplateBuilder(id);
    }

    public MetricTemplateBuilder toBuilder() {
        return new MetricTemplateBuilder(this);
    }

    @Generated
    public Function2<LivingEntity, ItemStack, Component> getComponent() {
        return this.component;
    }

    @Generated
    public Function2<LivingEntity, ItemStack, VisibilityState> getVisibilityState() {
        return this.visibilityState;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicMetricTemplate)) {
            return false;
        }
        RelicMetricTemplate other = (RelicMetricTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function2<LivingEntity, ItemStack, Component> this$component = this.getComponent();
        Function2<LivingEntity, ItemStack, Component> other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        Function2<LivingEntity, ItemStack, VisibilityState> this$visibilityState = this.getVisibilityState();
        Function2<LivingEntity, ItemStack, VisibilityState> other$visibilityState = other.getVisibilityState();
        return !(this$visibilityState == null ? other$visibilityState != null : !this$visibilityState.equals(other$visibilityState));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelicMetricTemplate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function2<LivingEntity, ItemStack, Component> $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        Function2<LivingEntity, ItemStack, VisibilityState> $visibilityState = this.getVisibilityState();
        result = result * 59 + ($visibilityState == null ? 43 : $visibilityState.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RelicMetricTemplate(component=" + String.valueOf(this.getComponent()) + ", visibilityState=" + String.valueOf(this.getVisibilityState()) + ")";
    }

    public static class MetricTemplateBuilder {
        private String id;
        private Function<Double, ? extends String> formatValue = String::valueOf;
        private Function2<LivingEntity, ItemStack, Component> component = (entity, stack) -> Component.translatable((String)("relics.description." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".statistic." + this.id));
        private Function2<LivingEntity, ItemStack, VisibilityState> visibilityState = (entity, stack) -> VisibilityState.VISIBLE;

        private MetricTemplateBuilder(String id) {
            this.id = id;
        }

        private MetricTemplateBuilder(RelicMetricTemplate base) {
            this.id = base.getId();
            this.formatValue = base.getFormatValue();
            this.component = base.getComponent();
            this.visibilityState = base.getVisibilityState();
        }

        public MetricTemplateBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MetricTemplateBuilder formatValue(Function<Double, ? extends String> formatValue) {
            this.formatValue = formatValue;
            return this;
        }

        public MetricTemplateBuilder component(Function2<LivingEntity, ItemStack, Component> component) {
            this.component = component;
            return this;
        }

        public MetricTemplateBuilder visibilityState(Function2<LivingEntity, ItemStack, VisibilityState> visibilityState) {
            this.visibilityState = visibilityState;
            return this;
        }

        public RelicMetricTemplate build() {
            return new RelicMetricTemplate(this.id, this.formatValue, this.component, this.visibilityState);
        }

        @Generated
        public MetricTemplateBuilder() {
        }
    }
}

