/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics.abilities;

import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.config.data.AbilitiesConfigData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AbilitiesTemplate {
    private final Map<String, AbilityTemplate> abilities;
    private final Map<String, AbilityTemplate> synergies;

    public static AbilitiesTemplateBuilder builder() {
        return new AbilitiesTemplateBuilder();
    }

    public AbilitiesTemplateBuilder toBuilder() {
        return new AbilitiesTemplateBuilder(this);
    }

    public AbilitiesConfigData toConfigData() {
        return new AbilitiesConfigData(this.abilities.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AbilityTemplate)e.getValue()).toConfigData(), (o1, o2) -> o1, LinkedHashMap::new)));
    }

    @Generated
    public Map<String, AbilityTemplate> getAbilities() {
        return this.abilities;
    }

    @Generated
    public Map<String, AbilityTemplate> getSynergies() {
        return this.synergies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbilitiesTemplate)) {
            return false;
        }
        AbilitiesTemplate other = (AbilitiesTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, AbilityTemplate> this$abilities = this.getAbilities();
        Map<String, AbilityTemplate> other$abilities = other.getAbilities();
        if (this$abilities == null ? other$abilities != null : !((Object)this$abilities).equals(other$abilities)) {
            return false;
        }
        Map<String, AbilityTemplate> this$synergies = this.getSynergies();
        Map<String, AbilityTemplate> other$synergies = other.getSynergies();
        return !(this$synergies == null ? other$synergies != null : !((Object)this$synergies).equals(other$synergies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbilitiesTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, AbilityTemplate> $abilities = this.getAbilities();
        result = result * 59 + ($abilities == null ? 43 : ((Object)$abilities).hashCode());
        Map<String, AbilityTemplate> $synergies = this.getSynergies();
        result = result * 59 + ($synergies == null ? 43 : ((Object)$synergies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbilitiesTemplate(abilities=" + String.valueOf(this.getAbilities()) + ", synergies=" + String.valueOf(this.getSynergies()) + ")";
    }

    @Generated
    private AbilitiesTemplate(Map<String, AbilityTemplate> abilities, Map<String, AbilityTemplate> synergies) {
        this.abilities = abilities;
        this.synergies = synergies;
    }

    public static class AbilitiesTemplateBuilder {
        private Map<String, AbilityTemplate> abilities = new LinkedHashMap<String, AbilityTemplate>();
        private Map<String, AbilityTemplate> synergies = new LinkedHashMap<String, AbilityTemplate>();

        private AbilitiesTemplateBuilder(AbilitiesTemplate base) {
            this.abilities = new LinkedHashMap<String, AbilityTemplate>(base.getAbilities());
        }

        public AbilitiesTemplateBuilder abilities(Map<String, AbilityTemplate> abilities) {
            this.abilities = abilities;
            return this;
        }

        public AbilitiesTemplateBuilder ability(AbilityTemplate ability) {
            this.abilities.put(ability.getId(), ability);
            return this;
        }

        public AbilitiesTemplateBuilder synergies(Map<String, AbilityTemplate> synergies) {
            this.synergies = synergies;
            return this;
        }

        public AbilitiesTemplateBuilder synergy(AbilityTemplate synergy) {
            this.synergies.put(synergy.getId(), synergy);
            return this;
        }

        public AbilitiesTemplate build() {
            return new AbilitiesTemplate(this.abilities, this.synergies);
        }

        @Generated
        public AbilitiesTemplateBuilder() {
        }
    }
}

