/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics.abilities;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.config.data.AbilityConfigData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AbilityTemplate {
    private final String id;
    private final Function3<Player, ItemStack, String, String> icon;
    private final Map<String, StatTemplate> stats;
    private final int initialMaxLevel;
    private final double maxLevelRankModifier;
    private final int requiredLevel;
    private final int requiredPoints;
    private final CastData castData;
    private final ResearchTemplate researchTemplate;
    private final AbilityStatisticTemplate statistic;
    private final List<String> modes;
    private final ExperienceSourcesTemplate experienceSources;
    private final Multimap<Integer, String> rankModifiers;

    public static AbilityTemplateBuilder builder(String id) {
        return new AbilityTemplateBuilder(id);
    }

    public AbilityTemplateBuilder toBuilder() {
        return new AbilityTemplateBuilder(this);
    }

    public AbilityConfigData toConfigData() {
        return new AbilityConfigData(this.requiredPoints, this.requiredLevel, this.initialMaxLevel, this.stats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatTemplate)e.getValue()).toConfigData(), (o1, o2) -> o1, LinkedHashMap::new)));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Function3<Player, ItemStack, String, String> getIcon() {
        return this.icon;
    }

    @Generated
    public Map<String, StatTemplate> getStats() {
        return this.stats;
    }

    @Generated
    public int getInitialMaxLevel() {
        return this.initialMaxLevel;
    }

    @Generated
    public double getMaxLevelRankModifier() {
        return this.maxLevelRankModifier;
    }

    @Generated
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Generated
    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    @Generated
    public CastData getCastData() {
        return this.castData;
    }

    @Generated
    public ResearchTemplate getResearchTemplate() {
        return this.researchTemplate;
    }

    @Generated
    public AbilityStatisticTemplate getStatistic() {
        return this.statistic;
    }

    @Generated
    public List<String> getModes() {
        return this.modes;
    }

    @Generated
    public ExperienceSourcesTemplate getExperienceSources() {
        return this.experienceSources;
    }

    @Generated
    public Multimap<Integer, String> getRankModifiers() {
        return this.rankModifiers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbilityTemplate)) {
            return false;
        }
        AbilityTemplate other = (AbilityTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialMaxLevel() != other.getInitialMaxLevel()) {
            return false;
        }
        if (Double.compare(this.getMaxLevelRankModifier(), other.getMaxLevelRankModifier()) != 0) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (this.getRequiredPoints() != other.getRequiredPoints()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Function3<Player, ItemStack, String, String> this$icon = this.getIcon();
        Function3<Player, ItemStack, String, String> other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Map<String, StatTemplate> this$stats = this.getStats();
        Map<String, StatTemplate> other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        CastData this$castData = this.getCastData();
        CastData other$castData = other.getCastData();
        if (this$castData == null ? other$castData != null : !((Object)this$castData).equals(other$castData)) {
            return false;
        }
        ResearchTemplate this$researchTemplate = this.getResearchTemplate();
        ResearchTemplate other$researchTemplate = other.getResearchTemplate();
        if (this$researchTemplate == null ? other$researchTemplate != null : !((Object)this$researchTemplate).equals(other$researchTemplate)) {
            return false;
        }
        AbilityStatisticTemplate this$statistic = this.getStatistic();
        AbilityStatisticTemplate other$statistic = other.getStatistic();
        if (this$statistic == null ? other$statistic != null : !((Object)this$statistic).equals(other$statistic)) {
            return false;
        }
        List<String> this$modes = this.getModes();
        List<String> other$modes = other.getModes();
        if (this$modes == null ? other$modes != null : !((Object)this$modes).equals(other$modes)) {
            return false;
        }
        ExperienceSourcesTemplate this$experienceSources = this.getExperienceSources();
        ExperienceSourcesTemplate other$experienceSources = other.getExperienceSources();
        if (this$experienceSources == null ? other$experienceSources != null : !((Object)this$experienceSources).equals(other$experienceSources)) {
            return false;
        }
        Multimap<Integer, String> this$rankModifiers = this.getRankModifiers();
        Multimap<Integer, String> other$rankModifiers = other.getRankModifiers();
        return !(this$rankModifiers == null ? other$rankModifiers != null : !this$rankModifiers.equals(other$rankModifiers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbilityTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialMaxLevel();
        long $maxLevelRankModifier = Double.doubleToLongBits(this.getMaxLevelRankModifier());
        result = result * 59 + (int)($maxLevelRankModifier >>> 32 ^ $maxLevelRankModifier);
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + this.getRequiredPoints();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Function3<Player, ItemStack, String, String> $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Map<String, StatTemplate> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        CastData $castData = this.getCastData();
        result = result * 59 + ($castData == null ? 43 : ((Object)$castData).hashCode());
        ResearchTemplate $researchTemplate = this.getResearchTemplate();
        result = result * 59 + ($researchTemplate == null ? 43 : ((Object)$researchTemplate).hashCode());
        AbilityStatisticTemplate $statistic = this.getStatistic();
        result = result * 59 + ($statistic == null ? 43 : ((Object)$statistic).hashCode());
        List<String> $modes = this.getModes();
        result = result * 59 + ($modes == null ? 43 : ((Object)$modes).hashCode());
        ExperienceSourcesTemplate $experienceSources = this.getExperienceSources();
        result = result * 59 + ($experienceSources == null ? 43 : ((Object)$experienceSources).hashCode());
        Multimap<Integer, String> $rankModifiers = this.getRankModifiers();
        result = result * 59 + ($rankModifiers == null ? 43 : $rankModifiers.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbilityTemplate(id=" + this.getId() + ", icon=" + String.valueOf(this.getIcon()) + ", stats=" + String.valueOf(this.getStats()) + ", initialMaxLevel=" + this.getInitialMaxLevel() + ", maxLevelRankModifier=" + this.getMaxLevelRankModifier() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredPoints=" + this.getRequiredPoints() + ", castData=" + String.valueOf(this.getCastData()) + ", researchTemplate=" + String.valueOf(this.getResearchTemplate()) + ", statistic=" + String.valueOf(this.getStatistic()) + ", modes=" + String.valueOf(this.getModes()) + ", experienceSources=" + String.valueOf(this.getExperienceSources()) + ", rankModifiers=" + String.valueOf(this.getRankModifiers()) + ")";
    }

    @Generated
    private AbilityTemplate(String id, Function3<Player, ItemStack, String, String> icon, Map<String, StatTemplate> stats, int initialMaxLevel, double maxLevelRankModifier, int requiredLevel, int requiredPoints, CastData castData, ResearchTemplate researchTemplate, AbilityStatisticTemplate statistic, List<String> modes, ExperienceSourcesTemplate experienceSources, Multimap<Integer, String> rankModifiers) {
        this.id = id;
        this.icon = icon;
        this.stats = stats;
        this.initialMaxLevel = initialMaxLevel;
        this.maxLevelRankModifier = maxLevelRankModifier;
        this.requiredLevel = requiredLevel;
        this.requiredPoints = requiredPoints;
        this.castData = castData;
        this.researchTemplate = researchTemplate;
        this.statistic = statistic;
        this.modes = modes;
        this.experienceSources = experienceSources;
        this.rankModifiers = rankModifiers;
    }

    public static class AbilityTemplateBuilder {
        private final String id;
        private Function3<Player, ItemStack, String, String> icon = (player, stack, ability) -> {
            IRelicItem relic = (IRelicItem)stack.getItem();
            List<String> modes = relic.getAbilityTemplate((LivingEntity)player, (ItemStack)stack, (String)ability).getModes();
            return ability + (String)(modes.isEmpty() ? "" : "_" + relic.getAbilityMode((LivingEntity)player, (ItemStack)stack, (String)ability));
        };
        private Map<String, StatTemplate> stats = new LinkedHashMap<String, StatTemplate>();
        private int initialMaxLevel = 10;
        private double maxLevelRankModifier = 0.25;
        private int requiredLevel = 0;
        private int requiredPoints = 1;
        private CastData castData = CastData.builder().build();
        private ResearchTemplate researchTemplate = ResearchTemplate.builder().build();
        private AbilityStatisticTemplate statistic = AbilityStatisticTemplate.builder().build();
        private List<String> modes = new ArrayList<String>();
        private ExperienceSourcesTemplate experienceSources = ExperienceSourcesTemplate.builder().build();
        private Multimap<Integer, String> rankModifiers = LinkedHashMultimap.create();

        public AbilityTemplateBuilder(String id) {
            this.id = id;
        }

        private AbilityTemplateBuilder(AbilityTemplate base) {
            this.id = base.getId();
            this.icon = base.getIcon();
            this.stats = new LinkedHashMap<String, StatTemplate>(base.getStats());
            this.initialMaxLevel = base.getInitialMaxLevel();
            this.maxLevelRankModifier = base.getMaxLevelRankModifier();
            this.requiredLevel = base.getRequiredLevel();
            this.requiredPoints = base.getRequiredPoints();
            this.castData = base.getCastData();
            this.researchTemplate = base.getResearchTemplate();
            this.statistic = base.getStatistic();
            this.experienceSources = base.getExperienceSources();
            this.modes = base.getModes();
            this.rankModifiers = base.getRankModifiers();
        }

        public AbilityTemplateBuilder icon(Function3<Player, ItemStack, String, String> icon) {
            this.icon = icon;
            return this;
        }

        public AbilityTemplateBuilder stats(Map<String, StatTemplate> stats) {
            this.stats = stats;
            return this;
        }

        public AbilityTemplateBuilder stat(StatTemplate stat) {
            this.stats.put(stat.getId(), stat);
            return this;
        }

        public AbilityTemplateBuilder initialMaxLevel(int maxLevel) {
            this.initialMaxLevel = maxLevel;
            return this;
        }

        public AbilityTemplateBuilder maxLevelRankModifier(double maxLevelRankModifier) {
            this.maxLevelRankModifier = maxLevelRankModifier;
            return this;
        }

        public AbilityTemplateBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel = requiredLevel;
            return this;
        }

        public AbilityTemplateBuilder requiredPoints(int requiredPoints) {
            this.requiredPoints = requiredPoints;
            return this;
        }

        public AbilityTemplateBuilder castData(CastData castData) {
            this.castData = castData;
            return this;
        }

        public AbilityTemplateBuilder research(ResearchTemplate researchTemplate) {
            this.researchTemplate = researchTemplate;
            return this;
        }

        public AbilityTemplateBuilder statistic(AbilityStatisticTemplate statistic) {
            this.statistic = statistic;
            return this;
        }

        public AbilityTemplateBuilder modes(String ... mode) {
            this.modes.addAll(Lists.newArrayList((Object[])mode));
            return this;
        }

        public AbilityTemplateBuilder experienceSources(ExperienceSourcesTemplate sources) {
            this.experienceSources = sources;
            return this;
        }

        public AbilityTemplateBuilder rankModifier(int rank, String modifier) {
            this.rankModifiers.put((Object)rank, (Object)modifier);
            return this;
        }

        public AbilityTemplate build() {
            return new AbilityTemplate(this.id, this.icon, this.stats, this.initialMaxLevel, this.maxLevelRankModifier, this.requiredLevel, this.requiredPoints, this.castData, this.researchTemplate, this.statistic, this.modes, this.experienceSources, this.rankModifiers);
        }
    }
}

