/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.gui.layers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import it.hurts.sskirillss.relics.utils.data.SpriteMirror;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;

public class StunEffectLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation VIGNETTE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/layer/stun_effect/vignette.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft MC = Minecraft.getInstance();
        LocalPlayer player = MC.player;
        if (player == null) {
            return;
        }
        MobEffectInstance effect = player.getEffect(RelicsMobEffects.STUN);
        if (effect == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Window window = MC.getWindow();
        int width = window.getGuiScaledWidth();
        int height = 128;
        float alpha = Math.min((float)effect.getDuration() * 0.01f, 1.0f);
        RenderSystem.enableBlend();
        GUIRenderer.begin(VIGNETTE, poseStack).anchor(SpriteAnchor.TOP_LEFT).patternSize(width, height).texSize(1, height).alpha(alpha).end();
        GUIRenderer.begin(VIGNETTE, poseStack).pos(0.0f, window.getGuiScaledHeight() - height).anchor(SpriteAnchor.TOP_LEFT).patternSize(width, height).texSize(1, height).mirror(SpriteMirror.VERTICAL).alpha(alpha).end();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

