/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.layer.RelicLayer;
import it.hurts.sskirillss.relics.client.renderer.items.base.IRelicRenderer;
import it.hurts.sskirillss.relics.init.RelicsRelicRenderers;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public abstract class EquippableRelicLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RelicLayer<T, M> {
    private final String slot;

    public EquippableRelicLayer(RenderLayerParent<T, M> renderer, String slot) {
        super(renderer);
        this.slot = slot;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> {
            for (SlotResult slot : handler.findCurios(new String[]{this.slot})) {
                ItemStack slotStack;
                Optional<IRelicRenderer> renderer;
                if (!slot.slotContext().visible() || !(renderer = RelicsRelicRenderers.getRenderer((slotStack = slot.stack()).getItem())).isPresent()) continue;
                renderer.get().render(slotStack, slot.slotContext(), poseStack, this.renderLayerParent, buffer, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                break;
            }
        });
    }
}

