/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.models.items;

import com.google.common.collect.ImmutableList;
import it.hurts.sskirillss.relics.client.renderer.items.base.INecklaceModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class JellyfishNecklaceModel
extends HumanoidModel<LivingEntity>
implements INecklaceModel<LivingEntity> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"jellyfish_necklace"), "jellyfish_necklace");
    public ModelPart bodyPart;

    public JellyfishNecklaceModel(ModelPart root) {
        super(root);
        this.bodyPart = root.getChild("body");
    }

    public static LayerDefinition constructLayerDefinition() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-0.0643f, (float)15.9463f, (float)-0.475f));
        PartDefinition amulet = body.addOrReplaceChild("pendant", CubeListBuilder.create().texOffs(15, 30).addBox(-2.0f, -1.0f, -1.85f, 4.0f, 4.0f, 3.0f, new CubeDeformation(-1.0f)).texOffs(31, 34).addBox(-1.5f, 1.35f, -1.35f, 3.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.offset((float)0.0643f, (float)-13.9463f, (float)-2.675f));
        PartDefinition cube_r1 = amulet.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(2, 31).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.4f, (float)-1.1f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r2 = amulet.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(17, 23).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)0.1f, (float)2.4f, (float)-1.6f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-5.9357f, -13.4463f, -4.525f, 12.0f, 10.0f, 9.0f, new CubeDeformation(-2.0f)), PartPose.offset((float)0.0f, (float)-4.75f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.bodyPart);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of();
    }

    @Override
    public ModelPart getBodyPart() {
        return this.bodyPart;
    }
}

