/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.ReflectiveOrbModel;
import it.hurts.sskirillss.relics.entities.ReflectiveOrbEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReflectiveOrbRenderer
extends EntityRenderer<ReflectiveOrbEntity> {
    public ReflectiveOrbRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(ReflectiveOrbEntity orb, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        float time = (float)orb.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        Vec3 velocity = orb.getDeltaMovement();
        float speed = (float)velocity.length();
        float spinSpeed = 7.0f / (speed + 1.0f);
        float spinAngle = time * spinSpeed;
        float zStretch = 1.0f + speed * 1.5f;
        float invNorm = 1.0f / (speed + 1.0f);
        float jellyAmp = 0.15f * invNorm;
        float jellyX = 1.0f + (float)Math.sin(time) * jellyAmp;
        float jellyY = 1.0f + (float)Math.cos(time) * jellyAmp;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.2, 0.0);
        double dx = velocity.x;
        double dy = velocity.y;
        double dz = velocity.z;
        float yawAngle = (float)Math.toDegrees(Math.atan2(dx, dz));
        float pitchAngle = (float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
        poseStack.mulPose(Axis.YP.rotationDegrees(yawAngle));
        poseStack.mulPose(Axis.XP.rotationDegrees(-pitchAngle));
        poseStack.scale(1.0f, 1.0f, zStretch);
        poseStack.scale(jellyX, jellyY, 1.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(spinAngle));
        poseStack.mulPose(Axis.YN.rotationDegrees(spinAngle));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitchAngle));
        poseStack.mulPose(Axis.YP.rotationDegrees(-yawAngle));
        poseStack.translate(0.0, -0.125, 0.0);
        float modelScale = 0.8f;
        poseStack.scale(modelScale, modelScale, modelScale);
        poseStack.translate(0.0, -1.125, 0.0);
        new ReflectiveOrbModel().renderToBuffer(poseStack, buffers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(orb))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(ReflectiveOrbEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/entities/reflective_orb" + (entity.isFlawless() ? "_flawless" : "") + ".png"));
    }
}

