/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.items.MidnightMantleFullMoonModel;
import it.hurts.sskirillss.relics.client.models.items.MidnightMantleModel;
import it.hurts.sskirillss.relics.client.models.items.MidnightMantleNewMoonModel;
import it.hurts.sskirillss.relics.client.renderer.items.base.IRelicRenderer;
import it.hurts.sskirillss.relics.items.relics.back.MidnightMantleItem;
import it.hurts.sskirillss.relics.utils.FlawlessUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class MidnightMantleRenderer
implements IRelicRenderer {
    private final MidnightMantleModel model = new MidnightMantleModel(Minecraft.getInstance().getEntityModels().bakeLayer(MidnightMantleModel.LAYER));

    public <E extends LivingEntity, EM extends EntityModel<E>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<E, EM> parent, MultiBufferSource bufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MidnightMantleItem relic = (MidnightMantleItem)stack.getItem();
        float time = (float)entity.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        poseStack.pushPose();
        this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{this.model});
        String mode = relic.getAbilityMode(entity, stack, "phase");
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/item/model/midnight_mantle_" + (relic.isRelicFlawless(entity, stack) ? "flawless" : mode) + ".png")))), relic.isRelicFlawless(entity, stack) ? 0xF000F0 : light, OverlayTexture.NO_OVERLAY);
        float flicker = 0.75f + 0.25f * Mth.sin((float)(time * 0.15f));
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)FlawlessUtils.getTexture(entity, stack, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/item/model/midnight_mantle_stars_" + mode + ".png"))))), relic.isRelicFlawless(entity, stack) ? 0xF000F0 : LightTexture.pack((int)((int)(15.0f * flicker)), (int)((int)(15.0f * flicker))), OverlayTexture.NO_OVERLAY);
        if (relic.canPlayerUseAbility(entity, stack, "phase")) {
            float deltaX = (float)(Mth.lerp((double)partialTicks, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()));
            float deltaY = (float)(Mth.lerp((double)partialTicks, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()));
            float deltaZ = (float)(Mth.lerp((double)partialTicks, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            float amplitude = 0.35f;
            float bodyYaw = Mth.rotLerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            float sin = (float)Math.sin(bodyYaw);
            float cos = (float)Math.cos(bodyYaw);
            float forward = -deltaX * sin + deltaZ * cos;
            float side = deltaX * cos + deltaZ * sin;
            float dx = -side * amplitude;
            float dy = -deltaY * amplitude;
            float dz = -forward * amplitude;
            float levAmp = 0.1f;
            float levSpeed = 0.1f;
            float levOffset = Mth.sin((float)(time * levSpeed)) * levAmp;
            float tiltDeg = 5.0f;
            float tiltAmp = tiltDeg * ((float)Math.PI / 180);
            float tiltSpeed = 0.1f;
            float tiltX = Mth.sin((float)(time * tiltSpeed)) * tiltAmp;
            float tiltZ = Mth.cos((float)(time * tiltSpeed)) * tiltAmp;
            poseStack.pushPose();
            poseStack.translate(dx, dy + levOffset, dz);
            poseStack.mulPose(Axis.XP.rotation(tiltX));
            poseStack.mulPose(Axis.ZP.rotation(tiltZ));
            if (mode.equals("new_moon")) {
                new MidnightMantleNewMoonModel().renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)FlawlessUtils.getTexture((LivingEntity)player, stack, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/midnight_mantle_moon_new_moon.png")))), 0xF000F0, OverlayTexture.NO_OVERLAY);
            } else if (mode.equals("full_moon")) {
                new MidnightMantleFullMoonModel().renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)FlawlessUtils.getTexture((LivingEntity)player, stack, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/item/model/midnight_mantle_moon_full_moon.png")))), 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

