/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.ExtendedUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategory;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.AbilityModeWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base.AbstractAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.research.AbilityResearchScreen;
import it.hurts.sskirillss.relics.client.screen.particle.PixelUIParticle;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.description.ability.C2SPacketAbilityUnlock;
import it.hurts.sskirillss.relics.utils.ClientScheduler;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2f;

public class AbilityCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final AbilityDescriptionScreen screen;
    private final String ability;
    private float clickXSqueeze = 1.0f;
    private float clickYSqueeze = 1.0f;
    private float clickZRotation = 0.0f;
    public Tween hoverTween;
    private boolean hasHovered = false;
    private float hoverXSqueeze = 1.0f;
    private float hoverYSqueeze = 1.0f;

    public AbilityCardWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, 38, 51);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void onPress() {
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.screen.getStack();
        RandomSource random = player.getRandom();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        boolean isEnoughLevel = relic.isEnoughLevel((LivingEntity)player, stack, this.ability);
        boolean isLockUnlocked = relic.isLockUnlocked((LivingEntity)player, stack, this.ability);
        boolean isAbilityResearched = relic.isAbilityResearched((LivingEntity)player, stack, this.ability);
        SoundManager soundManager = this.minecraft.getSoundManager();
        if (isEnoughLevel) {
            if (isLockUnlocked) {
                if (isAbilityResearched) {
                    if (!this.screen.getSelectedAbility().equals(this.ability)) {
                        this.screen.setSelectedAbility(this.ability);
                        List<DescriptionSubcategory> subcategories = DescriptionSubcategories.getSubcategories().values().stream().filter(subcategory -> subcategory.shouldAppear(this.screen, (LivingEntity)player, stack)).toList();
                        if (!subcategories.contains(this.screen.getSubcategory())) {
                            this.screen.setSubcategory(DescriptionSubcategories.getSubcategory("ability_description"));
                        }
                        this.screen.rebuildWidgets();
                        for (Renderable entry : this.screen.renderables) {
                            if (!(entry instanceof AbilityCardWidget)) continue;
                            AbilityCardWidget card = (AbilityCardWidget)entry;
                            if (card.ability.equals(this.ability)) continue;
                        }
                    }
                } else {
                    this.minecraft.setScreen((Screen)new AbilityResearchScreen((Player)this.minecraft.player, this.screen.container, this.screen.slot, this.screen, this.ability));
                }
            } else {
                float size;
                PixelUIParticle particle;
                Vec2 margin;
                int i;
                int unlocks = relic.getLockUnlocks((LivingEntity)player, stack, this.ability) + 1;
                NetworkHandler.sendToServer(new C2SPacketAbilityUnlock(this.screen.container, this.screen.slot, this.ability, unlocks));
                float overshootFactor = 0.035f * (float)unlocks;
                float overshoot = 1.0f + overshootFactor;
                Tween tween = Tween.create().setParallel(true);
                tween.tweenMethod(this::setClickYSqueeze, (Object)Float.valueOf(this.getClickYSqueeze()), (Object)Float.valueOf(overshoot), 0.08).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
                tween.tweenMethod(this::setClickXSqueeze, (Object)Float.valueOf(this.getClickXSqueeze()), (Object)Float.valueOf(overshoot), 0.08).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
                tween.tweenMethod(this::setClickYSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.12).setDelay(0.04).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
                tween.tweenMethod(this::setClickXSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.12).setDelay(0.04).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
                float initialRotation = this.getClickZRotation();
                float rotationBase = 0.025f * (float)unlocks;
                float amplitude = random.nextBoolean() ? rotationBase : -rotationBase;
                float decay = 0.75f;
                double segmentDuration = 0.2;
                double delay = 0.0;
                float lastTarget = initialRotation;
                for (i = 0; i < 10; ++i) {
                    float nextTarget = i % 2 == 0 ? amplitude : -amplitude;
                    tween.tweenMethod(this::setClickZRotation, (Object)Float.valueOf(lastTarget), (Object)Float.valueOf(nextTarget), segmentDuration).setDelay(delay).setEaseType(i == 0 ? EaseType.EASE_OUT : EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
                    lastTarget = nextTarget;
                    delay += segmentDuration;
                    amplitude *= decay;
                }
                tween.tweenMethod(this::setClickZRotation, (Object)Float.valueOf(lastTarget), (Object)Float.valueOf(0.0f), segmentDuration).setDelay(delay).setEaseType(EaseType.EASE_IN);
                tween.start();
                for (i = 0; i < unlocks * 75; ++i) {
                    Vec2 center = new Vec2((float)this.width / 2.0f, (float)this.height / 2.0f);
                    margin = new Vec2(center.x + MathUtils.randomFloat(random) * 7.0f, center.y + MathUtils.randomFloat(random) * 8.5f);
                    particle = new PixelUIParticle(5.0f, random.nextInt(20, 40), (float)this.getX() + margin.x, (float)this.getY() + margin.y, UIParticle.Layer.SCREEN, 110.0f);
                    size = random.nextFloat() * 0.5f + 0.75f;
                    particle.setColors(new OctoColor[]{new OctoColor(1.0f, 0.5f + random.nextFloat() * 0.5f, random.nextFloat() * 0.25f, 1.0f), new OctoColor(1.0f, 0.0f, 0.0f, 1.0f)});
                    particle.setDirection(MathUtils.randomFloat(random), -random.nextFloat());
                    particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
                    particle.getTransform().setSize(new Vector2f(size, size));
                    particle.setGravity(0.5f + random.nextFloat() * 0.5f);
                    particle.setSpeed(1.5f + random.nextFloat() * 1.5f);
                    particle.setGravityDirection(0.0f, 1.0f);
                    particle.setScreen(this.screen);
                    particle.instantiate();
                }
                soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, (float)1.0f));
                if (unlocks >= relic.getMaxLockUnlocks()) {
                    ClientScheduler.schedule(1, this::rebuildActionButtons);
                    for (i = 0; i < 25; ++i) {
                        Vec2 center = new Vec2((float)this.width / 2.0f, (float)this.height / 2.0f);
                        margin = new Vec2(center.x + MathUtils.randomFloat(random) * 7.0f, center.y + MathUtils.randomFloat(random) * 8.5f);
                        particle = new ExtendedUIParticle(new UIParticle.Texture2D(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/relic/particle/chain.png"), 0, 0, 6, 6, 6, 6), 5.0f, random.nextInt(40, 60), (float)this.getX() + margin.x, (float)this.getY() + margin.y, UIParticle.Layer.SCREEN, 110.0f);
                        size = random.nextFloat() * 0.5f + 0.75f;
                        particle.setDirection(MathUtils.randomFloat(random) * 0.25f, -random.nextFloat());
                        particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
                        particle.getTransform().setSize(new Vector2f(size, size));
                        particle.setGravityDirection(0.0f, 1.0f);
                        particle.enableBlend(false);
                        particle.setScreen(this.screen);
                        particle.setGravity(1.0f);
                        particle.setSpeed(3.5f);
                        particle.instantiate();
                    }
                    soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WITHER_BREAK_BLOCK, (float)1.0f));
                    soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.GENERIC_EXPLODE, (float)1.0f));
                }
            }
        } else {
            float overshootFactor = 0.035f;
            float overshoot = 1.0f + overshootFactor;
            Tween tween = Tween.create().setParallel(true);
            tween.tweenMethod(this::setClickYSqueeze, (Object)Float.valueOf(this.getClickYSqueeze()), (Object)Float.valueOf(overshoot), 0.08).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setClickXSqueeze, (Object)Float.valueOf(this.getClickXSqueeze()), (Object)Float.valueOf(overshoot), 0.08).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setClickYSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.12).setDelay(0.04).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setClickXSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.12).setDelay(0.04).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            float initialRotation = this.getClickZRotation();
            float rotationBase = 0.025f;
            float amplitude = random.nextBoolean() ? rotationBase : -rotationBase;
            float decay = 0.75f;
            double segmentDuration = 0.25;
            double delay = 0.0;
            float lastTarget = initialRotation;
            for (int i = 0; i < 10; ++i) {
                float nextTarget = i % 2 == 0 ? amplitude : -amplitude;
                tween.tweenMethod(this::setClickZRotation, (Object)Float.valueOf(lastTarget), (Object)Float.valueOf(nextTarget), segmentDuration).setDelay(delay).setEaseType(i == 0 ? EaseType.EASE_OUT : EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
                lastTarget = nextTarget;
                delay += segmentDuration;
                amplitude *= decay;
            }
            tween.tweenMethod(this::setClickZRotation, (Object)Float.valueOf(lastTarget), (Object)Float.valueOf(0.0f), segmentDuration).setDelay(delay).setEaseType(EaseType.EASE_IN);
            tween.start();
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_BREAK, (float)1.0f));
        }
    }

    public void rebuildActionButtons() {
        this.screen.children().removeIf(entry -> entry instanceof AbstractAbilityActionWidget);
        this.screen.initActionButtons();
        this.screen.children().removeIf(entry -> entry instanceof AbilityModeWidget);
        this.screen.initModeButtons();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item item;
        LocalPlayer player = this.minecraft.player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        ItemStack stack = this.screen.getStack();
        TextureManager manager = this.minecraft.getTextureManager();
        PoseStack poseStack = guiGraphics.pose();
        int unlocks = relic.getLockUnlocks((LivingEntity)player, stack, this.ability);
        boolean isEnoughLevel = relic.isEnoughLevel((LivingEntity)player, stack, this.ability);
        boolean isLockUnlocked = isEnoughLevel && relic.isLockUnlocked((LivingEntity)player, stack, this.ability);
        boolean isAbilityResearched = relic.isAbilityResearched((LivingEntity)player, stack, this.ability);
        boolean canUse = isEnoughLevel && isLockUnlocked && isAbilityResearched;
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)player, stack, this.ability);
        boolean canResearch = relic.mayResearch((LivingEntity)player, stack, this.ability);
        boolean canBeUpgraded = relic.canBeUpgraded((LivingEntity)player, stack, this.ability);
        boolean hasAction = canUpgrade || canResearch;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        poseStack.pushPose();
        poseStack.translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f, 0.0f);
        poseStack.scale(this.getHoverXSqueeze(), this.getHoverYSqueeze(), 1.0f);
        poseStack.scale(this.getClickXSqueeze(), this.getClickYSqueeze(), 1.0f);
        poseStack.mulPose(Axis.ZP.rotation(this.getClickZRotation()));
        float color = (float)((double)(canUpgrade ? 0.75f : 1.05f) + Math.sin((float)(player.tickCount + this.ability.length() * 10) * 0.2f) * (double)0.1f);
        if (isLockUnlocked) {
            GUIRenderer.begin(DescriptionTextures.getAbilityCardTexture(stack, this.ability), poseStack).color(color, color, color, 1.0f).texSize(22, 31).pos(0.0f, -2.0f).end();
        }
        if (!canUse) {
            GUIRenderer.begin(isLockUnlocked ? DescriptionTextures.SMALL_CARD_RESEARCH_BACKGROUND : DescriptionTextures.SMALL_CARD_LOCK_BACKGROUND, poseStack).pos(0.0f, -2.0f).end();
        }
        GUIRenderer.begin(canBeUpgraded ? (canUse ? DescriptionTextures.SMALL_CARD_FRAME_UNLOCKED_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_UNLOCKED_INACTIVE) : (canUse ? DescriptionTextures.SMALL_CARD_FRAME_LOCKED_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_LOCKED_INACTIVE), poseStack).end();
        int level = relic.getAbilityLevel((LivingEntity)player, stack, this.ability);
        int maxLevel = relic.getAbilityTemplate((LivingEntity)player, stack, this.ability).getInitialMaxLevel();
        AbilityCardWidget.drawProgressBar(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/relic/small_card_filler.png"), (float)(-this.width) / 2.0f + 2.0f, (float)(-this.height) / 2.0f + 3.0f, (float)level / (float)maxLevel);
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.SMALL_CARD_FRAME_SELECTION, poseStack).end();
        }
        if (isLockUnlocked) {
            if (!isAbilityResearched) {
                float time = (float)this.minecraft.player.tickCount + (float)this.ability.length() * 10.0f + partialTick;
                GUIRenderer.begin(DescriptionTextures.RESEARCH, poseStack).pos((float)Math.sin(time * 0.25f), (float)Math.cos(time * 0.25f) + 0.5f - 2.0f).patternSize(16, 16).animation(AnimationData.construct(160, 16, 2)).end();
            }
        } else {
            GUIRenderer.begin(isEnoughLevel ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/ability/chains_active_" + unlocks + ".png")) : DescriptionTextures.ABILITY_CHAINS_INACTIVE, poseStack).pos(0.0f, -1.0f).end();
            poseStack.pushPose();
            GUIRenderer.begin(isEnoughLevel ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/relic/icons/lock_active_" + unlocks + ".png")) : DescriptionTextures.LOCK_INACTIVE, poseStack).pos(0.0f, -2.0f).end();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            MutableComponent requiredLevelComponent = Component.literal((String)String.valueOf(relic.getAbilityTemplate((LivingEntity)player, stack, this.ability).getRequiredLevel())).withStyle(ChatFormatting.BOLD);
            guiGraphics.drawString(this.minecraft.font, (Component)requiredLevelComponent, (-(this.width / 2) + 19) * 2 - this.minecraft.font.width((FormattedText)requiredLevelComponent) / 2, (-(this.height / 2) + 24) * 2, isEnoughLevel ? 16769656 : 12037849, true);
            poseStack.popPose();
        }
        if (canUse && canUpgrade) {
            GUIRenderer.begin(DescriptionTextures.UPGRADE, poseStack).pos(0.0f, -1.0f).patternSize(20, 20).scale(0.9f + (float)(Math.sin(((float)player.tickCount + partialTick) * 0.25f) * (double)0.05f)).animation(AnimationData.construct(200, 20, 2)).end();
        }
        if (canBeUpgraded && canUse) {
            int xOff = 0;
            int quality = relic.calculateAbilityQuality((LivingEntity)player, stack, this.ability);
            boolean isAliquot = quality % 2 == 1;
            int i = 0;
            while ((double)i < Math.floor((double)quality / 2.0)) {
                GUIRenderer.begin(DescriptionTextures.SMALL_STAR_ACTIVE, poseStack).pos(-((float)this.width / 2.0f) + (float)xOff + 9.0f, -((float)this.height / 2.0f) + 43.0f).end();
                xOff += 5;
                ++i;
            }
            if (isAliquot) {
                GUIRenderer.begin(DescriptionTextures.SMALL_STAR_ACTIVE, poseStack).pos(-((float)this.width / 2.0f) + (float)xOff + 8.0f, -((float)this.height / 2.0f) + 43.0f).patternSize(1, 2).end();
            }
        }
        if (canBeUpgraded) {
            MutableComponent title = Component.literal((String)(canUse ? String.valueOf(relic.getAbilityLevel((LivingEntity)player, stack, this.ability)) : "?")).withStyle(ChatFormatting.BOLD);
            float textScale = 0.5f;
            poseStack.scale(textScale, textScale, textScale);
            guiGraphics.drawString(this.minecraft.font, (Component)title, -((this.width + 1) / 2) - this.minecraft.font.width((FormattedText)title) / 2 + 19, -(this.height / 2) - 20, canUse ? 16769656 : 12037849, true);
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public static void drawProgressBar(GuiGraphics gui, ResourceLocation tex, float x, float y, float progress) {
        int textureWidth = 34;
        int textureHeight = 46;
        int cornerSize = 3;
        int borderThickness = 3;
        int topStartU = 7;
        int topEndU = 27;
        int verticalEdgeLength = textureHeight - 2 * cornerSize;
        int horizontalEdgeLength = textureWidth - 2 * cornerSize;
        int segTop = topStartU - cornerSize + 1;
        int segCornerTopLeft = cornerSize;
        int segLeftEdge = verticalEdgeLength;
        int segCornerBotLeft = cornerSize;
        int segBottom = horizontalEdgeLength;
        int segCornerBotRight = cornerSize;
        int segRightEdge = verticalEdgeLength;
        int segCornerTopRight = cornerSize;
        int segTopRightPart = textureWidth - cornerSize - topEndU;
        int totalLength = segTop + segCornerTopLeft + segLeftEdge + segCornerBotLeft + segBottom + segCornerBotRight + segRightEdge + segCornerTopRight + segTopRightPart;
        int remaining = (int)(Mth.clamp((float)progress, (float)0.0f, (float)1.0f) * (float)totalLength);
        if (remaining <= 0) {
            return;
        }
        GUIRenderer renderer = GUIRenderer.begin(tex, gui.pose()).texSize(textureWidth, textureHeight).anchor(SpriteAnchor.TOP_LEFT);
        int drawLen = 0;
        int moveLen = 0;
        drawLen = Math.min(remaining, segTop);
        int u0 = topStartU - drawLen + 1;
        renderer.pos(x + (float)u0, y).patternSize(drawLen, borderThickness).texOff(u0, 0).end();
        if ((remaining -= drawLen) > 0) {
            drawLen = Math.min(remaining, segCornerTopLeft);
            int offsetU1 = cornerSize - drawLen;
            renderer.pos(x + (float)offsetU1, y).patternSize(drawLen, borderThickness).texOff(offsetU1, 0).end();
            remaining -= drawLen;
        }
        if (remaining > 0) {
            moveLen = Math.min(remaining, segLeftEdge);
            renderer.pos(x, y + (float)cornerSize).patternSize(borderThickness, moveLen).texOff(0, cornerSize).end();
            remaining -= moveLen;
        }
        if (remaining > 0) {
            drawLen = Math.min(remaining, segCornerBotLeft);
            renderer.pos(x, y + (float)textureHeight - (float)borderThickness).patternSize(drawLen, borderThickness).texOff(0, textureHeight - borderThickness).end();
            remaining -= drawLen;
        }
        if (remaining > 0) {
            drawLen = Math.min(remaining, segBottom);
            renderer.pos(x + (float)cornerSize, y + (float)textureHeight - (float)borderThickness).patternSize(drawLen, borderThickness).texOff(cornerSize, textureHeight - borderThickness).end();
            remaining -= drawLen;
        }
        if (remaining > 0) {
            drawLen = Math.min(remaining, segCornerBotRight);
            int offsetUBot = textureWidth - cornerSize;
            renderer.pos(x + (float)offsetUBot, y + (float)textureHeight - (float)borderThickness).patternSize(drawLen, borderThickness).texOff(offsetUBot, textureHeight - borderThickness).end();
            remaining -= drawLen;
        }
        if (remaining > 0) {
            moveLen = Math.min(remaining, segRightEdge);
            int v6 = cornerSize + (verticalEdgeLength - moveLen);
            renderer.pos(x + (float)textureWidth - (float)borderThickness, y + (float)v6).patternSize(borderThickness, moveLen).texOff(textureWidth - borderThickness, v6).end();
            remaining -= moveLen;
        }
        if (remaining > 0) {
            drawLen = Math.min(remaining, segCornerTopRight);
            int u7 = textureWidth - borderThickness;
            renderer.pos(x + (float)u7, y).patternSize(borderThickness, drawLen).texOff(u7, 0).end();
            remaining -= drawLen;
        }
        if (remaining > 0) {
            drawLen = Math.min(remaining, segTopRightPart);
            int startU8 = textureWidth - cornerSize - 1;
            int offsetU8 = startU8 - (drawLen - 1);
            renderer.pos(x + (float)offsetU8, y).patternSize(drawLen, borderThickness).texOff(offsetU8, 0).end();
        }
    }

    @Override
    public void onTick() {
        boolean hovered = this.isHovered();
        float overshoot = 1.075f;
        if (hovered && !this.hasHovered) {
            this.hasHovered = true;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setParallel(true);
            this.hoverTween.tweenMethod(this::setHoverYSqueeze, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(overshoot), 0.25).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            this.hoverTween.tweenMethod(this::setHoverXSqueeze, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(overshoot), 0.25).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            this.hoverTween.start();
        } else if (!hovered && this.hasHovered) {
            this.hasHovered = false;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setParallel(true);
            this.hoverTween.tweenMethod(this::setHoverYSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.25).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            this.hoverTween.tweenMethod(this::setHoverXSqueeze, (Object)Float.valueOf(overshoot), (Object)Float.valueOf(1.0f), 0.25).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            this.hoverTween.start();
        }
    }

    @Override
    public boolean isLocked() {
        return this.screen.getSelectedAbility().equals(this.ability);
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.screen.stack;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityTemplate data = relic.getAbilityTemplate((LivingEntity)player, stack, this.ability);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent title = Component.translatableWithFallback((String)("relics.description." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".ability." + this.ability), (String)this.ability);
        int maxWidth = 110;
        int renderWidth = Math.min(this.minecraft.font.width((FormattedText)title.withStyle(ChatFormatting.BOLD)) / 2 + 4, maxWidth);
        ArrayList<MutableComponent> entries = new ArrayList<MutableComponent>();
        entries.add(Component.literal((String)" "));
        int level = relic.getRelicLevel((LivingEntity)player, stack);
        int requiredLevel = data.getRequiredLevel();
        if (level < requiredLevel) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.card.low_level", (Object[])new Object[]{Component.literal((String)String.valueOf(requiredLevel)).withStyle(ChatFormatting.BOLD)})));
        } else if (!relic.isLockUnlocked((LivingEntity)player, stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.card.ready_to_unlock", (Object[])new Object[]{Component.literal((String)String.valueOf(relic.getMaxLockUnlocks() - relic.getLockUnlocks((LivingEntity)player, stack, this.ability))).withStyle(ChatFormatting.BOLD)})));
        } else if (!relic.isAbilityResearched((LivingEntity)player, stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.card.unresearched")));
        } else if (relic.mayPlayerUpgrade((Player)player, stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.card.ready_to_upgrade")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 4, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 5;
        int y = this.getHeight() / 2;
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        poseStack.translate((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, 0.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (!relic.isAbilityUnlocked((LivingEntity)player, stack, this.ability)) {
            title = ScreenUtils.stylizeWithReplacement(title, 1.0, Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(10354864), (long)this.ability.length());
            RandomSource random = player.getRandom();
            float shakeX = MathUtils.randomFloat(random) * 0.5f;
            float shakeY = MathUtils.randomFloat(random) * 0.5f;
            poseStack.translate(shakeX, shakeY, 0.0f);
        } else {
            title.withStyle(ChatFormatting.BOLD);
        }
        guiGraphics.drawString(this.minecraft.font, (Component)title, -(this.minecraft.font.width((FormattedText)title) / 2), (y + yOff + 9) * 2, 7548704, false);
        poseStack.popPose();
        for (FormattedCharSequence entry : tooltip) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.minecraft.font, entry, -(this.minecraft.font.width(entry) / 2), (y + yOff + 9) * 2, 7548704, false);
            yOff += 5;
            poseStack.popPose();
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
        IRelicItem relic;
        Item item;
        if (!this.isLocked() && (item = this.screen.getStack().getItem()) instanceof IRelicItem && (relic = (IRelicItem)item).isAbilityUnlocked((LivingEntity)this.minecraft.player, this.screen.stack, this.ability)) {
            super.playDownSound(handler);
        }
    }

    @Generated
    public String getAbility() {
        return this.ability;
    }

    @Generated
    public float getClickXSqueeze() {
        return this.clickXSqueeze;
    }

    @Generated
    public void setClickXSqueeze(float clickXSqueeze) {
        this.clickXSqueeze = clickXSqueeze;
    }

    @Generated
    public float getClickYSqueeze() {
        return this.clickYSqueeze;
    }

    @Generated
    public void setClickYSqueeze(float clickYSqueeze) {
        this.clickYSqueeze = clickYSqueeze;
    }

    @Generated
    public float getClickZRotation() {
        return this.clickZRotation;
    }

    @Generated
    public void setClickZRotation(float clickZRotation) {
        this.clickZRotation = clickZRotation;
    }

    @Generated
    public float getHoverXSqueeze() {
        return this.hoverXSqueeze;
    }

    @Generated
    public void setHoverXSqueeze(float hoverXSqueeze) {
        this.hoverXSqueeze = hoverXSqueeze;
    }

    @Generated
    public float getHoverYSqueeze() {
        return this.hoverYSqueeze;
    }

    @Generated
    public void setHoverYSqueeze(float hoverYSqueeze) {
        this.hoverYSqueeze = hoverYSqueeze;
    }
}

