/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.description.ability.C2SChangeMode;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AbilityModeWidget
extends AbstractDescriptionWidget {
    private AbilityDescriptionScreen screen;
    private int step;

    public AbilityModeWidget(int x, int y, AbilityDescriptionScreen screen, int step) {
        super(x, y, 12, 12);
        this.screen = screen;
        this.step = step;
    }

    @Override
    public void onPress() {
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        List<String> modes = relic.getAbilityTemplate((LivingEntity)player, stack, this.screen.getSelectedAbility()).getModes();
        String currentMode = relic.getAbilityMode((LivingEntity)player, stack, this.screen.getSelectedAbility());
        int step = this.getStep();
        int currentIndex = modes.indexOf(currentMode);
        if (currentIndex == -1 || modes.isEmpty()) {
            return;
        }
        int newIndex = Math.floorMod(currentIndex + step, modes.size());
        String newMode = modes.get(newIndex);
        NetworkHandler.sendToServer(new C2SChangeMode(this.screen.getContainer(), this.screen.getSlot(), this.screen.getSelectedAbility(), newMode));
        this.screen.rebuildWidgets();
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        GUIRenderer.begin(this.step > 0 ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_arrow_right.png") : ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_arrow_left.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        if (this.isHovered()) {
            GUIRenderer.begin(this.step > 0 ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_arrow_right_selection.png") : ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_arrow_left_selection.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
        poseStack.popPose();
    }

    @Generated
    public AbilityDescriptionScreen getScreen() {
        return this.screen;
    }

    @Generated
    public int getStep() {
        return this.step;
    }
}

