/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.SimpleDescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AbilityStatisticContainerWidget
extends SimpleDescriptionContainerWidget {
    public AbilityStatisticContainerWidget(DescriptionScreen screen) {
        super(screen);
    }

    @Override
    public List<FormattedCharSequence> getContent() {
        DescriptionScreen descriptionScreen = this.getScreen();
        if (!(descriptionScreen instanceof AbilityDescriptionScreen)) {
            return new ArrayList<FormattedCharSequence>();
        }
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)descriptionScreen;
        ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        LocalPlayer player = this.minecraft.player;
        Font font = this.minecraft.font;
        int maxWidth = 320;
        String dot = ".";
        int dotWidth = Math.max(1, font.width(dot));
        String ability = screen.getSelectedAbility();
        LinkedHashMap<String, List> group = new LinkedHashMap<String, List>();
        HashMap<String, MutableComponent> conditions = new HashMap<String, MutableComponent>();
        for (AbilityMetricTemplate metric : relic.getAbilityStatisticTemplate((LivingEntity)player, stack, ability).getMetrics().values()) {
            VisibilityState state = metric.getVisibilityState().apply((LivingEntity)player, stack, ability);
            if (state == VisibilityState.HIDDEN) continue;
            MutableComponent condition = metric.getConditionComponent().apply((LivingEntity)player, stack, ability).withStyle(ChatFormatting.BOLD);
            String key = condition.getString().trim();
            MutableComponent prefix = Component.literal((String)"\u25cf ").append(metric.getDescriptionComponent().apply((LivingEntity)player, stack, ability)).append((Component)Component.literal((String)" "));
            if (state == VisibilityState.OBFUSCATED) {
                prefix = ScreenUtils.randomizeAllCharacters(prefix, this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
            }
            ArrayList<FormattedCharSequence> metricLines = new ArrayList<FormattedCharSequence>();
            if (state == VisibilityState.OBFUSCATED) {
                List lines = font.split((FormattedText)prefix, maxWidth);
                metricLines.addAll(lines);
            } else {
                MutableComponent suffix = Component.literal((String)" ").append((Component)Component.literal((String)metric.getFormatValue().apply(relic.getAbilityMetricComponent((LivingEntity)player, stack, ability, metric.getId()).getValue())).withStyle(ChatFormatting.BOLD));
                int suffixWidth = font.width((FormattedText)suffix);
                int limit = Math.max(0, maxWidth - suffixWidth);
                List lines = font.split((FormattedText)prefix, limit);
                for (int i = 0; i < lines.size(); ++i) {
                    FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                    if (i < lines.size() - 1) {
                        metricLines.add(line);
                        continue;
                    }
                    int avail = Math.max(0, maxWidth - font.width(line) - suffixWidth);
                    int dotsCount = Math.max(0, avail / dotWidth);
                    FormattedCharSequence dots = dotsCount > 0 ? FormattedCharSequence.forward((String)dot.repeat(dotsCount), (Style)Style.EMPTY) : FormattedCharSequence.EMPTY;
                    FormattedCharSequence seq = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{line, dots, suffix.getVisualOrderText()});
                    while (font.width(seq) > maxWidth && dotsCount > 0) {
                        dots = --dotsCount > 0 ? FormattedCharSequence.forward((String)dot.repeat(dotsCount), (Style)Style.EMPTY) : FormattedCharSequence.EMPTY;
                        seq = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{line, dots, suffix.getVisualOrderText()});
                    }
                    metricLines.add(seq);
                }
            }
            group.computeIfAbsent(key, k -> new ArrayList()).add(metricLines);
            if (key.isBlank() || conditions.containsKey(key)) continue;
            conditions.put(key, condition);
        }
        boolean firstGroup = true;
        for (Map.Entry entry : group.entrySet()) {
            if (!firstGroup) {
                sequences.addAll(font.split((FormattedText)Component.literal((String)" "), maxWidth));
            }
            firstGroup = false;
            String key = (String)entry.getKey();
            if (!key.isBlank() && conditions.containsKey(key) && !((MutableComponent)conditions.get(key)).equals((Object)Component.empty())) {
                sequences.addAll(font.split((FormattedText)conditions.get(key), maxWidth));
            }
            for (List metricLines : (List)entry.getValue()) {
                sequences.addAll(metricLines);
            }
        }
        return sequences;
    }
}

