/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.BigRelicCardWidget;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BigAbilityCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private AbilityDescriptionScreen screen;

    public BigAbilityCardWidget(int x, int y, AbilityDescriptionScreen screen) {
        super(x, y, 50, 87);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        String ability = this.screen.getSelectedAbility();
        boolean isUnlocked = relic.isAbilityUnlocked((LivingEntity)player, stack, ability);
        boolean canBeUpgraded = relic.canBeUpgraded((LivingEntity)player, stack, ability);
        poseStack.pushPose();
        float color = (float)((double)1.05f + Math.sin((float)(player.tickCount + ability.length() * 10) * 0.2f) * (double)0.1f);
        if (isUnlocked) {
            GUIRenderer.begin(DescriptionTextures.getAbilityCardTexture(stack, ability), poseStack).anchor(SpriteAnchor.TOP_LEFT).color(color, color, color, 1.0f).pos(this.getX() + 8, this.getY() + 20).texSize(34, 49).end();
        } else {
            GUIRenderer.begin(this.pickClosestBackground(stack, BigRelicCardWidget.BACKGROUNDS), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 8, this.getY() + 20).end();
        }
        GUIRenderer.begin(canBeUpgraded ? (isUnlocked ? DescriptionTextures.BIG_CARD_FRAME_UNLOCKED_ACTIVE : DescriptionTextures.BIG_CARD_FRAME_UNLOCKED_INACTIVE) : (isUnlocked ? DescriptionTextures.BIG_CARD_FRAME_LOCKED_ACTIVE : DescriptionTextures.BIG_CARD_FRAME_LOCKED_INACTIVE), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        List<String> modes = relic.getAbilityTemplate((LivingEntity)player, stack, ability).getModes();
        if (isUnlocked && !modes.isEmpty()) {
            GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_list.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 8, this.getY() + 11).end();
            int dotWidth = 4;
            int fieldWidth = 30;
            int amount = modes.size();
            if (amount > 0) {
                int totalWidth = amount * dotWidth;
                int margin = (fieldWidth - totalWidth) / (amount + 1);
                for (int index = 0; index < amount; ++index) {
                    int x = this.getX() + 11 + margin * (index + 1) + dotWidth * index;
                    GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_point.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x, this.getY() + 15).end();
                    if (index != modes.indexOf(relic.getAbilityMode((LivingEntity)player, stack, ability))) continue;
                    GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/ability/ability_mode_selection.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x - 1, this.getY() + 14).end();
                }
            }
        }
        int xOff = 0;
        if (isUnlocked && canBeUpgraded) {
            for (int i = 0; i < 5; ++i) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_HOLE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).end();
                xOff += 8;
            }
            xOff = 0;
            int quality = relic.calculateAbilityQuality((LivingEntity)player, stack, ability);
            boolean isAliquot = quality % 2 == 1;
            int i = 0;
            while ((double)i < Math.floor((double)quality / 2.0)) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).end();
                xOff += 8;
                ++i;
            }
            if (isAliquot) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 5, this.getY() + 72).patternSize(4, 7).texSize(8, 7).end();
            }
        }
        if (canBeUpgraded) {
            poseStack.pushPose();
            MutableComponent pointsComponent = Component.literal((String)(isUnlocked ? String.valueOf(relic.getAbilityLevel((LivingEntity)player, stack, ability)) : "?")).withStyle(ChatFormatting.BOLD);
            poseStack.scale(0.75f, 0.75f, 1.0f);
            guiGraphics.drawString(this.minecraft.font, (Component)pointsComponent, (int)(((float)this.getX() + 26.5f) * 1.33f - (float)this.minecraft.font.width((FormattedText)pointsComponent) / 2.0f), (int)(((float)this.getY() + 4.5f) * 1.33f), isUnlocked ? 16769656 : 12037849, false);
            poseStack.popPose();
        }
        if (isUnlocked && canBeUpgraded && this.isHovered()) {
            if (modes.isEmpty()) {
                GUIRenderer.begin(DescriptionTextures.BIG_CARD_FRAME_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
            } else {
                GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/big_card_frame_outline_modes.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 4, this.getY() - 1).end();
            }
        }
        poseStack.popPose();
    }

    private ResourceLocation pickClosestBackground(ItemStack itemStack, List<ResourceLocation> backgroundTextures) {
        int cardColor = BigRelicCardWidget.getTextureColor(DescriptionTextures.getAbilityCardTexture(itemStack, this.screen.getSelectedAbility()));
        return backgroundTextures.stream().min(Comparator.comparingDouble(texture -> BigRelicCardWidget.colorDistance(cardColor, BigRelicCardWidget.getTextureColor(texture)))).orElse(null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.screen.getStack();
        String ability = this.screen.getSelectedAbility();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem && (relic = (IRelicItem)item).isAbilityUnlocked((LivingEntity)player, stack, ability) && relic.canBeUpgraded((LivingEntity)player, stack, ability))) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.ability.info.level").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + relic.getAbilityLevel((LivingEntity)player, stack, ability) + "/" + relic.getAbilityTemplate((LivingEntity)player, stack, ability).getInitialMaxLevel()), Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.ability.info.quality").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + MathUtils.round((float)relic.calculateAbilityQuality((LivingEntity)player, stack, ability) / 2.0f, 1) + "/" + relic.getAbilityMaxQuality((LivingEntity)player, stack, ability) / 2), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"relics.description.researching.ability.info.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, this.getX() - renderWidth / 2 + 16, this.getY() + this.getHeight() - 2);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (this.getX() - renderWidth / 2 + 14 + 12) * 2, (this.getY() + yOff + this.getHeight() - 2 + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }
}

