/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base.AbstractAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.RelicsHotkeys;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketAbilityTweak;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ResetAbilityActionWidget
extends AbstractAbilityActionWidget {
    public ResetAbilityActionWidget(int x, int y, AbilityDescriptionScreen screen) {
        super(x, y, PacketAbilityTweak.Operation.RESET, screen);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getScreen().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerReset((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.TABLE_RESET.get()), (float)1.0f));
        }
    }

    @Override
    public List<MutableComponent> buildDescription() {
        List<MutableComponent> description = super.buildDescription();
        AbilityDescriptionScreen screen = this.getScreen();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        String ability = screen.getSelectedAbility();
        int key = RelicsHotkeys.RESEARCH_RELIC.getKey().getValue();
        boolean hasShiftDown = key != -1 && InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)key);
        MutableComponent newLine = Component.literal((String)" ");
        long currentExperience = EntityUtils.getPlayerTotalExperience((Player)player);
        int requiredExperience = relic.getResetPlayerExperienceCost((LivingEntity)player, stack, this.getAbility());
        boolean hasExperience = (long)requiredExperience <= currentExperience;
        int level = relic.getAbilityLevel((LivingEntity)player, stack, ability);
        boolean isMinLevel = level <= 0;
        description.add(Component.translatable((String)"relics.description.ability.reset.title").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
        description.add(newLine);
        if (isMinLevel) {
            description.add(Component.translatable((String)"relics.description.ability.reset.min_level").withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
        } else {
            description.add(Component.translatable((String)"relics.description.general.cost.title").withStyle(ChatFormatting.BOLD).append((Component)Component.literal((String)" ")));
            description.add(Component.literal((String)"   \u25cf ").append((Component)Component.translatable((String)"relics.description.ability.reset.cost.entry_1", (Object[])new Object[]{requiredExperience, hasExperience ? EntityUtils.calculateExperienceLevelLoss((Player)player, requiredExperience) : EntityUtils.getLevelFromTotalExperience(requiredExperience)}).withColor(hasExperience ? DescriptionUtils.POSITIVE_COLOR(true) : DescriptionUtils.NEGATIVE_COLOR(true))));
        }
        description.add(newLine);
        if (hasShiftDown) {
            description.add(Component.translatable((String)"relics.description.ability.reset.description").withStyle(ChatFormatting.ITALIC));
        } else {
            description.add(Component.translatable((String)"relics.general.hold_shift", (Object[])new Object[]{RelicsHotkeys.RESEARCH_RELIC.getKey().getDisplayName().getString()}));
        }
        return description;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList tooltip = new ArrayList();
        PoseStack poseStack = guiGraphics.pose();
        int maxWidth = 150;
        int renderWidth = 0;
        for (MutableComponent entry : this.buildDescription()) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

