/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketAbilityTweak;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractAbilityActionWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private final PacketAbilityTweak.Operation operation;
    private final AbilityDescriptionScreen screen;

    public AbstractAbilityActionWidget(int x, int y, PacketAbilityTweak.Operation operation, AbilityDescriptionScreen screen) {
        super(x, y, 14, 14);
        this.operation = operation;
        this.screen = screen;
    }

    @Override
    public abstract boolean isLocked();

    public String getAbility() {
        return this.getScreen().getSelectedAbility();
    }

    @Override
    public void onPress() {
        if (!this.isLocked()) {
            NetworkHandler.sendToServer(new PacketAbilityTweak(this.getScreen().getContainer(), this.getScreen().getSlot(), this.getAbility(), this.getOperation(), Screen.hasShiftDown()));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        String actionId = this.getOperation().toString().toLowerCase(Locale.ROOT);
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/ability/" + actionId + "_button_" + (this.isLocked() ? "inactive" : "active") + ".png")), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.ACTION_BUTTON_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
    }

    public List<MutableComponent> buildDescription() {
        return new ArrayList<MutableComponent>();
    }

    @Generated
    public PacketAbilityTweak.Operation getOperation() {
        return this.operation;
    }

    @Generated
    public AbilityDescriptionScreen getScreen() {
        return this.screen;
    }
}

