/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.particle.ExtendedUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.particle.PixelUIParticle;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import org.joml.Vector2f;

public class LogoWidget
extends AbstractDescriptionWidget
implements ITickingWidget {
    private DescriptionScreen screen;
    private float xSqueeze = 1.0f;
    private float ySqueeze = 1.0f;
    private static int CLICKS_AMOUNT = 0;
    private static final int MAX_CLICKS = 6;
    private static int NO_CLICK_DURATION = 0;
    private static final int MAX_NO_CLICK_DURATION = 100;

    public LogoWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, 55, 18);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float color = (float)((double)1.05f + Math.sin((float)player.tickCount * 0.25f) * (double)0.1f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.LOGO);
        poseStack.translate((double)((float)this.getX() + (float)this.width / 2.0f) + Math.sin(((float)player.tickCount + pPartialTick) * 0.075f), (double)((float)this.getY() + (float)this.height / 2.0f) + Math.cos(((float)player.tickCount + pPartialTick) * 0.075f) * 0.5, 100.0);
        float modifier = 1.0f + (float)LogoWidget.getCurrentClicks() * 0.15f;
        poseStack.scale(this.getXSqueeze(), this.getYSqueeze(), 1.0f);
        poseStack.scale(modifier, modifier, 1.0f);
        GUIRenderer.begin(DescriptionTextures.LOGO, poseStack).anchor(SpriteAnchor.CENTER).patternSize(55, 18).animation(AnimationData.construct(576, 18, 2)).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @Override
    public void onPress() {
        super.onPress();
        float intensity = 0.75f + (float)LogoWidget.getCurrentClicks() * 0.15f;
        float yPeak = 1.0f + 0.100000024f * intensity;
        float xPeak = 1.0f + 0.20000005f * intensity;
        float yValley = 1.0f - 0.050000012f * intensity;
        float xValley = 1.0f - 0.100000024f * intensity;
        Tween tween = Tween.create().setParallel(true);
        tween.tweenMethod(this::setYSqueeze, (Object)Float.valueOf(this.getYSqueeze()), (Object)Float.valueOf(yPeak), 0.2).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
        tween.tweenMethod(this::setXSqueeze, (Object)Float.valueOf(this.getXSqueeze()), (Object)Float.valueOf(xPeak), 0.15).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
        tween.tweenMethod(this::setYSqueeze, (Object)Float.valueOf(yPeak), (Object)Float.valueOf(yValley), 0.18).setDelay(0.2).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
        tween.tweenMethod(this::setXSqueeze, (Object)Float.valueOf(xPeak), (Object)Float.valueOf(xValley), 0.17).setDelay(0.15).setEaseType(EaseType.EASE_IN_OUT).setTransitionType(TransitionType.QUAD);
        tween.tweenMethod(this::setYSqueeze, (Object)Float.valueOf(yValley), (Object)Float.valueOf(1.0f), 0.25).setDelay(0.38).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
        tween.tweenMethod(this::setXSqueeze, (Object)Float.valueOf(xValley), (Object)Float.valueOf(1.0f), 0.2).setDelay(0.32).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
        tween.start();
        LogoWidget.setNoClickDuration(0);
        int remainingClicks = LogoWidget.getRemainingClicks();
        if (remainingClicks > 0) {
            LogoWidget.addCurrentClicks(1);
        }
        if (remainingClicks <= 1) {
            float size;
            ExtendedUIParticle particle;
            int i;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.LOGO_EXPLOSION.get()), (float)1.0f, (float)1.0f));
            RandomSource random = this.minecraft.player.getRandom();
            for (i = 0; i < 100; ++i) {
                particle = new ExtendedUIParticle(new UIParticle.Texture2D(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/particle/logo_air.png"), 0, 0, 10, 10, 10, 10), 5.0f, random.nextInt(50, 100), (float)(this.getX() + random.nextInt(this.getWidth())), (float)(this.getY() + random.nextInt(this.getHeight())), UIParticle.Layer.SCREEN, 10.0f);
                size = random.nextFloat() * 0.5f + 0.75f;
                particle.setColors(new OctoColor[]{new OctoColor(1.0f, 1.0f, 1.0f, 1.0f), new OctoColor(1.0f, 1.0f, 1.0f, 0.0f)});
                particle.setDirection(MathUtils.randomFloat(random), -random.nextFloat() * 0.5f);
                particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
                particle.getTransform().setSize(new Vector2f(size, size));
                particle.setGravityDirection(0.0f, -1.0f);
                particle.setScreen((Screen)this.screen);
                particle.setGravity(0.01f);
                particle.setFriction(0.075f);
                particle.setSpeed(random.nextFloat() * 5.0f);
                particle.instantiate();
            }
            for (i = 0; i < 20; ++i) {
                particle = new ExtendedUIParticle(new UIParticle.Texture2D(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/particle/logo_part_" + (random.nextInt(4) + 1) + ".png")), 0, 0, 10, 10, 10, 10), 5.0f, random.nextInt(50, 100), (float)(this.getX() + random.nextInt(this.getWidth())), (float)(this.getY() + random.nextInt(this.getHeight())), UIParticle.Layer.SCREEN, 10.0f);
                size = random.nextFloat() * 0.5f + 0.75f;
                particle.setColors(new OctoColor[]{new OctoColor(1.0f, 1.0f, 1.0f, 1.0f), new OctoColor(1.0f, 1.0f, 1.0f, 0.0f)});
                particle.setDirection(MathUtils.randomFloat(random), MathUtils.randomFloat(random) * 0.5f);
                particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
                particle.getTransform().setSize(new Vector2f(size, size));
                particle.setGravityDirection(0.0f, 1.0f);
                particle.setScreen((Screen)this.screen);
                particle.setGravity(0.25f);
                particle.enableBlend(false);
                particle.setSpeed(random.nextFloat() * 3.5f);
                particle.instantiate();
            }
            this.screen.rebuildWidgets();
        } else {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.LOGO_INFLATE.get()), (float)(1.0f + (float)LogoWidget.getCurrentClicks() * 0.16666667f)));
        }
    }

    @Override
    public void onTick() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        int noClickDuration = LogoWidget.getNoClickDuration();
        int currentClicks = LogoWidget.getCurrentClicks();
        if (noClickDuration < 100) {
            LogoWidget.addNoClickDuration(1);
        } else if (currentClicks > 0 && currentClicks < 6 && player.tickCount % 10 == 0) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RelicsSounds.LOGO_INFLATE.get()), (float)1.0f));
            float intensity = 1.6500001f;
            float yPeak = 1.0f + 0.20000005f * intensity;
            float xPeak = 1.0f + 0.39999998f * intensity;
            float yValley = 1.0f - 0.100000024f * intensity;
            float xValley = 1.0f - 0.14999998f * intensity;
            Tween tween = Tween.create().setParallel(true);
            tween.tweenMethod(this::setYSqueeze, (Object)Float.valueOf(yPeak), (Object)Float.valueOf(yValley), 0.2).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setXSqueeze, (Object)Float.valueOf(xPeak), (Object)Float.valueOf(xValley), 0.15).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setYSqueeze, (Object)Float.valueOf(yValley), (Object)Float.valueOf(1.0f), 0.25).setDelay(0.2).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            tween.tweenMethod(this::setXSqueeze, (Object)Float.valueOf(xValley), (Object)Float.valueOf(1.0f), 0.2).setDelay(0.15).setEaseType(EaseType.EASE_IN).setTransitionType(TransitionType.QUAD);
            tween.start();
            LogoWidget.setCurrentClicks(0);
        }
        RandomSource random = player.getRandom();
        if (this.minecraft.player.tickCount % 2 == 0) {
            float widthModifier = 1.0f + (float)LogoWidget.getCurrentClicks() * 0.15f;
            float heightModifier = (float)LogoWidget.getCurrentClicks() * 1.5f;
            int semiWidth = (int)((float)this.width * widthModifier / 2.0f);
            PixelUIParticle particle = new PixelUIParticle(0.4f, random.nextInt(30, 50), (float)this.getX() + (float)this.width / 2.0f + (float)random.nextInt(-semiWidth, semiWidth), (float)(this.getY() + random.nextInt(3)) - heightModifier, UIParticle.Layer.SCREEN, 10.0f);
            float size = random.nextFloat() * 0.5f + 0.75f + (float)LogoWidget.getCurrentClicks() * 0.1f;
            particle.setColors(new OctoColor[]{new OctoColor(1.0f, 1.0f, random.nextFloat() * 0.25f, 1.0f), new OctoColor(1.0f, 0.0f, 0.0f, 0.0f)});
            particle.setDirection(MathUtils.randomFloat(random) * 0.5f, random.nextFloat() * -0.5f);
            particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
            particle.getTransform().setSize(new Vector2f(size, size));
            particle.setGravityDirection(0.0f, -1.0f);
            particle.setAngularVelocity(10.0f);
            particle.setScreen(this.screen);
            particle.setFriction(0.025f);
            particle.setGravity(0.035f);
            particle.instantiate();
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    public static int getCurrentClicks() {
        return CLICKS_AMOUNT;
    }

    public static void setCurrentClicks(int clicks) {
        CLICKS_AMOUNT = Math.clamp((long)clicks, 0, 6);
    }

    public static void addCurrentClicks(int clicks) {
        LogoWidget.setCurrentClicks(LogoWidget.getCurrentClicks() + clicks);
    }

    public static int getRemainingClicks() {
        return 6 - LogoWidget.getCurrentClicks();
    }

    public static int getNoClickDuration() {
        return NO_CLICK_DURATION;
    }

    public static void setNoClickDuration(int duration) {
        NO_CLICK_DURATION = Math.clamp((long)duration, 0, 100);
    }

    public static void addNoClickDuration(int duration) {
        LogoWidget.setNoClickDuration(LogoWidget.getNoClickDuration() + duration);
    }

    @Generated
    public DescriptionScreen getScreen() {
        return this.screen;
    }

    @Generated
    public float getXSqueeze() {
        return this.xSqueeze;
    }

    @Generated
    public void setXSqueeze(float xSqueeze) {
        this.xSqueeze = xSqueeze;
    }

    @Generated
    public float getYSqueeze() {
        return this.ySqueeze;
    }

    @Generated
    public void setYSqueeze(float ySqueeze) {
        this.ySqueeze = ySqueeze;
    }
}

