/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IScrollableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollbarWidget
extends AbstractDescriptionWidget
implements ITickingWidget {
    private final IScrollableWidget container;
    private double scrollPosition = 0.0;
    private double prevScrollPosition = 0.0;
    private double scrollVelocity = 0.0;
    private static final double FRICTION = 0.5;
    private boolean dragging = false;
    private double dragOffsetY = 0.0;
    private static final int TRACK_WIDTH = 10;
    private static final int TRACK_HEIGHT = 57;
    private static final int SLIDER_WIDTH = 10;
    private static final int SLIDER_HEIGHT = 12;
    private static final int SLIDER_OFFSET_X = -1;
    private static final int SLIDER_OFFSET_Y = 6;

    public ScrollbarWidget(int x, int y, IScrollableWidget container) {
        super(x, y, 10, 57);
        this.container = container;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/top_scroll_bar.png"), poseStack).pos(this.getX(), this.getY() - 20).anchor(SpriteAnchor.TOP_LEFT).end();
        if (!this.isLocked()) {
            int usableTrackHeight = 41;
            int sliderX = this.getX() + -1;
            int sliderY = this.getY() + 6 + (int)Math.round(this.getScrollPosition(partialTick) * (double)usableTrackHeight);
            float color = (float)(((AbstractWidget)this.container).isHovered() ? 1.0 + Math.sin((double)System.currentTimeMillis() * 0.01) * 0.1 : 1.0);
            poseStack.translate((float)sliderX + 5.0f, (float)sliderY, 0.0f);
            double distance = Math.min(Math.abs(this.prevScrollPosition - this.scrollPosition) * (double)1.1f, (double)0.35f);
            poseStack.scale((float)(1.0 - distance), (float)(1.0 + distance * 2.5), 1.0f);
            GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/scroll_bar_slider.png"), poseStack).color(color, color, color, 1.0f).anchor(SpriteAnchor.CENTER).end();
            if (this.isHoveringSlider(mouseX, mouseY)) {
                GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/scroll_bar_slider_selection.png"), poseStack).anchor(SpriteAnchor.CENTER).end();
            }
        }
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        this.prevScrollPosition = this.scrollPosition;
        this.scrollPosition += this.scrollVelocity;
        this.scrollVelocity *= 0.5;
        if (Math.abs(this.scrollVelocity) < 5.0E-4) {
            this.scrollVelocity = 0.0;
        }
        if (this.scrollPosition < 0.0) {
            this.scrollPosition = 0.0;
            this.scrollVelocity = 0.0;
        } else if (this.scrollPosition > 1.0) {
            this.scrollPosition = 1.0;
            this.scrollVelocity = 0.0;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isLocked() || button != 0 || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.dragOffsetY = this.isHoveringSlider(mouseX, mouseY) ? mouseY - this.getSliderTopY() : 6.0;
        this.dragging = true;
        this.updateScrollPositionFromMouse(mouseX, mouseY);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isLocked() || !this.dragging || button != 0) {
            return false;
        }
        this.scrollVelocity = 0.0;
        this.updateScrollPositionFromMouse(mouseX, mouseY);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isLocked() || button != 0) {
            return false;
        }
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    private void updateScrollPositionFromMouse(double mouseX, double mouseY) {
        int trackStartY = this.getY() + 6;
        int usableTrackHeight = 41;
        double relativeY = mouseY - this.dragOffsetY - (double)trackStartY;
        this.scrollPosition = Math.clamp(relativeY / (double)usableTrackHeight, 0.0, 1.0);
    }

    public boolean isHoveringSlider(double mouseX, double mouseY) {
        double sliderTop = this.getSliderTopY();
        return mouseX >= (double)(this.getX() + -1) && mouseX <= (double)(this.getX() + -1 + 10) && mouseY + 6.0 >= sliderTop && mouseY + 6.0 <= sliderTop + 12.0;
    }

    private double getSliderTopY() {
        int usableTrackHeight = 41;
        return (double)(this.getY() + 6) + this.scrollPosition * (double)usableTrackHeight;
    }

    public double getScrollPosition(float partialTicks) {
        return Mth.lerp((double)partialTicks, (double)this.prevScrollPosition, (double)this.scrollPosition);
    }

    @Override
    public boolean isLocked() {
        Objects.requireNonNull(this.minecraft.font);
        float unit = (float)(9 + 2) / 2.0f;
        float threshold = 9.0f * unit;
        return (float)this.container.getContentHeight() <= threshold;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isLocked() || !this.isMouseOver(mouseX, mouseY) && !((AbstractWidget)this.container).isHovered()) {
            return false;
        }
        Objects.requireNonNull(this.minecraft.font);
        float unit = (float)(9 + 2) / 2.0f;
        float extraHeight = (float)this.container.getContentHeight() - 9.0f * unit;
        float maxScrollPixels = Math.max(1.0f, extraHeight);
        double scrollDelta = (double)unit / (double)maxScrollPixels * scrollY;
        this.scrollVelocity -= scrollDelta;
        return true;
    }
}

