/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets.base;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractPlateWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private DescriptionScreen screen;
    private final String icon;

    public abstract String getValue(ItemStack var1);

    public AbstractPlateWidget(int x, int y, DescriptionScreen screen, String icon) {
        super(x, y, 55, 20);
        this.screen = screen;
        this.icon = icon;
    }

    public final void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = this.minecraft.player;
        poseStack.pushPose();
        poseStack.translate((double)this.getX() + Math.sin(((double)((float)player.tickCount + pPartialTick) + (double)this.icon.length() * 10.0) * 0.075), (double)this.getY() + Math.cos(((double)((float)player.tickCount + pPartialTick) + (double)this.icon.length() * 10.0) * 0.075) * 0.5, 0.0);
        GUIRenderer.begin(DescriptionTextures.PLATE_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).end();
        poseStack.translate(0.0f, 0.0f, 10.0f);
        this.renderIcon(guiGraphics, 3, 3, pMouseX, pMouseY, pPartialTick);
        MutableComponent value = Component.literal((String)this.getValue(this.screen.getStack())).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(this.minecraft.font, (Component)value, 20, 7, 16769656, true);
        this.renderContent(guiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.PLATE_OUTLINE, poseStack).pos(-1.0f, -1.0f).anchor(SpriteAnchor.TOP_LEFT).end();
        }
        poseStack.popPose();
    }

    public void renderIcon(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/general/icons/" + this.icon + ".png")), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x, y).end();
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = new ArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        List<MutableComponent> entries = this.getHoverTooltip();
        if (entries.isEmpty()) {
            return;
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    public List<MutableComponent> getHoverTooltip() {
        return new ArrayList<MutableComponent>();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    @Generated
    public DescriptionScreen getScreen() {
        return this.screen;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }
}

